/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.MathUtilities;
import java.io.UnsupportedEncodingException;
import java.util.Optional;
import java.util.Random;

public final class StringUtilities {
    private static char[] _hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static String FOLDER_SEPARATOR = "/";
    public static String EMPTY = "";

    private StringUtilities() {
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String s1, String s2) {
        return StringUtilities.equals((CharSequence)s1, (CharSequence)s2);
    }

    public static boolean equalsIgnoreCase(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        return StringUtilities.regionMatches(cs1, true, 0, cs2, 0, cs1.length());
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return StringUtilities.equalsIgnoreCase((CharSequence)s1, (CharSequence)s2);
    }

    static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        Convention.throwIfNull(cs, "cs to be processed cannot be null");
        Convention.throwIfNull(substring, "substring cannot be null");
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (srcLen < length || otherLen < length) {
            return false;
        }
        while (tmpLen-- > 0) {
            char u2;
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            char u1 = Character.toUpperCase(c1);
            if (u1 == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsWithTrim(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.trim().equals(s2.trim());
    }

    public static boolean equalsIgnoreCaseWithTrim(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.trim().equalsIgnoreCase(s2.trim());
    }

    public static boolean isEmpty(CharSequence cs) {
        return StringUtilities.isWhitespace(cs);
    }

    public static boolean isEmpty(String s) {
        return StringUtilities.isWhitespace(s);
    }

    public static boolean isWhitespace(CharSequence cs) {
        int strLen = StringUtilities.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasContent(String s) {
        return !StringUtilities.isWhitespace(s);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static int length(String s) {
        return s == null ? 0 : s.length();
    }

    public static int trimLength(String s) {
        return StringUtilities.trimToEmpty(s).length();
    }

    public static int lastIndexOf(String path, char ch) {
        if (path == null) {
            return -1;
        }
        return path.lastIndexOf(ch);
    }

    public static byte[] decode(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            return null;
        }
        byte[] bytes = new byte[len / 2];
        int pos = 0;
        for (int i = 0; i < len; i += 2) {
            byte hi = (byte)Character.digit(s.charAt(i), 16);
            byte lo = (byte)Character.digit(s.charAt(i + 1), 16);
            bytes[pos++] = (byte)(hi * 16 + lo);
        }
        return bytes;
    }

    public static String encode(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length << 1);
        for (byte aByte : bytes) {
            sb.append(StringUtilities.convertDigit(aByte >> 4));
            sb.append(StringUtilities.convertDigit(aByte & 0xF));
        }
        return sb.toString();
    }

    private static char convertDigit(int value) {
        return _hex[value & 0xF];
    }

    public static int count(String s, char c) {
        return StringUtilities.count((CharSequence)s, EMPTY + c);
    }

    public static int count(CharSequence content, CharSequence token) {
        if (content == null || token == null) {
            return 0;
        }
        String source = content.toString();
        if (source.isEmpty()) {
            return 0;
        }
        String sub = token.toString();
        if (sub.isEmpty()) {
            return 0;
        }
        int answer = 0;
        int idx = 0;
        while ((idx = source.indexOf(sub, idx)) >= answer) {
            ++answer;
            ++idx;
        }
        return answer;
    }

    public static String wildcardToRegexString(String wildcard) {
        int len = wildcard.length();
        StringBuilder s = new StringBuilder(len);
        s.append('^');
        block5: for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append('.');
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append('\\');
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public static int levenshteinDistance(CharSequence s, CharSequence t) {
        if (s == null || EMPTY.contentEquals(s)) {
            return t == null || EMPTY.contentEquals(t) ? 0 : t.length();
        }
        if (t == null || EMPTY.contentEquals(t)) {
            return s.length();
        }
        int[] v0 = new int[t.length() + 1];
        int[] v1 = new int[t.length() + 1];
        for (int i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        int sLen = s.length();
        int tLen = t.length();
        for (int i = 0; i < sLen; ++i) {
            v1[0] = i + 1;
            for (int j = 0; j < tLen; ++j) {
                int cost = s.charAt(i) == t.charAt(j) ? 0 : 1;
                v1[j + 1] = (int)MathUtilities.minimum(new long[]{v1[j] + 1, v0[j + 1] + 1, v0[j] + cost});
            }
            System.arraycopy(v1, 0, v0, 0, v0.length);
        }
        return v1[t.length()];
    }

    public static int damerauLevenshteinDistance(CharSequence source, CharSequence target) {
        int srcIndex;
        if (source == null || EMPTY.contentEquals(source)) {
            return target == null || EMPTY.contentEquals(target) ? 0 : target.length();
        }
        if (target == null || EMPTY.contentEquals(target)) {
            return source.length();
        }
        int srcLen = source.length();
        int targetLen = target.length();
        int[][] distanceMatrix = new int[srcLen + 1][targetLen + 1];
        for (srcIndex = 0; srcIndex <= srcLen; ++srcIndex) {
            distanceMatrix[srcIndex][0] = srcIndex;
        }
        for (int targetIndex = 0; targetIndex <= targetLen; ++targetIndex) {
            distanceMatrix[0][targetIndex] = targetIndex;
        }
        for (srcIndex = 1; srcIndex <= srcLen; ++srcIndex) {
            for (int targetIndex = 1; targetIndex <= targetLen; ++targetIndex) {
                int cost = source.charAt(srcIndex - 1) == target.charAt(targetIndex - 1) ? 0 : 1;
                distanceMatrix[srcIndex][targetIndex] = (int)MathUtilities.minimum(new long[]{distanceMatrix[srcIndex - 1][targetIndex] + 1, distanceMatrix[srcIndex][targetIndex - 1] + 1, distanceMatrix[srcIndex - 1][targetIndex - 1] + cost});
                if (srcIndex == 1 || targetIndex == 1 || source.charAt(srcIndex - 1) != target.charAt(targetIndex - 2) || source.charAt(srcIndex - 2) != target.charAt(targetIndex - 1)) continue;
                distanceMatrix[srcIndex][targetIndex] = (int)MathUtilities.minimum(new long[]{distanceMatrix[srcIndex][targetIndex], distanceMatrix[srcIndex - 2][targetIndex - 2] + cost});
            }
        }
        return distanceMatrix[srcLen][targetLen];
    }

    public static String getRandomString(Random random, int minLen, int maxLen) {
        StringBuilder s = new StringBuilder();
        int len = minLen + random.nextInt(maxLen - minLen + 1);
        for (int i = 0; i < len; ++i) {
            s.append(StringUtilities.getRandomChar(random, i == 0));
        }
        return s.toString();
    }

    public static String getRandomChar(Random random, boolean upper) {
        int r = random.nextInt(26);
        return upper ? EMPTY + (char)(65 + r) : EMPTY + (char)(97 + r);
    }

    public static byte[] getBytes(String s, String encoding) {
        try {
            return s == null ? null : s.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Encoding (%s) is not supported by your JVM", encoding), e);
        }
    }

    public static String createUtf8String(byte[] bytes) {
        return StringUtilities.createString(bytes, "UTF-8");
    }

    public static byte[] getUTF8Bytes(String s) {
        return StringUtilities.getBytes(s, "UTF-8");
    }

    public static String createString(byte[] bytes, String encoding) {
        try {
            return bytes == null ? null : new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Encoding (%s) is not supported by your JVM", encoding), e);
        }
    }

    public static String createUTF8String(byte[] bytes) {
        return StringUtilities.createString(bytes, "UTF-8");
    }

    public static int hashCodeIgnoreCase(String s) {
        if (s == null) {
            return 0;
        }
        int len = s.length();
        int hash = 0;
        for (int i = 0; i < len; ++i) {
            hash = 31 * hash + Character.toLowerCase((int)s.charAt(i));
        }
        return hash;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToEmpty(String value) {
        return value == null ? EMPTY : value.trim();
    }

    public static String trimToNull(String value) {
        String ts = StringUtilities.trim(value);
        return StringUtilities.isEmpty(ts) ? null : ts;
    }

    public static String trimEmptyToDefault(String value, String defaultValue) {
        return Optional.ofNullable(value).map(StringUtilities::trimToNull).orElse(defaultValue);
    }
}

