/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.DurationConversions;
import com.cedarsoftware.util.convert.InstantConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

final class TimestampConversions {
    private TimestampConversions() {
    }

    static double toDouble(Object from, Converter converter) {
        Duration d = TimestampConversions.toDuration(from, converter);
        return (double)d.getSeconds() + (double)d.getNano() / 1.0E9;
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Timestamp timestamp = (Timestamp)from;
        Instant instant = timestamp.toInstant();
        return InstantConversions.toBigDecimal(instant, converter);
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Duration duration = TimestampConversions.toDuration(from, converter);
        return DurationConversions.toBigInteger(duration, converter);
    }

    static Duration toDuration(Object from, Converter converter) {
        Timestamp timestamp = (Timestamp)from;
        Instant epoch = Instant.EPOCH;
        Instant timestampInstant = timestamp.toInstant();
        return Duration.between(epoch, timestampInstant);
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        Timestamp timestamp = (Timestamp)from;
        ZonedDateTime zonedDateTime = ZonedDateTime.now(converter.getOptions().getZoneId());
        ZoneOffset zoneOffset = zonedDateTime.getOffset();
        return timestamp.toInstant().atOffset(zoneOffset);
    }
}

