/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.AbstractConcurrentNullSafeMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class ConcurrentNavigableMapNullSafe<K, V>
extends AbstractConcurrentNullSafeMap<K, V>
implements ConcurrentNavigableMap<K, V> {
    private final Comparator<? super K> originalComparator;
    private static final String NULL_KEY_SENTINEL = "null_" + UUID.randomUUID();

    public ConcurrentNavigableMapNullSafe() {
        this((Comparator<K>)null);
    }

    public ConcurrentNavigableMapNullSafe(Comparator<? super K> comparator) {
        this(new ConcurrentSkipListMap<Object, Object>(ConcurrentNavigableMapNullSafe.wrapComparator(comparator)), comparator);
    }

    private ConcurrentNavigableMapNullSafe(ConcurrentNavigableMap<Object, Object> internalMap, Comparator<? super K> originalComparator) {
        super(internalMap);
        this.originalComparator = originalComparator;
    }

    private static <K> Comparator<Object> wrapComparator(Comparator<? super K> comparator) {
        return (o1, o2) -> {
            String className2;
            boolean o1IsNullSentinel = NULL_KEY_SENTINEL.equals(o1);
            boolean o2IsNullSentinel = NULL_KEY_SENTINEL.equals(o2);
            if (o1IsNullSentinel && o2IsNullSentinel) {
                return 0;
            }
            if (o1IsNullSentinel) {
                return 1;
            }
            if (o2IsNullSentinel) {
                return -1;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (comparator != null) {
                return comparator.compare((Object)o1, (Object)o2);
            }
            if (o1.getClass() == o2.getClass() && o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            String className1 = o1.getClass().getName();
            int classComparison = className1.compareTo(className2 = o2.getClass().getName());
            if (classComparison != 0) {
                return classComparison;
            }
            return Integer.compare(System.identityHashCode(o1.getClass()), System.identityHashCode(o2.getClass()));
        };
    }

    @Override
    protected Object maskNullKey(K key) {
        if (key == null) {
            return NULL_KEY_SENTINEL;
        }
        return key;
    }

    @Override
    protected K unmaskNullKey(Object maskedKey) {
        if (NULL_KEY_SENTINEL.equals(maskedKey)) {
            return null;
        }
        return (K)maskedKey;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.originalComparator;
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        NavigableMap subInternal = ((ConcurrentNavigableMap)this.internalMap).subMap(this.maskNullKey(fromKey), fromInclusive, this.maskNullKey(toKey), toInclusive);
        return new ConcurrentNavigableMapNullSafe<K, V>((ConcurrentNavigableMap<Object, Object>)subInternal, this.originalComparator);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        NavigableMap headInternal = ((ConcurrentNavigableMap)this.internalMap).headMap(this.maskNullKey(toKey), inclusive);
        return new ConcurrentNavigableMapNullSafe<K, V>((ConcurrentNavigableMap<Object, Object>)headInternal, this.originalComparator);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        NavigableMap tailInternal = ((ConcurrentNavigableMap)this.internalMap).tailMap(this.maskNullKey(fromKey), inclusive);
        return new ConcurrentNavigableMapNullSafe<K, V>((ConcurrentNavigableMap<Object, Object>)tailInternal, this.originalComparator);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).lowerEntry(this.maskNullKey(key));
        return this.wrapEntry(entry);
    }

    @Override
    public K lowerKey(K key) {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).lowerKey(this.maskNullKey(key)));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).floorEntry(this.maskNullKey(key));
        return this.wrapEntry(entry);
    }

    @Override
    public K floorKey(K key) {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).floorKey(this.maskNullKey(key)));
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).ceilingEntry(this.maskNullKey(key));
        return this.wrapEntry(entry);
    }

    @Override
    public K ceilingKey(K key) {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).ceilingKey(this.maskNullKey(key)));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).higherEntry(this.maskNullKey(key));
        return this.wrapEntry(entry);
    }

    @Override
    public K higherKey(K key) {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).higherKey(this.maskNullKey(key)));
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).firstEntry();
        return this.wrapEntry(entry);
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).lastEntry();
        return this.wrapEntry(entry);
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).pollFirstEntry();
        return this.wrapEntry(entry);
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).pollLastEntry();
        return this.wrapEntry(entry);
    }

    @Override
    public K firstKey() {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).firstKey());
    }

    @Override
    public K lastKey() {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).lastKey());
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return this.keySet();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        NavigableMap descInternal = ((ConcurrentNavigableMap)this.internalMap).descendingMap();
        return new ConcurrentNavigableMapNullSafe<K, V>((ConcurrentNavigableMap<Object, Object>)descInternal, this.originalComparator);
    }

    @Override
    public NavigableSet<K> keySet() {
        Set<Object> internalKeys = this.internalMap.keySet();
        return new KeyNavigableSet(internalKeys);
    }

    private Map.Entry<K, V> wrapEntry(final Map.Entry<Object, Object> internalEntry) {
        if (internalEntry == null) {
            return null;
        }
        return new Map.Entry<K, V>(){
            final /* synthetic */ ConcurrentNavigableMapNullSafe this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public K getKey() {
                return this.this$0.unmaskNullKey(internalEntry.getKey());
            }

            @Override
            public V getValue() {
                return this.this$0.unmaskNullValue(internalEntry.getValue());
            }

            @Override
            public V setValue(V value) {
                Object oldValue = internalEntry.setValue(this.this$0.maskNullValue(value));
                return this.this$0.unmaskNullValue(oldValue);
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
            }

            @Override
            public int hashCode() {
                return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
            }

            public String toString() {
                return this.getKey() + "=" + this.getValue();
            }
        };
    }

    private class KeyNavigableSet
    extends AbstractSet<K>
    implements NavigableSet<K> {
        private final Set<Object> internalKeys;

        KeyNavigableSet(Set<Object> internalKeys) {
            this.internalKeys = internalKeys;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator<Object> it = this.internalKeys.iterator();
            return new Iterator<K>(){
                final /* synthetic */ KeyNavigableSet this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public K next() {
                    return this.this$1.ConcurrentNavigableMapNullSafe.this.unmaskNullKey(it.next());
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.internalKeys.size();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentNavigableMapNullSafe.this.internalMap.containsKey(ConcurrentNavigableMapNullSafe.this.maskNullKey(o));
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentNavigableMapNullSafe.this.internalMap.remove(ConcurrentNavigableMapNullSafe.this.maskNullKey(o)) != null;
        }

        @Override
        public void clear() {
            ConcurrentNavigableMapNullSafe.this.internalMap.clear();
        }

        @Override
        public K lower(K k) {
            return ConcurrentNavigableMapNullSafe.this.unmaskNullKey(((ConcurrentSkipListMap)ConcurrentNavigableMapNullSafe.this.internalMap).lowerKey(ConcurrentNavigableMapNullSafe.this.maskNullKey(k)));
        }

        @Override
        public K floor(K k) {
            return ConcurrentNavigableMapNullSafe.this.unmaskNullKey(((ConcurrentSkipListMap)ConcurrentNavigableMapNullSafe.this.internalMap).floorKey(ConcurrentNavigableMapNullSafe.this.maskNullKey(k)));
        }

        @Override
        public K ceiling(K k) {
            return ConcurrentNavigableMapNullSafe.this.unmaskNullKey(((ConcurrentSkipListMap)ConcurrentNavigableMapNullSafe.this.internalMap).ceilingKey(ConcurrentNavigableMapNullSafe.this.maskNullKey(k)));
        }

        @Override
        public K higher(K k) {
            return ConcurrentNavigableMapNullSafe.this.unmaskNullKey(((ConcurrentSkipListMap)ConcurrentNavigableMapNullSafe.this.internalMap).higherKey(ConcurrentNavigableMapNullSafe.this.maskNullKey(k)));
        }

        @Override
        public K pollFirst() {
            Map.Entry entry = ((ConcurrentSkipListMap)ConcurrentNavigableMapNullSafe.this.internalMap).pollFirstEntry();
            return entry == null ? null : (Object)ConcurrentNavigableMapNullSafe.this.unmaskNullKey(entry.getKey());
        }

        @Override
        public K pollLast() {
            Map.Entry entry = ((ConcurrentSkipListMap)ConcurrentNavigableMapNullSafe.this.internalMap).pollLastEntry();
            return entry == null ? null : (Object)ConcurrentNavigableMapNullSafe.this.unmaskNullKey(entry.getKey());
        }

        @Override
        public Comparator<? super K> comparator() {
            return ConcurrentNavigableMapNullSafe.this.comparator();
        }

        @Override
        public K first() {
            return ConcurrentNavigableMapNullSafe.this.unmaskNullKey(((ConcurrentSkipListMap)ConcurrentNavigableMapNullSafe.this.internalMap).firstKey());
        }

        @Override
        public K last() {
            return ConcurrentNavigableMapNullSafe.this.unmaskNullKey(((ConcurrentSkipListMap)ConcurrentNavigableMapNullSafe.this.internalMap).lastKey());
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return ConcurrentNavigableMapNullSafe.this.descendingKeySet();
        }

        @Override
        public Iterator<K> descendingIterator() {
            final Iterator it = ((ConcurrentSkipListMap)ConcurrentNavigableMapNullSafe.this.internalMap).descendingKeySet().iterator();
            return new Iterator<K>(){
                final /* synthetic */ KeyNavigableSet this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public K next() {
                    return this.this$1.ConcurrentNavigableMapNullSafe.this.unmaskNullKey(it.next());
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public NavigableSet<K> subSet(K fromElement, boolean fromInclusive, K toElement, boolean toInclusive) {
            NavigableMap subMap = ConcurrentNavigableMapNullSafe.this.subMap(fromElement, fromInclusive, toElement, toInclusive);
            return subMap.navigableKeySet();
        }

        @Override
        public NavigableSet<K> headSet(K toElement, boolean inclusive) {
            NavigableMap headMap = ConcurrentNavigableMapNullSafe.this.headMap(toElement, inclusive);
            return headMap.navigableKeySet();
        }

        @Override
        public NavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            NavigableMap tailMap = ConcurrentNavigableMapNullSafe.this.tailMap(fromElement, inclusive);
            return tailMap.navigableKeySet();
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return this.subSet((K)fromElement, true, (K)toElement, false);
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return this.headSet((K)toElement, false);
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return this.tailSet((K)fromElement, true);
        }
    }
}

