/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.value;

import com.cedarpolicy.loader.LibraryLoader;
import com.cedarpolicy.serializer.JsonEUID;
import com.cedarpolicy.value.EntityIdentifier;
import com.cedarpolicy.value.EntityTypeName;
import com.cedarpolicy.value.Value;
import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class EntityUID
extends Value {
    private final EntityTypeName type;
    private final EntityIdentifier id;
    private final Supplier<String> euidRepr;

    public EntityUID(EntityTypeName type, EntityIdentifier id) {
        this.type = type;
        this.id = id;
        this.euidRepr = Suppliers.memoize(() -> EntityUID.getEUIDRepr(type, id));
    }

    public EntityUID(EntityTypeName type, String id) {
        this(type, new EntityIdentifier(id));
    }

    public EntityTypeName getType() {
        return this.type;
    }

    public EntityIdentifier getId() {
        return this.id;
    }

    public String toString() {
        return this.euidRepr.get();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        try {
            EntityUID rhs = (EntityUID)o;
            return this.type.equals(rhs.type) && this.id.equals(rhs.id);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id);
    }

    @Override
    public String toCedarExpr() {
        return this.euidRepr.get();
    }

    public static Optional<EntityUID> parse(String src) {
        return EntityUID.parseEntityUID(src);
    }

    public JsonEUID asJson() {
        return new JsonEUID(this.type.toString(), this.id.toString());
    }

    public static Optional<EntityUID> parseFromJson(JsonEUID euid) {
        return EntityTypeName.parse(euid.type).map(type -> new EntityUID((EntityTypeName)type, new EntityIdentifier(euid.id)));
    }

    private static native Optional<EntityUID> parseEntityUID(String var0);

    private static native String getEUIDRepr(EntityTypeName var0, EntityIdentifier var1);

    static {
        LibraryLoader.loadLibrary();
    }
}

