/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.value;

import com.cedarpolicy.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;

public final class CedarList
extends Value
implements List<Value> {
    private final List<Value> list;

    public CedarList(List<Value> source) {
        this.list = new ArrayList<Value>(source);
    }

    public CedarList() {
        this.list = new ArrayList<Value>();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CedarList list1 = (CedarList)o;
        return this.list.equals(list1.list);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.list);
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public String toCedarExpr() {
        return "[" + this.list.stream().map(Value::toCedarExpr).collect(Collectors.joining(", ")) + "]";
    }

    @Override
    public boolean add(Value e) throws NullPointerException {
        if (e == null) {
            throw new NullPointerException("Attempt to put null element in CedarList");
        }
        return this.list.add(e);
    }

    @Override
    public void add(int index, Value e) throws NullPointerException {
        if (e == null) {
            throw new NullPointerException("Attempt to put null element in CedarList");
        }
        this.list.add(index, e);
    }

    @Override
    public boolean addAll(Collection<? extends Value> c) throws NullPointerException {
        for (Value value : c) {
            if (value != null) continue;
            throw new NullPointerException("Attempt to put null element in CedarList");
        }
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Value> c) throws NullPointerException {
        for (Value value : c) {
            if (value != null) continue;
            throw new NullPointerException("Attempt to put null element in CedarList");
        }
        return this.list.addAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public Value get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<Value> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<Value> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<Value> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public Value remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public Value set(int index, Value element) throws NullPointerException {
        if (element == null) {
            throw new NullPointerException("Attempt to put null element in CedarList");
        }
        return this.list.set(index, element);
    }

    @Override
    public List<Value> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

