/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.serializer;

import com.cedarpolicy.model.entity.Entity;
import com.cedarpolicy.model.exception.InvalidValueDeserializationException;
import com.cedarpolicy.serializer.JsonEUID;
import com.cedarpolicy.value.EntityUID;
import com.cedarpolicy.value.Value;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class EntityDeserializer
extends JsonDeserializer<Entity> {
    public Entity deserialize(JsonParser parser, DeserializationContext context) throws IOException, InvalidValueDeserializationException {
        JsonNode parentsNode;
        JsonNode attrsNode;
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        if (!node.has("uid")) {
            String msg = "\"uid\" not found";
            throw new InvalidValueDeserializationException(parser, msg, node.asToken(), Entity.class);
        }
        JsonNode uidNode = node.get("uid");
        EntityUID euid = this.parseEntityUID(parser, uidNode);
        if (node.has("attrs")) {
            attrsNode = node.get("attrs");
            if (!attrsNode.isObject()) {
                String msg = "\"attrs\" must be a JSON object";
                throw new InvalidValueDeserializationException(parser, msg, attrsNode.asToken(), Entity.class);
            }
        } else {
            String msg = "\"attrs\" not found";
            throw new InvalidValueDeserializationException(parser, msg, node.asToken(), Entity.class);
        }
        Map<String, Value> attrs = this.parseValueMap(mapper, attrsNode);
        if (node.has("parents")) {
            parentsNode = node.get("parents");
            if (!parentsNode.isArray()) {
                String msg = "\"parents\" field must be a JSON array";
                throw new InvalidValueDeserializationException(parser, msg, parentsNode.asToken(), Entity.class);
            }
        } else {
            String msg = "\"parents\" not found";
            throw new InvalidValueDeserializationException(parser, msg, node.asToken(), Entity.class);
        }
        Set<EntityUID> parentEUIDs = StreamSupport.stream(parentsNode.spliterator(), false).map(parentNode -> {
            try {
                return this.parseEntityUID(parser, (JsonNode)parentNode);
            }
            catch (InvalidValueDeserializationException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }).collect(Collectors.toSet());
        HashMap<String, Value> tags = new HashMap<String, Value>();
        if (node.has("tags")) {
            JsonNode tagsNode = node.get("tags");
            if (tagsNode.isObject()) {
                tags.putAll(this.parseValueMap(mapper, tagsNode));
            } else {
                String msg = "\"tags\" must be a JSON object";
                throw new InvalidValueDeserializationException(parser, msg, tagsNode.asToken(), Entity.class);
            }
        }
        return new Entity(euid, attrs, parentEUIDs, tags);
    }

    private EntityUID parseEntityUID(JsonParser parser, JsonNode entityUIDJson) throws InvalidValueDeserializationException {
        if (entityUIDJson.has("type") && entityUIDJson.has("id")) {
            JsonEUID jsonEuid = new JsonEUID(entityUIDJson.get("type").asText(), entityUIDJson.get("id").asText());
            return EntityUID.parseFromJson(jsonEuid).get();
        }
        String msg = "\"type\" or \"id\" not found";
        throw new InvalidValueDeserializationException(parser, msg, entityUIDJson.asToken(), Entity.class);
    }

    private Map<String, Value> parseValueMap(ObjectMapper mapper, JsonNode valueMapJson) {
        Map<String, Value> valueMap = StreamSupport.stream(Spliterators.spliteratorUnknownSize(valueMapJson.fields(), 16), false).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return (Value)mapper.treeToValue((TreeNode)entry.getValue(), Value.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        return valueMap;
    }
}

