/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.Experimental;
import com.cedarpolicy.ExperimentalFeature;
import com.cedarpolicy.model.DetailedError;
import com.cedarpolicy.model.PartialAuthorizationSuccessResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

@Experimental(value=ExperimentalFeature.PARTIAL_EVALUATION)
public class PartialAuthorizationResponse {
    @JsonProperty(value="type")
    public final SuccessOrFailure type;
    @JsonProperty(value="response")
    public final Optional<PartialAuthorizationSuccessResponse> success;
    @JsonProperty(value="errors")
    public final Optional<ImmutableList<DetailedError>> errors;
    @JsonProperty(value="warnings")
    public final ImmutableList<String> warnings;

    @JsonCreator
    public PartialAuthorizationResponse(@JsonProperty(value="type") SuccessOrFailure type, @JsonProperty(value="response") Optional<PartialAuthorizationSuccessResponse> success, @JsonProperty(value="errors") Optional<ArrayList<DetailedError>> errors, @JsonProperty(value="warnings") ArrayList<String> warnings) {
        this.type = type;
        this.success = success;
        this.errors = errors.map(list -> ImmutableList.copyOf((Collection)list));
        this.warnings = warnings == null ? ImmutableList.of() : ImmutableList.copyOf(warnings);
    }

    public String toString() {
        String warningsString;
        String string = warningsString = this.warnings.isEmpty() ? "" : "\nwith warnings: " + this.warnings;
        if (this.type == SuccessOrFailure.Success) {
            return "SUCCESS: " + this.success.get() + warningsString;
        }
        return "FAILURE: " + this.errors.get() + warningsString;
    }

    public static enum SuccessOrFailure {
        Success,
        Failure;

    }
}

