/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.value.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Context {
    private Map<String, Value> context;

    public Context() {
        this.context = Collections.emptyMap();
    }

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public Context(Iterable<Map.Entry<String, Value>> contextList) {
        this.context = new HashMap<String, Value>();
        this.mergeContextFromIterable(contextList);
    }

    public Context(Map<String, Value> contextMap) {
        this.context = new HashMap<String, Value>();
        this.context.putAll(contextMap);
    }

    public Map<String, Value> getContext() {
        return new HashMap<String, Value>(this.context);
    }

    public void merge(Context contextToMerge) throws IllegalStateException, IllegalArgumentException {
        this.mergeContextFromIterable(contextToMerge.getContext().entrySet());
    }

    public void merge(Iterable<Map.Entry<String, Value>> contextMaps) throws IllegalStateException, IllegalArgumentException {
        this.mergeContextFromIterable(contextMaps);
    }

    public Value get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        return this.context.getOrDefault(key, null);
    }

    private void mergeContextFromIterable(Iterable<Map.Entry<String, Value>> contextIterator) throws IllegalStateException, IllegalArgumentException {
        if (contextIterator == null) {
            throw new IllegalArgumentException("Context iterator cannot be null");
        }
        Map<String, Value> newEntries = StreamSupport.stream(contextIterator.spliterator(), false).peek(entry -> {
            if (this.context.containsKey(entry.getKey())) {
                throw new IllegalStateException(String.format("Duplicate key '%s' in existing context", entry.getKey()));
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.context.putAll(newEntries);
    }

    public String toString() {
        return this.context.toString();
    }
}

