/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.model.Context;
import com.cedarpolicy.model.entity.Entity;
import com.cedarpolicy.model.schema.Schema;
import com.cedarpolicy.value.EntityUID;
import com.cedarpolicy.value.Value;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AuthorizationRequest {
    @JsonProperty(value="principal")
    public final EntityUID principalEUID;
    @JsonProperty(value="action")
    public final EntityUID actionEUID;
    @JsonProperty(value="resource")
    public final EntityUID resourceEUID;
    public final Optional<Map<String, Value>> context;
    public final Optional<Schema> schema;
    @JsonProperty(value="validateRequest")
    public final boolean enableRequestValidation;

    public AuthorizationRequest(EntityUID principalEUID, EntityUID actionEUID, EntityUID resourceEUID, Optional<Map<String, Value>> context, Optional<Schema> schema, boolean enableRequestValidation) {
        this.principalEUID = principalEUID;
        this.actionEUID = actionEUID;
        this.resourceEUID = resourceEUID;
        this.context = !context.isPresent() || context.get() == null ? Optional.empty() : Optional.of(new HashMap<String, Value>(context.get()));
        this.schema = schema;
        this.enableRequestValidation = enableRequestValidation;
    }

    public AuthorizationRequest(EntityUID principalEUID, EntityUID actionEUID, EntityUID resourceEUID, Context context, Optional<Schema> schema, boolean enableRequestValidation) {
        this.principalEUID = principalEUID;
        this.actionEUID = actionEUID;
        this.resourceEUID = resourceEUID;
        this.context = Optional.of(context.getContext());
        this.schema = schema;
        this.enableRequestValidation = enableRequestValidation;
    }

    public AuthorizationRequest(EntityUID principalEUID, EntityUID actionEUID, EntityUID resourceEUID, Map<String, Value> context) {
        this(principalEUID, actionEUID, resourceEUID, Optional.of(context), Optional.empty(), false);
    }

    public AuthorizationRequest(EntityUID principalEUID, EntityUID actionEUID, EntityUID resourceEUID, Context context) {
        this(principalEUID, actionEUID, resourceEUID, context, Optional.empty(), false);
    }

    public AuthorizationRequest(Entity principalEUID, Entity actionEUID, Entity resourceEUID, Map<String, Value> context) {
        this(principalEUID.getEUID(), actionEUID.getEUID(), resourceEUID.getEUID(), context);
    }

    public AuthorizationRequest(Entity principalEUID, Entity actionEUID, Entity resourceEUID, Context context) {
        this(principalEUID.getEUID(), actionEUID.getEUID(), resourceEUID.getEUID(), context);
    }

    public AuthorizationRequest(Entity principal, Entity action, Entity resource, Optional<Map<String, Value>> context, Optional<Schema> schema, boolean enableRequestValidation) {
        this(principal.getEUID(), action.getEUID(), resource.getEUID(), context, schema, enableRequestValidation);
    }

    public AuthorizationRequest(Entity principal, Entity action, Entity resource, Context context, Optional<Schema> schema, boolean enableRequestValidation) {
        this(principal.getEUID(), action.getEUID(), resource.getEUID(), context, schema, enableRequestValidation);
    }

    public String toString() {
        return "Request(" + this.principalEUID + ", " + this.actionEUID + ", " + this.resourceEUID + ", " + this.context + ")";
    }
}

