/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.graphics.Matrix;
import android.util.Log;
import com.caverock.androidsvg.CSSParser;
import com.caverock.androidsvg.PreserveAspectRatio;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class SVGParser
extends DefaultHandler2 {
    private static final String TAG = "SVGParser";
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    private static final String FEATURE_STRING_PREFIX = "http://www.w3.org/TR/SVG11/feature#";
    private SVG svgDocument = null;
    private SVG.SvgContainer currentElement = null;
    private boolean ignoring = false;
    private int ignoreDepth;
    private boolean inMetadataElement = false;
    private String metadataTag = null;
    private StringBuilder metadataElementContents = null;
    private boolean inStyleElement = false;
    private StringBuilder styleElementContents = null;
    private HashSet<String> supportedFormats = null;
    private static final String TAG_SVG = "svg";
    private static final String TAG_A = "a";
    private static final String TAG_CIRCLE = "circle";
    private static final String TAG_CLIPPATH = "clipPath";
    private static final String TAG_DEFS = "defs";
    private static final String TAG_DESC = "desc";
    private static final String TAG_ELLIPSE = "ellipse";
    private static final String TAG_G = "g";
    private static final String TAG_IMAGE = "image";
    private static final String TAG_LINE = "line";
    private static final String TAG_LINEARGRADIENT = "linearGradient";
    private static final String TAG_MARKER = "marker";
    private static final String TAG_MASK = "mask";
    private static final String TAG_PATH = "path";
    private static final String TAG_PATTERN = "pattern";
    private static final String TAG_POLYGON = "polygon";
    private static final String TAG_POLYLINE = "polyline";
    private static final String TAG_RADIALGRADIENT = "radialGradient";
    private static final String TAG_RECT = "rect";
    private static final String TAG_SOLIDCOLOR = "solidColor";
    private static final String TAG_STOP = "stop";
    private static final String TAG_STYLE = "style";
    private static final String TAG_SWITCH = "switch";
    private static final String TAG_SYMBOL = "symbol";
    private static final String TAG_TEXT = "text";
    private static final String TAG_TEXTPATH = "textPath";
    private static final String TAG_TITLE = "title";
    private static final String TAG_TREF = "tref";
    private static final String TAG_TSPAN = "tspan";
    private static final String TAG_USE = "use";
    private static final String TAG_VIEW = "view";
    private static final String NONE = "none";
    private static final String CURRENTCOLOR = "currentColor";
    private static final String VALID_DISPLAY_VALUES = "|inline|block|list-item|run-in|compact|marker|table|inline-table|table-row-group|table-header-group|table-footer-group|table-row|table-column-group|table-column|table-cell|table-caption|none|";
    private static final String VALID_VISIBILITY_VALUES = "|visible|hidden|collapse|";
    private static HashMap<String, Integer> colourKeywords = new HashMap();
    private static HashMap<String, SVG.Length> fontSizeKeywords = new HashMap(9);
    private static HashMap<String, Integer> fontWeightKeywords = new HashMap(13);
    private static HashMap<String, SVG.Style.FontStyle> fontStyleKeywords = new HashMap(3);
    private static HashMap<String, PreserveAspectRatio.Alignment> aspectRatioKeywords = new HashMap();
    protected static HashSet<String> supportedFeatures = new HashSet();

    static {
        colourKeywords.put("aliceblue", 0xF0F8FF);
        colourKeywords.put("antiquewhite", 16444375);
        colourKeywords.put("aqua", 65535);
        colourKeywords.put("aquamarine", 8388564);
        colourKeywords.put("azure", 0xF0FFFF);
        colourKeywords.put("beige", 16119260);
        colourKeywords.put("bisque", 16770244);
        colourKeywords.put("black", 0);
        colourKeywords.put("blanchedalmond", 16772045);
        colourKeywords.put("blue", 255);
        colourKeywords.put("blueviolet", 9055202);
        colourKeywords.put("brown", 0xA52A2A);
        colourKeywords.put("burlywood", 14596231);
        colourKeywords.put("cadetblue", 6266528);
        colourKeywords.put("chartreuse", 0x7FFF00);
        colourKeywords.put("chocolate", 13789470);
        colourKeywords.put("coral", 16744272);
        colourKeywords.put("cornflowerblue", 6591981);
        colourKeywords.put("cornsilk", 16775388);
        colourKeywords.put("crimson", 14423100);
        colourKeywords.put("cyan", 65535);
        colourKeywords.put("darkblue", 139);
        colourKeywords.put("darkcyan", 35723);
        colourKeywords.put("darkgoldenrod", 12092939);
        colourKeywords.put("darkgray", 0xA9A9A9);
        colourKeywords.put("darkgreen", 25600);
        colourKeywords.put("darkgrey", 0xA9A9A9);
        colourKeywords.put("darkkhaki", 12433259);
        colourKeywords.put("darkmagenta", 0x8B008B);
        colourKeywords.put("darkolivegreen", 5597999);
        colourKeywords.put("darkorange", 16747520);
        colourKeywords.put("darkorchid", 10040012);
        colourKeywords.put("darkred", 0x8B0000);
        colourKeywords.put("darksalmon", 15308410);
        colourKeywords.put("darkseagreen", 9419919);
        colourKeywords.put("darkslateblue", 4734347);
        colourKeywords.put("darkslategray", 0x2F4F4F);
        colourKeywords.put("darkslategrey", 0x2F4F4F);
        colourKeywords.put("darkturquoise", 52945);
        colourKeywords.put("darkviolet", 9699539);
        colourKeywords.put("deeppink", 16716947);
        colourKeywords.put("deepskyblue", 49151);
        colourKeywords.put("dimgray", 0x696969);
        colourKeywords.put("dimgrey", 0x696969);
        colourKeywords.put("dodgerblue", 2003199);
        colourKeywords.put("firebrick", 0xB22222);
        colourKeywords.put("floralwhite", 0xFFFAF0);
        colourKeywords.put("forestgreen", 0x228B22);
        colourKeywords.put("fuchsia", 0xFF00FF);
        colourKeywords.put("gainsboro", 0xDCDCDC);
        colourKeywords.put("ghostwhite", 0xF8F8FF);
        colourKeywords.put("gold", 16766720);
        colourKeywords.put("goldenrod", 14329120);
        colourKeywords.put("gray", 0x808080);
        colourKeywords.put("green", 32768);
        colourKeywords.put("greenyellow", 11403055);
        colourKeywords.put("grey", 0x808080);
        colourKeywords.put("honeydew", 0xF0FFF0);
        colourKeywords.put("hotpink", 16738740);
        colourKeywords.put("indianred", 0xCD5C5C);
        colourKeywords.put("indigo", 4915330);
        colourKeywords.put("ivory", 0xFFFFF0);
        colourKeywords.put("khaki", 15787660);
        colourKeywords.put("lavender", 15132410);
        colourKeywords.put("lavenderblush", 0xFFF0F5);
        colourKeywords.put("lawngreen", 8190976);
        colourKeywords.put("lemonchiffon", 16775885);
        colourKeywords.put("lightblue", 11393254);
        colourKeywords.put("lightcoral", 0xF08080);
        colourKeywords.put("lightcyan", 0xE0FFFF);
        colourKeywords.put("lightgoldenrodyellow", 16448210);
        colourKeywords.put("lightgray", 0xD3D3D3);
        colourKeywords.put("lightgreen", 0x90EE90);
        colourKeywords.put("lightgrey", 0xD3D3D3);
        colourKeywords.put("lightpink", 16758465);
        colourKeywords.put("lightsalmon", 16752762);
        colourKeywords.put("lightseagreen", 2142890);
        colourKeywords.put("lightskyblue", 8900346);
        colourKeywords.put("lightslategray", 0x778899);
        colourKeywords.put("lightslategrey", 0x778899);
        colourKeywords.put("lightsteelblue", 11584734);
        colourKeywords.put("lightyellow", 0xFFFFE0);
        colourKeywords.put("lime", 65280);
        colourKeywords.put("limegreen", 3329330);
        colourKeywords.put("linen", 16445670);
        colourKeywords.put("magenta", 0xFF00FF);
        colourKeywords.put("maroon", 0x800000);
        colourKeywords.put("mediumaquamarine", 6737322);
        colourKeywords.put("mediumblue", 205);
        colourKeywords.put("mediumorchid", 12211667);
        colourKeywords.put("mediumpurple", 9662683);
        colourKeywords.put("mediumseagreen", 3978097);
        colourKeywords.put("mediumslateblue", 8087790);
        colourKeywords.put("mediumspringgreen", 64154);
        colourKeywords.put("mediumturquoise", 4772300);
        colourKeywords.put("mediumvioletred", 13047173);
        colourKeywords.put("midnightblue", 1644912);
        colourKeywords.put("mintcream", 0xF5FFFA);
        colourKeywords.put("mistyrose", 16770273);
        colourKeywords.put("moccasin", 16770229);
        colourKeywords.put("navajowhite", 16768685);
        colourKeywords.put("navy", 128);
        colourKeywords.put("oldlace", 16643558);
        colourKeywords.put("olive", 0x808000);
        colourKeywords.put("olivedrab", 7048739);
        colourKeywords.put("orange", 16753920);
        colourKeywords.put("orangered", 16729344);
        colourKeywords.put("orchid", 14315734);
        colourKeywords.put("palegoldenrod", 0xEEE8AA);
        colourKeywords.put("palegreen", 10025880);
        colourKeywords.put("paleturquoise", 0xAFEEEE);
        colourKeywords.put("palevioletred", 14381203);
        colourKeywords.put("papayawhip", 16773077);
        colourKeywords.put("peachpuff", 16767673);
        colourKeywords.put("peru", 13468991);
        colourKeywords.put("pink", 16761035);
        colourKeywords.put("plum", 0xDDA0DD);
        colourKeywords.put("powderblue", 11591910);
        colourKeywords.put("purple", 0x800080);
        colourKeywords.put("red", 0xFF0000);
        colourKeywords.put("rosybrown", 12357519);
        colourKeywords.put("royalblue", 4286945);
        colourKeywords.put("saddlebrown", 9127187);
        colourKeywords.put("salmon", 16416882);
        colourKeywords.put("sandybrown", 16032864);
        colourKeywords.put("seagreen", 3050327);
        colourKeywords.put("seashell", 0xFFF5EE);
        colourKeywords.put("sienna", 10506797);
        colourKeywords.put("silver", 0xC0C0C0);
        colourKeywords.put("skyblue", 8900331);
        colourKeywords.put("slateblue", 6970061);
        colourKeywords.put("slategray", 7372944);
        colourKeywords.put("slategrey", 7372944);
        colourKeywords.put("snow", 0xFFFAFA);
        colourKeywords.put("springgreen", 65407);
        colourKeywords.put("steelblue", 4620980);
        colourKeywords.put("tan", 13808780);
        colourKeywords.put("teal", 32896);
        colourKeywords.put("thistle", 14204888);
        colourKeywords.put("tomato", 16737095);
        colourKeywords.put("turquoise", 4251856);
        colourKeywords.put("violet", 0xEE82EE);
        colourKeywords.put("wheat", 16113331);
        colourKeywords.put("white", 0xFFFFFF);
        colourKeywords.put("whitesmoke", 0xF5F5F5);
        colourKeywords.put("yellow", 0xFFFF00);
        colourKeywords.put("yellowgreen", 10145074);
        fontSizeKeywords.put("xx-small", new SVG.Length(0.694f, SVG.Unit.pt));
        fontSizeKeywords.put("x-small", new SVG.Length(0.833f, SVG.Unit.pt));
        fontSizeKeywords.put("small", new SVG.Length(10.0f, SVG.Unit.pt));
        fontSizeKeywords.put("medium", new SVG.Length(12.0f, SVG.Unit.pt));
        fontSizeKeywords.put("large", new SVG.Length(14.4f, SVG.Unit.pt));
        fontSizeKeywords.put("x-large", new SVG.Length(17.3f, SVG.Unit.pt));
        fontSizeKeywords.put("xx-large", new SVG.Length(20.7f, SVG.Unit.pt));
        fontSizeKeywords.put("smaller", new SVG.Length(83.33f, SVG.Unit.percent));
        fontSizeKeywords.put("larger", new SVG.Length(120.0f, SVG.Unit.percent));
        fontWeightKeywords.put("normal", 400);
        fontWeightKeywords.put("bold", 700);
        fontWeightKeywords.put("bolder", 1);
        fontWeightKeywords.put("lighter", -1);
        fontWeightKeywords.put("100", 100);
        fontWeightKeywords.put("200", 200);
        fontWeightKeywords.put("300", 300);
        fontWeightKeywords.put("400", 400);
        fontWeightKeywords.put("500", 500);
        fontWeightKeywords.put("600", 600);
        fontWeightKeywords.put("700", 700);
        fontWeightKeywords.put("800", 800);
        fontWeightKeywords.put("900", 900);
        fontStyleKeywords.put("normal", SVG.Style.FontStyle.Normal);
        fontStyleKeywords.put("italic", SVG.Style.FontStyle.Italic);
        fontStyleKeywords.put("oblique", SVG.Style.FontStyle.Oblique);
        aspectRatioKeywords.put(NONE, PreserveAspectRatio.Alignment.None);
        aspectRatioKeywords.put("xMinYMin", PreserveAspectRatio.Alignment.XMinYMin);
        aspectRatioKeywords.put("xMidYMin", PreserveAspectRatio.Alignment.XMidYMin);
        aspectRatioKeywords.put("xMaxYMin", PreserveAspectRatio.Alignment.XMaxYMin);
        aspectRatioKeywords.put("xMinYMid", PreserveAspectRatio.Alignment.XMinYMid);
        aspectRatioKeywords.put("xMidYMid", PreserveAspectRatio.Alignment.XMidYMid);
        aspectRatioKeywords.put("xMaxYMid", PreserveAspectRatio.Alignment.XMaxYMid);
        aspectRatioKeywords.put("xMinYMax", PreserveAspectRatio.Alignment.XMinYMax);
        aspectRatioKeywords.put("xMidYMax", PreserveAspectRatio.Alignment.XMidYMax);
        aspectRatioKeywords.put("xMaxYMax", PreserveAspectRatio.Alignment.XMaxYMax);
        supportedFeatures.add("Structure");
        supportedFeatures.add("BasicStructure");
        supportedFeatures.add("ConditionalProcessing");
        supportedFeatures.add("Image");
        supportedFeatures.add("Style");
        supportedFeatures.add("ViewportAttribute");
        supportedFeatures.add("Shape");
        supportedFeatures.add("BasicText");
        supportedFeatures.add("PaintAttribute");
        supportedFeatures.add("BasicPaintAttribute");
        supportedFeatures.add("OpacityAttribute");
        supportedFeatures.add("BasicGraphicsAttribute");
        supportedFeatures.add("Marker");
        supportedFeatures.add("Gradient");
        supportedFeatures.add("Pattern");
        supportedFeatures.add("Clip");
        supportedFeatures.add("BasicClip");
        supportedFeatures.add("Mask");
        supportedFeatures.add("View");
    }

    protected void setSupportedFormats(String[] mimeTypes) {
        this.supportedFormats = new HashSet(mimeTypes.length);
        Collections.addAll(this.supportedFormats, mimeTypes);
    }

    protected SVG parse(InputStream is) throws SVGParseException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        try {
            is.mark(3);
            int firstTwoBytes = is.read() + (is.read() << 8);
            is.reset();
            if (firstTwoBytes == 35615) {
                is = new GZIPInputStream(is);
            }
        }
        catch (IOException firstTwoBytes) {
            // empty catch block
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            try {
                SAXParser sp = spf.newSAXParser();
                XMLReader xr = sp.getXMLReader();
                xr.setContentHandler(this);
                xr.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                xr.parse(new InputSource(is));
            }
            catch (IOException e) {
                throw new SVGParseException("File error", e);
            }
            catch (ParserConfigurationException e) {
                throw new SVGParseException("XML Parser problem", e);
            }
            catch (SAXException e) {
                throw new SVGParseException("SVG parse error: " + e.getMessage(), e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception thrown closing input stream");
            }
        }
        return this.svgDocument;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.svgDocument = new SVG();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.ignoring) {
            ++this.ignoreDepth;
            return;
        }
        if (!SVG_NAMESPACE.equals(uri) && !"".equals(uri)) {
            return;
        }
        if (localName.equals(TAG_SVG)) {
            this.svg(attributes);
        } else if (localName.equals(TAG_G)) {
            this.g(attributes);
        } else if (localName.equals(TAG_DEFS)) {
            this.defs(attributes);
        } else if (localName.equals(TAG_USE)) {
            this.use(attributes);
        } else if (localName.equals(TAG_PATH)) {
            this.path(attributes);
        } else if (localName.equals(TAG_RECT)) {
            this.rect(attributes);
        } else if (localName.equals(TAG_CIRCLE)) {
            this.circle(attributes);
        } else if (localName.equals(TAG_ELLIPSE)) {
            this.ellipse(attributes);
        } else if (localName.equals(TAG_LINE)) {
            this.line(attributes);
        } else if (localName.equals(TAG_POLYLINE)) {
            this.polyline(attributes);
        } else if (localName.equals(TAG_POLYGON)) {
            this.polygon(attributes);
        } else if (localName.equals(TAG_TEXT)) {
            this.text(attributes);
        } else if (localName.equals(TAG_TSPAN)) {
            this.tspan(attributes);
        } else if (localName.equals(TAG_TREF)) {
            this.tref(attributes);
        } else if (localName.equals(TAG_SWITCH)) {
            this.zwitch(attributes);
        } else if (localName.equals(TAG_SYMBOL)) {
            this.symbol(attributes);
        } else if (localName.equals(TAG_MARKER)) {
            this.marker(attributes);
        } else if (localName.equals(TAG_LINEARGRADIENT)) {
            this.linearGradient(attributes);
        } else if (localName.equals(TAG_RADIALGRADIENT)) {
            this.radialGradient(attributes);
        } else if (localName.equals(TAG_STOP)) {
            this.stop(attributes);
        } else if (localName.equals(TAG_A)) {
            this.g(attributes);
        } else if (localName.equals(TAG_TITLE) || localName.equals(TAG_DESC)) {
            this.inMetadataElement = true;
            this.metadataTag = localName;
        } else if (localName.equals(TAG_CLIPPATH)) {
            this.clipPath(attributes);
        } else if (localName.equals(TAG_TEXTPATH)) {
            this.textPath(attributes);
        } else if (localName.equals(TAG_PATTERN)) {
            this.pattern(attributes);
        } else if (localName.equals(TAG_IMAGE)) {
            this.image(attributes);
        } else if (localName.equals(TAG_VIEW)) {
            this.view(attributes);
        } else if (localName.equals(TAG_MASK)) {
            this.mask(attributes);
        } else if (localName.equals(TAG_STYLE)) {
            this.style(attributes);
        } else if (localName.equals(TAG_SOLIDCOLOR)) {
            this.solidColor(attributes);
        } else {
            this.ignoring = true;
            this.ignoreDepth = 1;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.ignoring) {
            return;
        }
        if (this.inMetadataElement) {
            if (this.metadataElementContents == null) {
                this.metadataElementContents = new StringBuilder(length);
            }
            this.metadataElementContents.append(ch, start, length);
            return;
        }
        if (this.inStyleElement) {
            if (this.styleElementContents == null) {
                this.styleElementContents = new StringBuilder(length);
            }
            this.styleElementContents.append(ch, start, length);
            return;
        }
        if (this.currentElement instanceof SVG.TextContainer) {
            SVG.SvgObject previousSibling;
            SVG.SvgConditionalContainer parent = (SVG.SvgConditionalContainer)this.currentElement;
            int numOlderSiblings = parent.children.size();
            SVG.SvgObject svgObject = previousSibling = numOlderSiblings == 0 ? null : parent.children.get(numOlderSiblings - 1);
            if (previousSibling instanceof SVG.TextSequence) {
                ((SVG.TextSequence)previousSibling).text = String.valueOf(((SVG.TextSequence)previousSibling).text) + new String(ch, start, length);
            } else {
                ((SVG.SvgConditionalContainer)this.currentElement).addChild(new SVG.TextSequence(new String(ch, start, length)));
            }
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.ignoring) {
            return;
        }
        if (this.inStyleElement) {
            if (this.styleElementContents == null) {
                this.styleElementContents = new StringBuilder(length);
            }
            this.styleElementContents.append(ch, start, length);
            return;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (this.ignoring && --this.ignoreDepth == 0) {
            this.ignoring = false;
            return;
        }
        if (!SVG_NAMESPACE.equals(uri) && !"".equals(uri)) {
            return;
        }
        if (localName.equals(TAG_TITLE) || localName.equals(TAG_DESC)) {
            this.inMetadataElement = false;
            if (this.metadataTag.equals(TAG_TITLE)) {
                this.svgDocument.setTitle(this.metadataElementContents.toString());
            } else if (this.metadataTag.equals(TAG_DESC)) {
                this.svgDocument.setDesc(this.metadataElementContents.toString());
            }
            this.metadataElementContents.setLength(0);
            return;
        }
        if (localName.equals(TAG_STYLE) && this.styleElementContents != null) {
            this.inStyleElement = false;
            this.parseCSSStyleSheet(this.styleElementContents.toString());
            this.styleElementContents.setLength(0);
            return;
        }
        if (localName.equals(TAG_SVG) || localName.equals(TAG_DEFS) || localName.equals(TAG_G) || localName.equals(TAG_USE) || localName.equals(TAG_IMAGE) || localName.equals(TAG_TEXT) || localName.equals(TAG_TSPAN) || localName.equals(TAG_SWITCH) || localName.equals(TAG_SYMBOL) || localName.equals(TAG_MARKER) || localName.equals(TAG_LINEARGRADIENT) || localName.equals(TAG_RADIALGRADIENT) || localName.equals(TAG_STOP) || localName.equals(TAG_CLIPPATH) || localName.equals(TAG_TEXTPATH) || localName.equals(TAG_PATTERN) || localName.equals(TAG_VIEW) || localName.equals(TAG_MASK) || localName.equals(TAG_SOLIDCOLOR)) {
            this.currentElement = ((SVG.SvgObject)((Object)this.currentElement)).parent;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    private void dumpNode(SVG.SvgObject elem, String indent) {
        Log.d((String)TAG, (String)(String.valueOf(indent) + elem));
        if (elem instanceof SVG.SvgConditionalContainer) {
            indent = String.valueOf(indent) + "  ";
            for (SVG.SvgObject child : ((SVG.SvgConditionalContainer)elem).children) {
                this.dumpNode(child, indent);
            }
        }
    }

    private void debug(String format, Object ... args) {
    }

    private void svg(Attributes attributes) throws SAXException {
        this.debug("<svg>", new Object[0]);
        SVG.Svg obj = new SVG.Svg();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.parseAttributesSVG(obj, attributes);
        if (this.currentElement == null) {
            this.svgDocument.setRootElement(obj);
        } else {
            this.currentElement.addChild(obj);
        }
        this.currentElement = obj;
    }

    private void parseAttributesSVG(SVG.Svg obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    break;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    break;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) break;
                    throw new SAXException("Invalid <svg> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) break;
                    throw new SAXException("Invalid <svg> element. height cannot be negative");
                }
                case version: {
                    obj.version = val;
                    break;
                }
            }
            ++i;
        }
    }

    private void g(Attributes attributes) throws SAXException {
        this.debug("<g>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Group obj = new SVG.Group();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void defs(Attributes attributes) throws SAXException {
        this.debug("<defs>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Defs obj = new SVG.Defs();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void use(Attributes attributes) throws SAXException {
        this.debug("<use>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Use obj = new SVG.Use();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesUse(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesUse(SVG.Use obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    break;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    break;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) break;
                    throw new SAXException("Invalid <use> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) break;
                    throw new SAXException("Invalid <use> element. height cannot be negative");
                }
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) break;
                    obj.href = val;
                    break;
                }
            }
            ++i;
        }
    }

    private void image(Attributes attributes) throws SAXException {
        this.debug("<image>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Image obj = new SVG.Image();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesImage(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesImage(SVG.Image obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    break;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    break;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) break;
                    throw new SAXException("Invalid <use> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) break;
                    throw new SAXException("Invalid <use> element. height cannot be negative");
                }
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) break;
                    obj.href = val;
                    break;
                }
                case preserveAspectRatio: {
                    SVGParser.parsePreserveAspectRatio(obj, val);
                    break;
                }
            }
            ++i;
        }
    }

    private void path(Attributes attributes) throws SAXException {
        this.debug("<path>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Path obj = new SVG.Path();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesPath(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesPath(SVG.Path obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case d: {
                    obj.d = SVGParser.parsePath(val);
                    break;
                }
                case pathLength: {
                    obj.pathLength = Float.valueOf(SVGParser.parseFloat(val));
                    if (!(obj.pathLength.floatValue() < 0.0f)) break;
                    throw new SAXException("Invalid <path> element. pathLength cannot be negative");
                }
            }
            ++i;
        }
    }

    private void rect(Attributes attributes) throws SAXException {
        this.debug("<rect>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Rect obj = new SVG.Rect();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesRect(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesRect(SVG.Rect obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    break;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    break;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) break;
                    throw new SAXException("Invalid <rect> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) break;
                    throw new SAXException("Invalid <rect> element. height cannot be negative");
                }
                case rx: {
                    obj.rx = SVGParser.parseLength(val);
                    if (!obj.rx.isNegative()) break;
                    throw new SAXException("Invalid <rect> element. rx cannot be negative");
                }
                case ry: {
                    obj.ry = SVGParser.parseLength(val);
                    if (!obj.ry.isNegative()) break;
                    throw new SAXException("Invalid <rect> element. ry cannot be negative");
                }
            }
            ++i;
        }
    }

    private void circle(Attributes attributes) throws SAXException {
        this.debug("<circle>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Circle obj = new SVG.Circle();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesCircle(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesCircle(SVG.Circle obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case cx: {
                    obj.cx = SVGParser.parseLength(val);
                    break;
                }
                case cy: {
                    obj.cy = SVGParser.parseLength(val);
                    break;
                }
                case r: {
                    obj.r = SVGParser.parseLength(val);
                    if (!obj.r.isNegative()) break;
                    throw new SAXException("Invalid <circle> element. r cannot be negative");
                }
            }
            ++i;
        }
    }

    private void ellipse(Attributes attributes) throws SAXException {
        this.debug("<ellipse>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Ellipse obj = new SVG.Ellipse();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesEllipse(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesEllipse(SVG.Ellipse obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case cx: {
                    obj.cx = SVGParser.parseLength(val);
                    break;
                }
                case cy: {
                    obj.cy = SVGParser.parseLength(val);
                    break;
                }
                case rx: {
                    obj.rx = SVGParser.parseLength(val);
                    if (!obj.rx.isNegative()) break;
                    throw new SAXException("Invalid <ellipse> element. rx cannot be negative");
                }
                case ry: {
                    obj.ry = SVGParser.parseLength(val);
                    if (!obj.ry.isNegative()) break;
                    throw new SAXException("Invalid <ellipse> element. ry cannot be negative");
                }
            }
            ++i;
        }
    }

    private void line(Attributes attributes) throws SAXException {
        this.debug("<line>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Line obj = new SVG.Line();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesLine(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesLine(SVG.Line obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x1: {
                    obj.x1 = SVGParser.parseLength(val);
                    break;
                }
                case y1: {
                    obj.y1 = SVGParser.parseLength(val);
                    break;
                }
                case x2: {
                    obj.x2 = SVGParser.parseLength(val);
                    break;
                }
                case y2: {
                    obj.y2 = SVGParser.parseLength(val);
                    break;
                }
            }
            ++i;
        }
    }

    private void polyline(Attributes attributes) throws SAXException {
        this.debug("<polyline>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.PolyLine obj = new SVG.PolyLine();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesPolyLine(obj, attributes, TAG_POLYLINE);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesPolyLine(SVG.PolyLine obj, Attributes attributes, String tag) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            if (SVGAttr.fromString(attributes.getLocalName(i)) == SVGAttr.points) {
                TextScanner scan = new TextScanner(attributes.getValue(i));
                ArrayList<Float> points = new ArrayList<Float>();
                scan.skipWhitespace();
                while (!scan.empty()) {
                    Float x = scan.nextFloat();
                    if (x == null) {
                        throw new SAXException("Invalid <" + tag + "> points attribute. Non-coordinate content found in list.");
                    }
                    scan.skipCommaWhitespace();
                    Float y = scan.nextFloat();
                    if (y == null) {
                        throw new SAXException("Invalid <" + tag + "> points attribute. There should be an even number of coordinates.");
                    }
                    scan.skipCommaWhitespace();
                    points.add(x);
                    points.add(y);
                }
                obj.points = new float[points.size()];
                int j = 0;
                for (Float f : points) {
                    obj.points[j++] = f.floatValue();
                }
            }
            ++i;
        }
    }

    private void polygon(Attributes attributes) throws SAXException {
        this.debug("<polygon>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Polygon obj = new SVG.Polygon();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesPolyLine(obj, attributes, TAG_POLYGON);
        this.currentElement.addChild(obj);
    }

    private void text(Attributes attributes) throws SAXException {
        this.debug("<text>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Text obj = new SVG.Text();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTextPosition(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesTextPosition(SVG.TextPositionedContainer obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLengthList(val);
                    break;
                }
                case y: {
                    obj.y = SVGParser.parseLengthList(val);
                    break;
                }
                case dx: {
                    obj.dx = SVGParser.parseLengthList(val);
                    break;
                }
                case dy: {
                    obj.dy = SVGParser.parseLengthList(val);
                    break;
                }
            }
            ++i;
        }
    }

    private void tspan(Attributes attributes) throws SAXException {
        this.debug("<tspan>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.TextContainer)) {
            throw new SAXException("Invalid document. <tspan> elements are only valid inside <text> or other <tspan> elements.");
        }
        SVG.TSpan obj = new SVG.TSpan();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTextPosition(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
        if (obj.parent instanceof SVG.TextRoot) {
            obj.setTextRoot((SVG.TextRoot)((Object)obj.parent));
        } else {
            obj.setTextRoot(((SVG.TextChild)((Object)obj.parent)).getTextRoot());
        }
    }

    private void tref(Attributes attributes) throws SAXException {
        this.debug("<tref>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.TextContainer)) {
            throw new SAXException("Invalid document. <tref> elements are only valid inside <text> or <tspan> elements.");
        }
        SVG.TRef obj = new SVG.TRef();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTRef(obj, attributes);
        this.currentElement.addChild(obj);
        if (obj.parent instanceof SVG.TextRoot) {
            obj.setTextRoot((SVG.TextRoot)((Object)obj.parent));
        } else {
            obj.setTextRoot(((SVG.TextChild)((Object)obj.parent)).getTextRoot());
        }
    }

    private void parseAttributesTRef(SVG.TRef obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) break;
                    obj.href = val;
                    break;
                }
            }
            ++i;
        }
    }

    private void zwitch(Attributes attributes) throws SAXException {
        this.debug("<switch>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Switch obj = new SVG.Switch();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesConditional(SVG.SvgConditional obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case requiredFeatures: {
                    obj.setRequiredFeatures(SVGParser.parseRequiredFeatures(val));
                    break;
                }
                case requiredExtensions: {
                    obj.setRequiredExtensions(val);
                    break;
                }
                case systemLanguage: {
                    obj.setSystemLanguage(SVGParser.parseSystemLanguage(val));
                    break;
                }
                case requiredFormats: {
                    obj.setRequiredFormats(SVGParser.parseRequiredFormats(val));
                    break;
                }
                case requiredFonts: {
                    List<String> fonts = SVGParser.parseFontFamily(val);
                    HashSet<String> fontSet = fonts != null ? new HashSet<String>(fonts) : new HashSet(0);
                    obj.setRequiredFonts(fontSet);
                    break;
                }
            }
            ++i;
        }
    }

    private void symbol(Attributes attributes) throws SAXException {
        this.debug("<symbol>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Symbol obj = new SVG.Symbol();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void marker(Attributes attributes) throws SAXException {
        this.debug("<marker>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Marker obj = new SVG.Marker();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.parseAttributesMarker(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesMarker(SVG.Marker obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case refX: {
                    obj.refX = SVGParser.parseLength(val);
                    break;
                }
                case refY: {
                    obj.refY = SVGParser.parseLength(val);
                    break;
                }
                case markerWidth: {
                    obj.markerWidth = SVGParser.parseLength(val);
                    if (!obj.markerWidth.isNegative()) break;
                    throw new SAXException("Invalid <marker> element. markerWidth cannot be negative");
                }
                case markerHeight: {
                    obj.markerHeight = SVGParser.parseLength(val);
                    if (!obj.markerHeight.isNegative()) break;
                    throw new SAXException("Invalid <marker> element. markerHeight cannot be negative");
                }
                case markerUnits: {
                    if ("strokeWidth".equals(val)) {
                        obj.markerUnitsAreUser = false;
                        break;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.markerUnitsAreUser = true;
                        break;
                    }
                    throw new SAXException("Invalid value for attribute markerUnits");
                }
                case orient: {
                    if ("auto".equals(val)) {
                        obj.orient = Float.valueOf(Float.NaN);
                        break;
                    }
                    obj.orient = Float.valueOf(SVGParser.parseFloat(val));
                    break;
                }
            }
            ++i;
        }
    }

    private void linearGradient(Attributes attributes) throws SAXException {
        this.debug("<linearGradiant>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.SvgLinearGradient obj = new SVG.SvgLinearGradient();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesGradient(obj, attributes);
        this.parseAttributesLinearGradient(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesGradient(SVG.GradientElement obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case gradientUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.gradientUnitsAreUser = false;
                        break;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.gradientUnitsAreUser = true;
                        break;
                    }
                    throw new SAXException("Invalid value for attribute gradientUnits");
                }
                case gradientTransform: {
                    obj.gradientTransform = this.parseTransformList(val);
                    break;
                }
                case spreadMethod: {
                    try {
                        obj.spreadMethod = SVG.GradientSpread.valueOf(val);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new SAXException("Invalid spreadMethod attribute. \"" + val + "\" is not a valid value.");
                    }
                }
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) break;
                    obj.href = val;
                    break;
                }
            }
            ++i;
        }
    }

    private void parseAttributesLinearGradient(SVG.SvgLinearGradient obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x1: {
                    obj.x1 = SVGParser.parseLength(val);
                    break;
                }
                case y1: {
                    obj.y1 = SVGParser.parseLength(val);
                    break;
                }
                case x2: {
                    obj.x2 = SVGParser.parseLength(val);
                    break;
                }
                case y2: {
                    obj.y2 = SVGParser.parseLength(val);
                    break;
                }
            }
            ++i;
        }
    }

    private void radialGradient(Attributes attributes) throws SAXException {
        this.debug("<radialGradient>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.SvgRadialGradient obj = new SVG.SvgRadialGradient();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesGradient(obj, attributes);
        this.parseAttributesRadialGradient(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesRadialGradient(SVG.SvgRadialGradient obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case cx: {
                    obj.cx = SVGParser.parseLength(val);
                    break;
                }
                case cy: {
                    obj.cy = SVGParser.parseLength(val);
                    break;
                }
                case r: {
                    obj.r = SVGParser.parseLength(val);
                    if (!obj.r.isNegative()) break;
                    throw new SAXException("Invalid <radialGradient> element. r cannot be negative");
                }
                case fx: {
                    obj.fx = SVGParser.parseLength(val);
                    break;
                }
                case fy: {
                    obj.fy = SVGParser.parseLength(val);
                    break;
                }
            }
            ++i;
        }
    }

    private void stop(Attributes attributes) throws SAXException {
        this.debug("<stop>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.GradientElement)) {
            throw new SAXException("Invalid document. <stop> elements are only valid inside <linearGradiant> or <radialGradient> elements.");
        }
        SVG.Stop obj = new SVG.Stop();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesStop(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesStop(SVG.Stop obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case offset: {
                    obj.offset = this.parseGradiantOffset(val);
                    break;
                }
            }
            ++i;
        }
    }

    private Float parseGradiantOffset(String val) throws SAXException {
        if (val.length() == 0) {
            throw new SAXException("Invalid offset value in <stop> (empty string)");
        }
        int end = val.length();
        boolean isPercent = false;
        if (val.charAt(val.length() - 1) == '%') {
            --end;
            isPercent = true;
        }
        try {
            float scalar = Float.parseFloat(val.substring(0, end));
            if (isPercent) {
                scalar /= 100.0f;
            }
            return Float.valueOf(scalar < 0.0f ? 0.0f : (scalar > 100.0f ? 100.0f : scalar));
        }
        catch (NumberFormatException e) {
            throw new SAXException("Invalid offset value in <stop>: " + val, e);
        }
    }

    private void solidColor(Attributes attributes) throws SAXException {
        this.debug("<solidColor>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.SolidColor obj = new SVG.SolidColor();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void clipPath(Attributes attributes) throws SAXException {
        this.debug("<clipPath>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.ClipPath obj = new SVG.ClipPath();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesClipPath(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesClipPath(SVG.ClipPath obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case clipPathUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.clipPathUnitsAreUser = false;
                        break;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.clipPathUnitsAreUser = true;
                        break;
                    }
                    throw new SAXException("Invalid value for attribute clipPathUnits");
                }
            }
            ++i;
        }
    }

    private void textPath(Attributes attributes) throws SAXException {
        this.debug("<textPath>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.TextPath obj = new SVG.TextPath();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTextPath(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
        if (obj.parent instanceof SVG.TextRoot) {
            obj.setTextRoot((SVG.TextRoot)((Object)obj.parent));
        } else {
            obj.setTextRoot(((SVG.TextChild)((Object)obj.parent)).getTextRoot());
        }
    }

    private void parseAttributesTextPath(SVG.TextPath obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) break;
                    obj.href = val;
                    break;
                }
                case startOffset: {
                    obj.startOffset = SVGParser.parseLength(val);
                    break;
                }
            }
            ++i;
        }
    }

    private void pattern(Attributes attributes) throws SAXException {
        this.debug("<pattern>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Pattern obj = new SVG.Pattern();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.parseAttributesPattern(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesPattern(SVG.Pattern obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case patternUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.patternUnitsAreUser = false;
                        break;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.patternUnitsAreUser = true;
                        break;
                    }
                    throw new SAXException("Invalid value for attribute patternUnits");
                }
                case patternContentUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.patternContentUnitsAreUser = false;
                        break;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.patternContentUnitsAreUser = true;
                        break;
                    }
                    throw new SAXException("Invalid value for attribute patternContentUnits");
                }
                case patternTransform: {
                    obj.patternTransform = this.parseTransformList(val);
                    break;
                }
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    break;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    break;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) break;
                    throw new SAXException("Invalid <pattern> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) break;
                    throw new SAXException("Invalid <pattern> element. height cannot be negative");
                }
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) break;
                    obj.href = val;
                    break;
                }
            }
            ++i;
        }
    }

    private void view(Attributes attributes) throws SAXException {
        this.debug("<view>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.View obj = new SVG.View();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void mask(Attributes attributes) throws SAXException {
        this.debug("<mask>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Mask obj = new SVG.Mask();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesMask(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesMask(SVG.Mask obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case maskUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.maskUnitsAreUser = false;
                        break;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.maskUnitsAreUser = true;
                        break;
                    }
                    throw new SAXException("Invalid value for attribute maskUnits");
                }
                case maskContentUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.maskContentUnitsAreUser = false;
                        break;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.maskContentUnitsAreUser = true;
                        break;
                    }
                    throw new SAXException("Invalid value for attribute maskContentUnits");
                }
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    break;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    break;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) break;
                    throw new SAXException("Invalid <mask> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) break;
                    throw new SAXException("Invalid <mask> element. height cannot be negative");
                }
            }
            ++i;
        }
    }

    private void parseAttributesCore(SVG.SvgElementBase obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String qname = attributes.getQName(i);
            if (qname.equals("id") || qname.equals("xml:id")) {
                obj.id = attributes.getValue(i).trim();
                break;
            }
            if (qname.equals("xml:space")) {
                String val = attributes.getValue(i).trim();
                if ("default".equals(val)) {
                    obj.spacePreserve = Boolean.FALSE;
                    break;
                }
                if ("preserve".equals(val)) {
                    obj.spacePreserve = Boolean.TRUE;
                    break;
                }
                throw new SAXException("Invalid value for \"xml:space\" attribute: " + val);
            }
            ++i;
        }
    }

    private void parseAttributesStyle(SVG.SvgElementBase obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            if (val.length() != 0) {
                switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                    case style: {
                        SVGParser.parseStyle(obj, val);
                        break;
                    }
                    case CLASS: {
                        obj.classNames = CSSParser.parseClassAttribute(val);
                        break;
                    }
                    default: {
                        if (obj.baseStyle == null) {
                            obj.baseStyle = new SVG.Style();
                        }
                        SVGParser.processStyleProperty(obj.baseStyle, attributes.getLocalName(i), attributes.getValue(i).trim());
                    }
                }
            }
            ++i;
        }
    }

    private static void parseStyle(SVG.SvgElementBase obj, String style) throws SAXException {
        TextScanner scan = new TextScanner(style.replaceAll("/\\*.*?\\*/", ""));
        while (true) {
            String propertyName = scan.nextToken(':');
            scan.skipWhitespace();
            if (!scan.consume(':')) break;
            scan.skipWhitespace();
            String propertyValue = scan.nextToken(';');
            if (propertyValue == null) break;
            scan.skipWhitespace();
            if (!scan.empty() && !scan.consume(';')) continue;
            if (obj.style == null) {
                obj.style = new SVG.Style();
            }
            SVGParser.processStyleProperty(obj.style, propertyName, propertyValue);
            scan.skipWhitespace();
        }
    }

    protected static void processStyleProperty(SVG.Style style, String localName, String val) throws SAXException {
        if (val.length() == 0) {
            return;
        }
        if (val.equals("inherit")) {
            return;
        }
        switch (SVGAttr.fromString(localName)) {
            case fill: {
                style.fill = SVGParser.parsePaintSpecifier(val, "fill");
                style.specifiedFlags |= 1L;
                break;
            }
            case fill_rule: {
                style.fillRule = SVGParser.parseFillRule(val);
                style.specifiedFlags |= 2L;
                break;
            }
            case fill_opacity: {
                style.fillOpacity = Float.valueOf(SVGParser.parseOpacity(val));
                style.specifiedFlags |= 4L;
                break;
            }
            case stroke: {
                style.stroke = SVGParser.parsePaintSpecifier(val, "stroke");
                style.specifiedFlags |= 8L;
                break;
            }
            case stroke_opacity: {
                style.strokeOpacity = Float.valueOf(SVGParser.parseOpacity(val));
                style.specifiedFlags |= 0x10L;
                break;
            }
            case stroke_width: {
                style.strokeWidth = SVGParser.parseLength(val);
                style.specifiedFlags |= 0x20L;
                break;
            }
            case stroke_linecap: {
                style.strokeLineCap = SVGParser.parseStrokeLineCap(val);
                style.specifiedFlags |= 0x40L;
                break;
            }
            case stroke_linejoin: {
                style.strokeLineJoin = SVGParser.parseStrokeLineJoin(val);
                style.specifiedFlags |= 0x80L;
                break;
            }
            case stroke_miterlimit: {
                style.strokeMiterLimit = Float.valueOf(SVGParser.parseFloat(val));
                style.specifiedFlags |= 0x100L;
                break;
            }
            case stroke_dasharray: {
                style.strokeDashArray = NONE.equals(val) ? null : SVGParser.parseStrokeDashArray(val);
                style.specifiedFlags |= 0x200L;
                break;
            }
            case stroke_dashoffset: {
                style.strokeDashOffset = SVGParser.parseLength(val);
                style.specifiedFlags |= 0x400L;
                break;
            }
            case opacity: {
                style.opacity = Float.valueOf(SVGParser.parseOpacity(val));
                style.specifiedFlags |= 0x800L;
                break;
            }
            case color: {
                style.color = SVGParser.parseColour(val);
                style.specifiedFlags |= 0x1000L;
                break;
            }
            case font: {
                SVGParser.parseFont(style, val);
                break;
            }
            case font_family: {
                style.fontFamily = SVGParser.parseFontFamily(val);
                style.specifiedFlags |= 0x2000L;
                break;
            }
            case font_size: {
                style.fontSize = SVGParser.parseFontSize(val);
                style.specifiedFlags |= 0x4000L;
                break;
            }
            case font_weight: {
                style.fontWeight = SVGParser.parseFontWeight(val);
                style.specifiedFlags |= 0x8000L;
                break;
            }
            case font_style: {
                style.fontStyle = SVGParser.parseFontStyle(val);
                style.specifiedFlags |= 0x10000L;
                break;
            }
            case text_decoration: {
                style.textDecoration = SVGParser.parseTextDecoration(val);
                style.specifiedFlags |= 0x20000L;
                break;
            }
            case direction: {
                style.direction = SVGParser.parseTextDirection(val);
                style.specifiedFlags |= 0x1000000000L;
                break;
            }
            case text_anchor: {
                style.textAnchor = SVGParser.parseTextAnchor(val);
                style.specifiedFlags |= 0x40000L;
                break;
            }
            case overflow: {
                style.overflow = SVGParser.parseOverflow(val);
                style.specifiedFlags |= 0x80000L;
                break;
            }
            case marker: {
                style.markerMid = style.markerStart = SVGParser.parseFunctionalIRI(val, localName);
                style.markerEnd = style.markerStart;
                style.specifiedFlags |= 0xE00000L;
                break;
            }
            case marker_start: {
                style.markerStart = SVGParser.parseFunctionalIRI(val, localName);
                style.specifiedFlags |= 0x200000L;
                break;
            }
            case marker_mid: {
                style.markerMid = SVGParser.parseFunctionalIRI(val, localName);
                style.specifiedFlags |= 0x400000L;
                break;
            }
            case marker_end: {
                style.markerEnd = SVGParser.parseFunctionalIRI(val, localName);
                style.specifiedFlags |= 0x800000L;
                break;
            }
            case display: {
                if (val.indexOf(124) >= 0 || VALID_DISPLAY_VALUES.indexOf(String.valueOf('|') + val + '|') == -1) {
                    throw new SAXException("Invalid value for \"display\" attribute: " + val);
                }
                style.display = !val.equals(NONE);
                style.specifiedFlags |= 0x1000000L;
                break;
            }
            case visibility: {
                if (val.indexOf(124) >= 0 || VALID_VISIBILITY_VALUES.indexOf(String.valueOf('|') + val + '|') == -1) {
                    throw new SAXException("Invalid value for \"visibility\" attribute: " + val);
                }
                style.visibility = val.equals("visible");
                style.specifiedFlags |= 0x2000000L;
                break;
            }
            case stop_color: {
                style.stopColor = val.equals(CURRENTCOLOR) ? SVG.CurrentColor.getInstance() : SVGParser.parseColour(val);
                style.specifiedFlags |= 0x4000000L;
                break;
            }
            case stop_opacity: {
                style.stopOpacity = Float.valueOf(SVGParser.parseOpacity(val));
                style.specifiedFlags |= 0x8000000L;
                break;
            }
            case clip: {
                style.clip = SVGParser.parseClip(val);
                style.specifiedFlags |= 0x100000L;
                break;
            }
            case clip_path: {
                style.clipPath = SVGParser.parseFunctionalIRI(val, localName);
                style.specifiedFlags |= 0x10000000L;
                break;
            }
            case clip_rule: {
                style.clipRule = SVGParser.parseFillRule(val);
                style.specifiedFlags |= 0x20000000L;
                break;
            }
            case mask: {
                style.mask = SVGParser.parseFunctionalIRI(val, localName);
                style.specifiedFlags |= 0x40000000L;
                break;
            }
            case solid_color: {
                style.solidColor = val.equals(CURRENTCOLOR) ? SVG.CurrentColor.getInstance() : SVGParser.parseColour(val);
                style.specifiedFlags |= 0x80000000L;
                break;
            }
            case solid_opacity: {
                style.solidOpacity = Float.valueOf(SVGParser.parseOpacity(val));
                style.specifiedFlags |= 0x100000000L;
                break;
            }
            case viewport_fill: {
                style.viewportFill = val.equals(CURRENTCOLOR) ? SVG.CurrentColor.getInstance() : SVGParser.parseColour(val);
                style.specifiedFlags |= 0x200000000L;
                break;
            }
            case viewport_fill_opacity: {
                style.viewportFillOpacity = Float.valueOf(SVGParser.parseOpacity(val));
                style.specifiedFlags |= 0x400000000L;
                break;
            }
            case vector_effect: {
                style.vectorEffect = SVGParser.parseVectorEffect(val);
                style.specifiedFlags |= 0x800000000L;
                break;
            }
        }
    }

    private void parseAttributesViewBox(SVG.SvgViewBoxContainer obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case viewBox: {
                    obj.viewBox = SVGParser.parseViewBox(val);
                    break;
                }
                case preserveAspectRatio: {
                    SVGParser.parsePreserveAspectRatio(obj, val);
                    break;
                }
            }
            ++i;
        }
    }

    private void parseAttributesTransform(SVG.HasTransform obj, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            if (SVGAttr.fromString(attributes.getLocalName(i)) == SVGAttr.transform) {
                obj.setTransform(this.parseTransformList(attributes.getValue(i)));
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Matrix parseTransformList(String val) throws SAXException {
        Matrix matrix = new Matrix();
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        while (!scan.empty()) {
            Float ang;
            String cmd = scan.nextFunction();
            if (cmd == null) {
                throw new SAXException("Bad transform function encountered in transform list: " + val);
            }
            if (cmd.equals("matrix")) {
                scan.skipWhitespace();
                Float a = scan.nextFloat();
                scan.skipCommaWhitespace();
                Float b = scan.nextFloat();
                scan.skipCommaWhitespace();
                Float c = scan.nextFloat();
                scan.skipCommaWhitespace();
                Float d = scan.nextFloat();
                scan.skipCommaWhitespace();
                Float e = scan.nextFloat();
                scan.skipCommaWhitespace();
                Float f = scan.nextFloat();
                scan.skipWhitespace();
                if (f == null || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                Matrix m = new Matrix();
                m.setValues(new float[]{a.floatValue(), c.floatValue(), e.floatValue(), b.floatValue(), d.floatValue(), f.floatValue(), 0.0f, 0.0f, 1.0f});
                matrix.preConcat(m);
            } else if (cmd.equals("translate")) {
                scan.skipWhitespace();
                Float tx = scan.nextFloat();
                Float ty = scan.possibleNextFloat();
                scan.skipWhitespace();
                if (tx == null || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                if (ty == null) {
                    matrix.preTranslate(tx.floatValue(), 0.0f);
                } else {
                    matrix.preTranslate(tx.floatValue(), ty.floatValue());
                }
            } else if (cmd.equals("scale")) {
                scan.skipWhitespace();
                Float sx = scan.nextFloat();
                Float sy = scan.possibleNextFloat();
                scan.skipWhitespace();
                if (sx == null || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                if (sy == null) {
                    matrix.preScale(sx.floatValue(), sx.floatValue());
                } else {
                    matrix.preScale(sx.floatValue(), sy.floatValue());
                }
            } else if (cmd.equals("rotate")) {
                scan.skipWhitespace();
                ang = scan.nextFloat();
                Float cx = scan.possibleNextFloat();
                Float cy = scan.possibleNextFloat();
                scan.skipWhitespace();
                if (ang == null || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                if (cx == null) {
                    matrix.preRotate(ang.floatValue());
                } else {
                    if (cy == null) throw new SAXException("Invalid transform list: " + val);
                    matrix.preRotate(ang.floatValue(), cx.floatValue(), cy.floatValue());
                }
            } else if (cmd.equals("skewX")) {
                scan.skipWhitespace();
                ang = scan.nextFloat();
                scan.skipWhitespace();
                if (ang == null || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                matrix.preSkew((float)Math.tan(Math.toRadians(ang.floatValue())), 0.0f);
            } else if (cmd.equals("skewY")) {
                scan.skipWhitespace();
                ang = scan.nextFloat();
                scan.skipWhitespace();
                if (ang == null || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                matrix.preSkew(0.0f, (float)Math.tan(Math.toRadians(ang.floatValue())));
            } else if (cmd != null) {
                throw new SAXException("Invalid transform list fn: " + cmd + ")");
            }
            if (scan.empty()) return matrix;
            scan.skipCommaWhitespace();
        }
        return matrix;
    }

    protected static SVG.Length parseLength(String val) throws SAXException {
        if (val.length() == 0) {
            throw new SAXException("Invalid length value (empty string)");
        }
        int end = val.length();
        SVG.Unit unit = SVG.Unit.px;
        char lastChar = val.charAt(end - 1);
        if (lastChar == '%') {
            --end;
            unit = SVG.Unit.percent;
        } else if (end > 2 && Character.isLetter(lastChar) && Character.isLetter(val.charAt(end - 2))) {
            String unitStr = val.substring(end -= 2);
            try {
                unit = SVG.Unit.valueOf(unitStr.toLowerCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                throw new SAXException("Invalid length unit specifier: " + val);
            }
        }
        try {
            float scalar = Float.parseFloat(val.substring(0, end));
            return new SVG.Length(scalar, unit);
        }
        catch (NumberFormatException e) {
            throw new SAXException("Invalid length value: " + val, e);
        }
    }

    private static List<SVG.Length> parseLengthList(String val) throws SAXException {
        if (val.length() == 0) {
            throw new SAXException("Invalid length list (empty string)");
        }
        ArrayList<SVG.Length> coords = new ArrayList<SVG.Length>(1);
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        while (!scan.empty()) {
            Float scalar = scan.nextFloat();
            if (scalar == null) {
                throw new SAXException("Invalid length list value: " + scan.ahead());
            }
            SVG.Unit unit = scan.nextUnit();
            if (unit == null) {
                unit = SVG.Unit.px;
            }
            coords.add(new SVG.Length(scalar.floatValue(), unit));
            scan.skipCommaWhitespace();
        }
        return coords;
    }

    private static float parseFloat(String val) throws SAXException {
        if (val.length() == 0) {
            throw new SAXException("Invalid float value (empty string)");
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            throw new SAXException("Invalid float value: " + val, e);
        }
    }

    private static float parseOpacity(String val) throws SAXException {
        float o = SVGParser.parseFloat(val);
        return o < 0.0f ? 0.0f : (o > 1.0f ? 1.0f : o);
    }

    private static SVG.Box parseViewBox(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        Float minX = scan.nextFloat();
        scan.skipCommaWhitespace();
        Float minY = scan.nextFloat();
        scan.skipCommaWhitespace();
        Float width = scan.nextFloat();
        scan.skipCommaWhitespace();
        Float height = scan.nextFloat();
        if (minX == null || minY == null || width == null || height == null) {
            throw new SAXException("Invalid viewBox definition - should have four numbers");
        }
        if (width.floatValue() < 0.0f) {
            throw new SAXException("Invalid viewBox. width cannot be negative");
        }
        if (height.floatValue() < 0.0f) {
            throw new SAXException("Invalid viewBox. height cannot be negative");
        }
        return new SVG.Box(minX.floatValue(), minY.floatValue(), width.floatValue(), height.floatValue());
    }

    private static void parsePreserveAspectRatio(SVG.SvgPreserveAspectRatioContainer obj, String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        PreserveAspectRatio.Alignment align = null;
        PreserveAspectRatio.Scale scale = null;
        String word = scan.nextToken();
        if ("defer".equals(word)) {
            scan.skipWhitespace();
            word = scan.nextToken();
        }
        align = aspectRatioKeywords.get(word);
        scan.skipWhitespace();
        if (!scan.empty()) {
            String meetOrSlice = scan.nextToken();
            if (meetOrSlice.equals("meet")) {
                scale = PreserveAspectRatio.Scale.Meet;
            } else if (meetOrSlice.equals("slice")) {
                scale = PreserveAspectRatio.Scale.Slice;
            } else {
                throw new SAXException("Invalid preserveAspectRatio definition: " + val);
            }
        }
        obj.preserveAspectRatio = new PreserveAspectRatio(align, scale);
    }

    private static SVG.SvgPaint parsePaintSpecifier(String val, String attrName) throws SAXException {
        if (val.startsWith("url(")) {
            int closeBracket = val.indexOf(")");
            if (closeBracket == -1) {
                throw new SAXException("Bad " + attrName + " attribute. Unterminated url() reference");
            }
            String href = val.substring(4, closeBracket).trim();
            SVG.SvgPaint fallback = null;
            if ((val = val.substring(closeBracket + 1).trim()).length() > 0) {
                fallback = SVGParser.parseColourSpecifer(val);
            }
            return new SVG.PaintReference(href, fallback);
        }
        return SVGParser.parseColourSpecifer(val);
    }

    private static SVG.SvgPaint parseColourSpecifer(String val) throws SAXException {
        if (val.equals(NONE)) {
            return null;
        }
        if (val.equals(CURRENTCOLOR)) {
            return SVG.CurrentColor.getInstance();
        }
        return SVGParser.parseColour(val);
    }

    private static SVG.Colour parseColour(String val) throws SAXException {
        if (val.charAt(0) == '#') {
            try {
                if (val.length() == 7) {
                    return new SVG.Colour(Integer.parseInt(val.substring(1), 16));
                }
                if (val.length() == 4) {
                    int threehex = Integer.parseInt(val.substring(1), 16);
                    int h1 = threehex & 0xF00;
                    int h2 = threehex & 0xF0;
                    int h3 = threehex & 0xF;
                    return new SVG.Colour(h1 << 16 | h1 << 12 | h2 << 8 | h2 << 4 | h3 << 4 | h3);
                }
                throw new SAXException("Bad hex colour value: " + val);
            }
            catch (NumberFormatException e) {
                throw new SAXException("Bad colour value: " + val);
            }
        }
        if (val.toLowerCase(Locale.US).startsWith("rgb(")) {
            TextScanner scan = new TextScanner(val.substring(4));
            scan.skipWhitespace();
            int red = SVGParser.parseColourComponent(scan);
            scan.skipCommaWhitespace();
            int green = SVGParser.parseColourComponent(scan);
            scan.skipCommaWhitespace();
            int blue = SVGParser.parseColourComponent(scan);
            scan.skipWhitespace();
            if (!scan.consume(')')) {
                throw new SAXException("Bad rgb() colour value: " + val);
            }
            return new SVG.Colour(red << 16 | green << 8 | blue);
        }
        return SVGParser.parseColourKeyword(val);
    }

    private static int parseColourComponent(TextScanner scan) throws SAXException {
        float comp = scan.nextFloat().floatValue();
        if (scan.consume('%')) {
            comp = comp * 256.0f / 100.0f;
        }
        return comp < 0.0f ? 0 : (comp > 255.0f ? 255 : (int)comp);
    }

    private static SVG.Colour parseColourKeyword(String name) throws SAXException {
        Integer col = colourKeywords.get(name.toLowerCase(Locale.US));
        if (col == null) {
            throw new SAXException("Invalid colour keyword: " + name);
        }
        return new SVG.Colour(col);
    }

    private static void parseFont(SVG.Style style, String val) throws SAXException {
        List<String> fontFamily = null;
        SVG.Length fontSize = null;
        Integer fontWeight = null;
        SVG.Style.FontStyle fontStyle = null;
        String fontVariant = null;
        if ("|caption|icon|menu|message-box|small-caption|status-bar|".indexOf(String.valueOf('|') + val + '|') != -1) {
            return;
        }
        TextScanner scan = new TextScanner(val);
        String item = null;
        while (true) {
            item = scan.nextToken('/');
            scan.skipWhitespace();
            if (item == null) {
                throw new SAXException("Invalid font style attribute: missing font size and family");
            }
            if (fontWeight != null && fontStyle != null) break;
            if (item.equals("normal") || fontWeight == null && (fontWeight = fontWeightKeywords.get(item)) != null || fontStyle == null && (fontStyle = fontStyleKeywords.get(item)) != null) continue;
            if (fontVariant != null || !item.equals("small-caps")) break;
            fontVariant = item;
        }
        fontSize = SVGParser.parseFontSize(item);
        if (scan.consume('/')) {
            scan.skipWhitespace();
            item = scan.nextToken();
            if (item == null) {
                throw new SAXException("Invalid font style attribute: missing line-height");
            }
            SVGParser.parseLength(item);
            scan.skipWhitespace();
        }
        fontFamily = SVGParser.parseFontFamily(scan.restOfText());
        style.fontFamily = fontFamily;
        style.fontSize = fontSize;
        style.fontWeight = fontWeight == null ? 400 : fontWeight;
        style.fontStyle = fontStyle == null ? SVG.Style.FontStyle.Normal : fontStyle;
        style.specifiedFlags |= 0x1E000L;
    }

    private static List<String> parseFontFamily(String val) throws SAXException {
        ArrayList<String> fonts = null;
        TextScanner scan = new TextScanner(val);
        do {
            String item;
            if ((item = scan.nextQuotedString()) == null) {
                item = scan.nextToken(',');
            }
            if (item == null) break;
            if (fonts == null) {
                fonts = new ArrayList<String>();
            }
            fonts.add(item);
            scan.skipCommaWhitespace();
        } while (!scan.empty());
        return fonts;
    }

    private static SVG.Length parseFontSize(String val) throws SAXException {
        SVG.Length size = fontSizeKeywords.get(val);
        if (size == null) {
            size = SVGParser.parseLength(val);
        }
        return size;
    }

    private static Integer parseFontWeight(String val) throws SAXException {
        Integer wt = fontWeightKeywords.get(val);
        if (wt == null) {
            throw new SAXException("Invalid font-weight property: " + val);
        }
        return wt;
    }

    private static SVG.Style.FontStyle parseFontStyle(String val) throws SAXException {
        SVG.Style.FontStyle fs = fontStyleKeywords.get(val);
        if (fs == null) {
            throw new SAXException("Invalid font-style property: " + val);
        }
        return fs;
    }

    private static SVG.Style.TextDecoration parseTextDecoration(String val) throws SAXException {
        if (NONE.equals(val)) {
            return SVG.Style.TextDecoration.None;
        }
        if ("underline".equals(val)) {
            return SVG.Style.TextDecoration.Underline;
        }
        if ("overline".equals(val)) {
            return SVG.Style.TextDecoration.Overline;
        }
        if ("line-through".equals(val)) {
            return SVG.Style.TextDecoration.LineThrough;
        }
        if ("blink".equals(val)) {
            return SVG.Style.TextDecoration.Blink;
        }
        throw new SAXException("Invalid text-decoration property: " + val);
    }

    private static SVG.Style.TextDirection parseTextDirection(String val) throws SAXException {
        if ("ltr".equals(val)) {
            return SVG.Style.TextDirection.LTR;
        }
        if ("rtl".equals(val)) {
            return SVG.Style.TextDirection.RTL;
        }
        throw new SAXException("Invalid direction property: " + val);
    }

    private static SVG.Style.FillRule parseFillRule(String val) throws SAXException {
        if ("nonzero".equals(val)) {
            return SVG.Style.FillRule.NonZero;
        }
        if ("evenodd".equals(val)) {
            return SVG.Style.FillRule.EvenOdd;
        }
        throw new SAXException("Invalid fill-rule property: " + val);
    }

    private static SVG.Style.LineCaps parseStrokeLineCap(String val) throws SAXException {
        if ("butt".equals(val)) {
            return SVG.Style.LineCaps.Butt;
        }
        if ("round".equals(val)) {
            return SVG.Style.LineCaps.Round;
        }
        if ("square".equals(val)) {
            return SVG.Style.LineCaps.Square;
        }
        throw new SAXException("Invalid stroke-linecap property: " + val);
    }

    private static SVG.Style.LineJoin parseStrokeLineJoin(String val) throws SAXException {
        if ("miter".equals(val)) {
            return SVG.Style.LineJoin.Miter;
        }
        if ("round".equals(val)) {
            return SVG.Style.LineJoin.Round;
        }
        if ("bevel".equals(val)) {
            return SVG.Style.LineJoin.Bevel;
        }
        throw new SAXException("Invalid stroke-linejoin property: " + val);
    }

    private static SVG.Length[] parseStrokeDashArray(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        if (scan.empty()) {
            return null;
        }
        SVG.Length dash = scan.nextLength();
        if (dash == null) {
            return null;
        }
        if (dash.isNegative()) {
            throw new SAXException("Invalid stroke-dasharray. Dash segemnts cannot be negative: " + val);
        }
        float sum = dash.floatValue();
        ArrayList<SVG.Length> dashes = new ArrayList<SVG.Length>();
        dashes.add(dash);
        while (!scan.empty()) {
            scan.skipCommaWhitespace();
            dash = scan.nextLength();
            if (dash == null) {
                throw new SAXException("Invalid stroke-dasharray. Non-Length content found: " + val);
            }
            if (dash.isNegative()) {
                throw new SAXException("Invalid stroke-dasharray. Dash segemnts cannot be negative: " + val);
            }
            dashes.add(dash);
            sum += dash.floatValue();
        }
        if (sum == 0.0f) {
            return null;
        }
        return dashes.toArray(new SVG.Length[dashes.size()]);
    }

    private static SVG.Style.TextAnchor parseTextAnchor(String val) throws SAXException {
        if ("start".equals(val)) {
            return SVG.Style.TextAnchor.Start;
        }
        if ("middle".equals(val)) {
            return SVG.Style.TextAnchor.Middle;
        }
        if ("end".equals(val)) {
            return SVG.Style.TextAnchor.End;
        }
        throw new SAXException("Invalid text-anchor property: " + val);
    }

    private static Boolean parseOverflow(String val) throws SAXException {
        if ("visible".equals(val) || "auto".equals(val)) {
            return Boolean.TRUE;
        }
        if ("hidden".equals(val) || "scroll".equals(val)) {
            return Boolean.FALSE;
        }
        throw new SAXException("Invalid toverflow property: " + val);
    }

    private static SVG.CSSClipRect parseClip(String val) throws SAXException {
        if ("auto".equals(val)) {
            return null;
        }
        if (!val.toLowerCase(Locale.US).startsWith("rect(")) {
            throw new SAXException("Invalid clip attribute shape. Only rect() is supported.");
        }
        TextScanner scan = new TextScanner(val.substring(5));
        scan.skipWhitespace();
        SVG.Length top = SVGParser.parseLengthOrAuto(scan);
        scan.skipCommaWhitespace();
        SVG.Length right = SVGParser.parseLengthOrAuto(scan);
        scan.skipCommaWhitespace();
        SVG.Length bottom = SVGParser.parseLengthOrAuto(scan);
        scan.skipCommaWhitespace();
        SVG.Length left = SVGParser.parseLengthOrAuto(scan);
        scan.skipWhitespace();
        if (!scan.consume(')')) {
            throw new SAXException("Bad rect() clip definition: " + val);
        }
        return new SVG.CSSClipRect(top, right, bottom, left);
    }

    private static SVG.Length parseLengthOrAuto(TextScanner scan) {
        if (scan.consume("auto")) {
            return new SVG.Length(0.0f);
        }
        return scan.nextLength();
    }

    private static SVG.Style.VectorEffect parseVectorEffect(String val) throws SAXException {
        if (NONE.equals(val)) {
            return SVG.Style.VectorEffect.None;
        }
        if ("non-scaling-stroke".equals(val)) {
            return SVG.Style.VectorEffect.NonScalingStroke;
        }
        throw new SAXException("Invalid vector-effect property: " + val);
    }

    private static SVG.PathDefinition parsePath(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        int pathCommand = 63;
        float currentX = 0.0f;
        float currentY = 0.0f;
        float lastMoveX = 0.0f;
        float lastMoveY = 0.0f;
        float lastControlX = 0.0f;
        float lastControlY = 0.0f;
        SVG.PathDefinition path = new SVG.PathDefinition();
        if (scan.empty()) {
            return path;
        }
        pathCommand = scan.nextChar();
        if (pathCommand != 77 && pathCommand != 109) {
            return path;
        }
        while (true) {
            scan.skipWhitespace();
            switch (pathCommand) {
                case 77: 
                case 109: {
                    Float x = scan.nextFloat();
                    Float y = scan.checkedNextFloat(x);
                    if (y == null) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 109 && !path.isEmpty()) {
                        x = Float.valueOf(x.floatValue() + currentX);
                        y = Float.valueOf(y.floatValue() + currentY);
                    }
                    path.moveTo(x.floatValue(), y.floatValue());
                    lastMoveX = lastControlX = x.floatValue();
                    currentX = lastControlX;
                    lastMoveY = lastControlY = y.floatValue();
                    currentY = lastControlY;
                    pathCommand = pathCommand == 109 ? 108 : 76;
                    break;
                }
                case 76: 
                case 108: {
                    Float x = scan.nextFloat();
                    Float y = scan.checkedNextFloat(x);
                    if (y == null) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 108) {
                        x = Float.valueOf(x.floatValue() + currentX);
                        y = Float.valueOf(y.floatValue() + currentY);
                    }
                    path.lineTo(x.floatValue(), y.floatValue());
                    currentX = lastControlX = x.floatValue();
                    currentY = lastControlY = y.floatValue();
                    break;
                }
                case 67: 
                case 99: {
                    Float x1 = scan.nextFloat();
                    Float y1 = scan.checkedNextFloat(x1);
                    Float x2 = scan.checkedNextFloat(y1);
                    Float y2 = scan.checkedNextFloat(x2);
                    Float x = scan.checkedNextFloat(y2);
                    Float y = scan.checkedNextFloat(x);
                    if (y == null) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 99) {
                        x = Float.valueOf(x.floatValue() + currentX);
                        y = Float.valueOf(y.floatValue() + currentY);
                        x1 = Float.valueOf(x1.floatValue() + currentX);
                        y1 = Float.valueOf(y1.floatValue() + currentY);
                        x2 = Float.valueOf(x2.floatValue() + currentX);
                        y2 = Float.valueOf(y2.floatValue() + currentY);
                    }
                    path.cubicTo(x1.floatValue(), y1.floatValue(), x2.floatValue(), y2.floatValue(), x.floatValue(), y.floatValue());
                    lastControlX = x2.floatValue();
                    lastControlY = y2.floatValue();
                    currentX = x.floatValue();
                    currentY = y.floatValue();
                    break;
                }
                case 83: 
                case 115: {
                    Float x1 = Float.valueOf(2.0f * currentX - lastControlX);
                    Float y1 = Float.valueOf(2.0f * currentY - lastControlY);
                    Float x2 = scan.nextFloat();
                    Float y2 = scan.checkedNextFloat(x2);
                    Float x = scan.checkedNextFloat(y2);
                    Float y = scan.checkedNextFloat(x);
                    if (y == null) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 115) {
                        x = Float.valueOf(x.floatValue() + currentX);
                        y = Float.valueOf(y.floatValue() + currentY);
                        x2 = Float.valueOf(x2.floatValue() + currentX);
                        y2 = Float.valueOf(y2.floatValue() + currentY);
                    }
                    path.cubicTo(x1.floatValue(), y1.floatValue(), x2.floatValue(), y2.floatValue(), x.floatValue(), y.floatValue());
                    lastControlX = x2.floatValue();
                    lastControlY = y2.floatValue();
                    currentX = x.floatValue();
                    currentY = y.floatValue();
                    break;
                }
                case 90: 
                case 122: {
                    path.close();
                    currentX = lastControlX = lastMoveX;
                    currentY = lastControlY = lastMoveY;
                    break;
                }
                case 72: 
                case 104: {
                    Float x = scan.nextFloat();
                    if (x == null) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 104) {
                        x = Float.valueOf(x.floatValue() + currentX);
                    }
                    path.lineTo(x.floatValue(), currentY);
                    currentX = lastControlX = x.floatValue();
                    break;
                }
                case 86: 
                case 118: {
                    Float y = scan.nextFloat();
                    if (y == null) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 118) {
                        y = Float.valueOf(y.floatValue() + currentY);
                    }
                    path.lineTo(currentX, y.floatValue());
                    currentY = lastControlY = y.floatValue();
                    break;
                }
                case 81: 
                case 113: {
                    Float x1 = scan.nextFloat();
                    Float y1 = scan.checkedNextFloat(x1);
                    Float x = scan.checkedNextFloat(y1);
                    Float y = scan.checkedNextFloat(x);
                    if (y == null) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 113) {
                        x = Float.valueOf(x.floatValue() + currentX);
                        y = Float.valueOf(y.floatValue() + currentY);
                        x1 = Float.valueOf(x1.floatValue() + currentX);
                        y1 = Float.valueOf(y1.floatValue() + currentY);
                    }
                    path.quadTo(x1.floatValue(), y1.floatValue(), x.floatValue(), y.floatValue());
                    lastControlX = x1.floatValue();
                    lastControlY = y1.floatValue();
                    currentX = x.floatValue();
                    currentY = y.floatValue();
                    break;
                }
                case 84: 
                case 116: {
                    Float x1 = Float.valueOf(2.0f * currentX - lastControlX);
                    Float y1 = Float.valueOf(2.0f * currentY - lastControlY);
                    Float x = scan.nextFloat();
                    Float y = scan.checkedNextFloat(x);
                    if (y == null) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 116) {
                        x = Float.valueOf(x.floatValue() + currentX);
                        y = Float.valueOf(y.floatValue() + currentY);
                    }
                    path.quadTo(x1.floatValue(), y1.floatValue(), x.floatValue(), y.floatValue());
                    lastControlX = x1.floatValue();
                    lastControlY = y1.floatValue();
                    currentX = x.floatValue();
                    currentY = y.floatValue();
                    break;
                }
                case 65: 
                case 97: {
                    Float rx = scan.nextFloat();
                    Float ry = scan.checkedNextFloat(rx);
                    Float xAxisRotation = scan.checkedNextFloat(ry);
                    Boolean largeArcFlag = scan.checkedNextFlag(xAxisRotation);
                    Boolean sweepFlag = scan.checkedNextFlag(largeArcFlag);
                    Float x = scan.checkedNextFloat(sweepFlag);
                    Float y = scan.checkedNextFloat(x);
                    if (y == null || rx.floatValue() < 0.0f || ry.floatValue() < 0.0f) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 97) {
                        x = Float.valueOf(x.floatValue() + currentX);
                        y = Float.valueOf(y.floatValue() + currentY);
                    }
                    path.arcTo(rx.floatValue(), ry.floatValue(), xAxisRotation.floatValue(), largeArcFlag, sweepFlag, x.floatValue(), y.floatValue());
                    currentX = lastControlX = x.floatValue();
                    currentY = lastControlY = y.floatValue();
                    break;
                }
                default: {
                    return path;
                }
            }
            scan.skipCommaWhitespace();
            if (scan.empty()) break;
            if (!scan.hasLetter()) continue;
            pathCommand = scan.nextChar();
        }
        return path;
    }

    private static Set<String> parseRequiredFeatures(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        HashSet<String> result = new HashSet<String>();
        while (!scan.empty()) {
            String feature = scan.nextToken();
            if (feature.startsWith(FEATURE_STRING_PREFIX)) {
                result.add(feature.substring(FEATURE_STRING_PREFIX.length()));
            } else {
                result.add("UNSUPPORTED");
            }
            scan.skipWhitespace();
        }
        return result;
    }

    private static Set<String> parseSystemLanguage(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        HashSet<String> result = new HashSet<String>();
        while (!scan.empty()) {
            String language = scan.nextToken();
            int hyphenPos = language.indexOf(45);
            if (hyphenPos != -1) {
                language = language.substring(0, hyphenPos);
            }
            language = new Locale(language, "", "").getLanguage();
            result.add(language);
            scan.skipWhitespace();
        }
        return result;
    }

    private static Set<String> parseRequiredFormats(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        HashSet<String> result = new HashSet<String>();
        while (!scan.empty()) {
            String mimetype = scan.nextToken();
            result.add(mimetype);
            scan.skipWhitespace();
        }
        return result;
    }

    private static String parseFunctionalIRI(String val, String attrName) throws SAXException {
        if (val.equals(NONE)) {
            return null;
        }
        if (!val.startsWith("url(") || !val.endsWith(")")) {
            throw new SAXException("Bad " + attrName + " attribute. Expected \"none\" or \"url()\" format");
        }
        return val.substring(4, val.length() - 1).trim();
    }

    private void style(Attributes attributes) throws SAXException {
        this.debug("<style>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        boolean isTextCSS = true;
        String media = "all";
        int i = 0;
        while (i < attributes.getLength()) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case type: {
                    isTextCSS = val.equals("text/css");
                    break;
                }
                case media: {
                    media = val;
                    break;
                }
            }
            ++i;
        }
        if (isTextCSS && CSSParser.mediaMatches(media, CSSParser.MediaType.screen)) {
            this.inStyleElement = true;
        } else {
            this.ignoring = true;
            this.ignoreDepth = 1;
        }
    }

    private void parseCSSStyleSheet(String sheet) throws SAXException {
        CSSParser cssp = new CSSParser(CSSParser.MediaType.screen);
        this.svgDocument.addCSSRules(cssp.parse(sheet));
    }

    private static enum SVGAttr {
        CLASS,
        clip,
        clip_path,
        clipPathUnits,
        clip_rule,
        color,
        cx,
        cy,
        direction,
        dx,
        dy,
        fx,
        fy,
        d,
        display,
        fill,
        fill_rule,
        fill_opacity,
        font,
        font_family,
        font_size,
        font_weight,
        font_style,
        gradientTransform,
        gradientUnits,
        height,
        href,
        id,
        marker,
        marker_start,
        marker_mid,
        marker_end,
        markerHeight,
        markerUnits,
        markerWidth,
        mask,
        maskContentUnits,
        maskUnits,
        media,
        offset,
        opacity,
        orient,
        overflow,
        pathLength,
        patternContentUnits,
        patternTransform,
        patternUnits,
        points,
        preserveAspectRatio,
        r,
        refX,
        refY,
        requiredFeatures,
        requiredExtensions,
        requiredFormats,
        requiredFonts,
        rx,
        ry,
        solid_color,
        solid_opacity,
        spreadMethod,
        startOffset,
        stop_color,
        stop_opacity,
        stroke,
        stroke_dasharray,
        stroke_dashoffset,
        stroke_linecap,
        stroke_linejoin,
        stroke_miterlimit,
        stroke_opacity,
        stroke_width,
        style,
        systemLanguage,
        text_anchor,
        text_decoration,
        transform,
        type,
        vector_effect,
        version,
        viewBox,
        width,
        x,
        y,
        x1,
        y1,
        x2,
        y2,
        viewport_fill,
        viewport_fill_opacity,
        visibility,
        UNSUPPORTED;


        public static SVGAttr fromString(String str) {
            if (str.equals("class")) {
                return CLASS;
            }
            if (str.indexOf(95) != -1) {
                return UNSUPPORTED;
            }
            try {
                return SVGAttr.valueOf(str.replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                return UNSUPPORTED;
            }
        }
    }

    protected static class TextScanner {
        protected String input;
        protected int position = 0;

        public TextScanner(String input) {
            this.input = input.trim();
        }

        public boolean empty() {
            return this.position == this.input.length();
        }

        protected boolean isWhitespace(int c) {
            return c == 32 || c == 10 || c == 13 || c == 9;
        }

        public void skipWhitespace() {
            while (this.position < this.input.length()) {
                if (!this.isWhitespace(this.input.charAt(this.position))) break;
                ++this.position;
            }
        }

        protected boolean isEOL(int c) {
            return c == 10 || c == 13;
        }

        public boolean skipCommaWhitespace() {
            this.skipWhitespace();
            if (this.position == this.input.length()) {
                return false;
            }
            if (this.input.charAt(this.position) != ',') {
                return false;
            }
            ++this.position;
            this.skipWhitespace();
            return true;
        }

        public Float nextFloat() {
            int floatEnd = this.scanForFloat();
            if (floatEnd == this.position) {
                return null;
            }
            Float result = Float.valueOf(Float.parseFloat(this.input.substring(this.position, floatEnd)));
            this.position = floatEnd;
            return result;
        }

        public Float possibleNextFloat() {
            int start = this.position;
            this.skipCommaWhitespace();
            Float result = this.nextFloat();
            if (result != null) {
                return result;
            }
            this.position = start;
            return null;
        }

        public Float checkedNextFloat(Object lastRead) {
            if (lastRead == null) {
                return null;
            }
            this.skipCommaWhitespace();
            return this.nextFloat();
        }

        public Integer nextInteger() {
            int intEnd = this.scanForInteger();
            if (intEnd == this.position) {
                return null;
            }
            Integer result = Integer.parseInt(this.input.substring(this.position, intEnd));
            this.position = intEnd;
            return result;
        }

        public Integer nextChar() {
            if (this.position == this.input.length()) {
                return null;
            }
            return this.input.charAt(this.position++);
        }

        public SVG.Length nextLength() {
            Float scalar = this.nextFloat();
            if (scalar == null) {
                return null;
            }
            SVG.Unit unit = this.nextUnit();
            if (unit == null) {
                return new SVG.Length(scalar.floatValue(), SVG.Unit.px);
            }
            return new SVG.Length(scalar.floatValue(), unit);
        }

        public Boolean nextFlag() {
            if (this.position == this.input.length()) {
                return null;
            }
            char ch = this.input.charAt(this.position);
            if (ch == '0' || ch == '1') {
                ++this.position;
                return ch == '1';
            }
            return null;
        }

        public Boolean checkedNextFlag(Object lastRead) {
            if (lastRead == null) {
                return null;
            }
            this.skipCommaWhitespace();
            return this.nextFlag();
        }

        public boolean consume(char ch) {
            boolean found;
            boolean bl = found = this.position < this.input.length() && this.input.charAt(this.position) == ch;
            if (found) {
                ++this.position;
            }
            return found;
        }

        public boolean consume(String str) {
            boolean found;
            int len = str.length();
            boolean bl = found = this.position <= this.input.length() - len && this.input.substring(this.position, this.position + len).equals(str);
            if (found) {
                this.position += len;
            }
            return found;
        }

        protected int advanceChar() {
            if (this.position == this.input.length()) {
                return -1;
            }
            ++this.position;
            if (this.position < this.input.length()) {
                return this.input.charAt(this.position);
            }
            return -1;
        }

        public String nextToken() {
            return this.nextToken(' ');
        }

        public String nextToken(char terminator) {
            if (this.empty()) {
                return null;
            }
            int ch = this.input.charAt(this.position);
            if (this.isWhitespace(ch) || ch == terminator) {
                return null;
            }
            int start = this.position;
            ch = this.advanceChar();
            while (ch != -1 && ch != terminator && !this.isWhitespace(ch)) {
                ch = this.advanceChar();
            }
            return this.input.substring(start, this.position);
        }

        public String nextFunction() {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            int ch = this.input.charAt(this.position);
            while (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
                ch = this.advanceChar();
            }
            int end = this.position;
            while (this.isWhitespace(ch)) {
                ch = this.advanceChar();
            }
            if (ch == 40) {
                ++this.position;
                return this.input.substring(start, end);
            }
            this.position = start;
            return null;
        }

        private int scanForFloat() {
            if (this.empty()) {
                return this.position;
            }
            int lastValidPos = this.position;
            int start = this.position;
            int ch = this.input.charAt(this.position);
            if (ch == 45 || ch == 43) {
                ch = this.advanceChar();
            }
            if (Character.isDigit(ch)) {
                lastValidPos = this.position + 1;
                ch = this.advanceChar();
                while (Character.isDigit(ch)) {
                    lastValidPos = this.position + 1;
                    ch = this.advanceChar();
                }
            }
            if (ch == 46) {
                lastValidPos = this.position + 1;
                ch = this.advanceChar();
                while (Character.isDigit(ch)) {
                    lastValidPos = this.position + 1;
                    ch = this.advanceChar();
                }
            }
            if (ch == 101 || ch == 69) {
                ch = this.advanceChar();
                if (ch == 45 || ch == 43) {
                    ch = this.advanceChar();
                }
                if (Character.isDigit(ch)) {
                    lastValidPos = this.position + 1;
                    ch = this.advanceChar();
                    while (Character.isDigit(ch)) {
                        lastValidPos = this.position + 1;
                        ch = this.advanceChar();
                    }
                }
            }
            this.position = start;
            return lastValidPos;
        }

        private int scanForInteger() {
            if (this.empty()) {
                return this.position;
            }
            int lastValidPos = this.position;
            int start = this.position;
            int ch = this.input.charAt(this.position);
            if (ch == 45 || ch == 43) {
                ch = this.advanceChar();
            }
            if (Character.isDigit(ch)) {
                lastValidPos = this.position + 1;
                ch = this.advanceChar();
                while (Character.isDigit(ch)) {
                    lastValidPos = this.position + 1;
                    ch = this.advanceChar();
                }
            }
            this.position = start;
            return lastValidPos;
        }

        public String ahead() {
            int start = this.position;
            while (!this.empty() && !this.isWhitespace(this.input.charAt(this.position))) {
                ++this.position;
            }
            String str = this.input.substring(start, this.position);
            this.position = start;
            return str;
        }

        public SVG.Unit nextUnit() {
            if (this.empty()) {
                return null;
            }
            char ch = this.input.charAt(this.position);
            if (ch == '%') {
                ++this.position;
                return SVG.Unit.percent;
            }
            if (this.position > this.input.length() - 2) {
                return null;
            }
            try {
                SVG.Unit result = SVG.Unit.valueOf(this.input.substring(this.position, this.position + 2).toLowerCase(Locale.US));
                this.position += 2;
                return result;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public boolean hasLetter() {
            if (this.position == this.input.length()) {
                return false;
            }
            char ch = this.input.charAt(this.position);
            return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
        }

        public String nextQuotedString() {
            int ch;
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            int endQuote = ch = this.input.charAt(this.position);
            if (ch != 39 && ch != 34) {
                return null;
            }
            ch = this.advanceChar();
            while (ch != -1 && ch != endQuote) {
                ch = this.advanceChar();
            }
            if (ch == -1) {
                this.position = start;
                return null;
            }
            ++this.position;
            return this.input.substring(start + 1, this.position - 1);
        }

        public String restOfText() {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            this.position = this.input.length();
            return this.input.substring(start);
        }
    }
}

