/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.xml.NodeListImpl;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.expr.ObjectExpr;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FromAttributes;
import com.caucho.xpath.pattern.FromContext;
import com.caucho.xpath.pattern.FromSelf;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.NodePattern;
import com.caucho.xpath.pattern.NodeTypePattern;
import org.w3c.dom.Node;

public class NodeSetExpr
extends Expr {
    private AbstractPattern _pattern;

    NodeSetExpr(AbstractPattern pattern) {
        this._pattern = pattern;
    }

    public static Expr create(AbstractPattern pattern) {
        if (pattern instanceof NodeTypePattern && pattern.getParent() instanceof FromSelf && pattern.toString().equals(".")) {
            return new ObjectExpr(59, ".");
        }
        if (pattern instanceof FromContext && ((FromContext)pattern).getCount() == 0 && pattern.getParent() == null) {
            return new ObjectExpr(59, ".");
        }
        if (pattern instanceof NodePattern && pattern.getParent() instanceof FromAttributes && pattern.getParent().getParent() instanceof FromContext && ((FromContext)pattern.getParent().getParent()).getCount() == 0) {
            return new ObjectExpr(61, ((NodePattern)pattern).getNodeName());
        }
        return new NodeSetExpr(pattern);
    }

    public AbstractPattern getPattern() {
        return this._pattern;
    }

    @Override
    public boolean isNodeSet() {
        return true;
    }

    @Override
    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        Node value = this._pattern.findAny(node, env);
        if (value == null) {
            return Double.NaN;
        }
        String string = XmlUtil.textValue(value);
        return NodeSetExpr.stringToNumber(string);
    }

    @Override
    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        return this._pattern.findAny(node, env) != null;
    }

    @Override
    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        Node value = this._pattern.findAny(node, env);
        if (value == null) {
            return "";
        }
        return XmlUtil.textValue(value);
    }

    @Override
    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        NodeListImpl list = new NodeListImpl();
        NodeIterator iter = this._pattern.select(node, env);
        Node value = null;
        while ((value = iter.nextNode()) != null) {
            list.add(value);
        }
        return list;
    }

    @Override
    public NodeIterator evalNodeSet(Node node, ExprEnvironment env) throws XPathException {
        return this._pattern.select(node, env);
    }

    @Override
    protected AbstractPattern toNodeList() {
        return this._pattern;
    }

    public boolean equals(Object b) {
        if (!(b instanceof NodeSetExpr)) {
            return false;
        }
        return this._pattern.equals(((NodeSetExpr)b)._pattern);
    }

    public String toString() {
        return this._pattern.toString();
    }
}

