/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ClasspathPath;
import com.caucho.vfs.ConstPath;
import com.caucho.vfs.DatastorePath;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.HttpPath;
import com.caucho.vfs.HttpsPath;
import com.caucho.vfs.JarScheme;
import com.caucho.vfs.JndiPath;
import com.caucho.vfs.JniFilePath;
import com.caucho.vfs.MemoryScheme;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.SchemeMap;
import com.caucho.vfs.SpyScheme;
import com.caucho.vfs.StderrStream;
import com.caucho.vfs.StdoutStream;
import com.caucho.vfs.StringReader;
import com.caucho.vfs.StringWriter;
import com.caucho.vfs.TcpPath;
import com.caucho.vfs.TcpsPath;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Vfs {
    private static final EnvironmentLocal<Path> ENV_PWD = new EnvironmentLocal("caucho.vfs.pwd");
    private static final SchemeMap DEFAULT_SCHEME_MAP;
    private static final EnvironmentLocal<SchemeMap> _localSchemeMap;
    static FilesystemPath PWD;
    private static AtomicBoolean _isInitJNI;

    private Vfs() {
    }

    public static Path lookup(String url) {
        Path pwd = Vfs.getPwd();
        if (!url.startsWith("/")) {
            return pwd.lookup(url, null);
        }
        return PWD.lookup(url, null);
    }

    public static FilesystemPath getGlobalPwd() {
        return PWD;
    }

    public static Path getPwd() {
        Path pwd = ENV_PWD.get();
        if (pwd == null) {
            if (PWD == null) {
                PWD = new FilePath(null);
            }
            pwd = PWD;
            ENV_PWD.setGlobal(pwd);
        }
        return pwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemeMap getLocalScheme() {
        EnvironmentLocal<SchemeMap> environmentLocal = _localSchemeMap;
        synchronized (environmentLocal) {
            SchemeMap map = _localSchemeMap.getLevel();
            if (map == null) {
                map = _localSchemeMap.get().copy();
                if (map == null) {
                    map = DEFAULT_SCHEME_MAP.copy();
                }
                _localSchemeMap.set(map);
            }
            return map;
        }
    }

    public static SchemeMap getDefaultScheme() {
        return DEFAULT_SCHEME_MAP;
    }

    public static Path getPwd(ClassLoader loader) {
        return ENV_PWD.get(loader);
    }

    public static void setPwd(Path pwd) {
        Vfs.setPwd(pwd, Thread.currentThread().getContextClassLoader());
    }

    public static void setPwd(Path pwd, ClassLoader loader) {
        ENV_PWD.set(pwd, loader);
    }

    public static Path lookup() {
        return Vfs.getPwd();
    }

    public static Path lookup(String url, Map<String, Object> attr) {
        return Vfs.getPwd().lookup(url, attr);
    }

    public static Path lookupNative(String url) {
        return Vfs.getPwd().lookupNative(url, null);
    }

    public static Path lookup(URL url) {
        return Vfs.getPwd().lookup(url);
    }

    public static Path lookupNative(String url, Map<String, Object> attr) {
        return Vfs.getPwd().lookupNative(url, attr);
    }

    public static ReadWritePair openReadWrite(InputStream is, OutputStream os) {
        VfsStream s = new VfsStream(is, os);
        WriteStream writeStream = new WriteStream(s);
        ReadStream readStream = new ReadStream(s, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public static ReadStream openRead(InputStream is) {
        if (is instanceof ReadStream) {
            return (ReadStream)is;
        }
        VfsStream s = new VfsStream(is, null);
        return new ReadStream(s);
    }

    public static ReadStream openRead(InputStream is, WriteStream ws) {
        VfsStream s = new VfsStream(is, null);
        return new ReadStream(s, ws);
    }

    public static ReadStream openRead(Reader reader) {
        if (reader instanceof ReadStream.StreamReader) {
            return ((ReadStream.StreamReader)reader).getStream();
        }
        ReaderWriterStream s = new ReaderWriterStream(reader, null);
        ReadStream is = new ReadStream(s);
        try {
            is.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is;
    }

    public static ReadStream openRead(String path) throws IOException {
        return Vfs.lookup(path).openRead();
    }

    public static ReadStream openString(String string) {
        return StringReader.open(string);
    }

    public static WriteStream openWrite(OutputStream os) {
        if (os instanceof WriteStream) {
            return (WriteStream)os;
        }
        VfsStream s = new VfsStream(null, os);
        return new WriteStream(s);
    }

    public static WriteStream openWrite(Writer writer) {
        ReaderWriterStream s = new ReaderWriterStream(null, writer);
        WriteStream os = new WriteStream(s);
        try {
            os.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return os;
    }

    public static WriteStream openWrite(CharBuffer cb) {
        StringWriter s = new StringWriter(cb);
        WriteStream os = new WriteStream(s);
        try {
            os.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return os;
    }

    public static WriteStream openWrite(String path) throws IOException {
        return Vfs.lookup(path).openWrite();
    }

    public static WriteStream openAppend(String path) throws IOException {
        return Vfs.lookup(path).openAppend();
    }

    public static String decode(String uri) {
        StringBuilder sb = new StringBuilder();
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char ch = uri.charAt(i);
            if (ch != '%' || len <= i + 2) {
                sb.append(ch);
                continue;
            }
            char d1 = uri.charAt(i + 1);
            char d2 = uri.charAt(i + 2);
            int v = 0;
            if ('0' <= d1 && d1 <= '9') {
                v = 16 * v + d1 - 48;
            } else if ('a' <= d1 && d1 <= 'f') {
                v = 16 * v + d1 - 97 + 10;
            } else if ('A' <= d1 && d1 <= 'F') {
                v = 16 * v + d1 - 65 + 10;
            } else {
                sb.append('%');
                continue;
            }
            if ('0' <= d2 && d2 <= '9') {
                v = 16 * v + d2 - 48;
            } else if ('a' <= d2 && d2 <= 'f') {
                v = 16 * v + d2 - 97 + 10;
            } else if ('A' <= d2 && d2 <= 'F') {
                v = 16 * v + d2 - 65 + 10;
            } else {
                sb.append('%');
                continue;
            }
            sb.append((char)v);
            i += 2;
        }
        return sb.toString();
    }

    public static void initJNI() {
        if (_isInitJNI.getAndSet(true)) {
            return;
        }
        FilesystemPath jniFilePath = JniFilePath.create();
        if (jniFilePath != null) {
            DEFAULT_SCHEME_MAP.put("file", jniFilePath);
            SchemeMap localMap = _localSchemeMap.get();
            if (localMap != null) {
                localMap.put("file", jniFilePath);
            }
            if ((localMap = _localSchemeMap.get(ClassLoader.getSystemClassLoader())) != null) {
                localMap.put("file", jniFilePath);
            }
            PWD = jniFilePath;
            Vfs.setPwd(jniFilePath);
        }
    }

    static {
        _localSchemeMap = new EnvironmentLocal();
        _isInitJNI = new AtomicBoolean();
        DEFAULT_SCHEME_MAP = new SchemeMap();
        Path.setDefaultSchemeMap(DEFAULT_SCHEME_MAP);
        FilePath pwd = new FilePath(null);
        PWD = pwd;
        Vfs.setPwd(pwd);
        ENV_PWD.setGlobal(pwd);
        ENV_PWD.set(pwd);
        _localSchemeMap.setGlobal(DEFAULT_SCHEME_MAP);
        DEFAULT_SCHEME_MAP.put("file", pwd);
        DEFAULT_SCHEME_MAP.put("memory", new MemoryScheme());
        DEFAULT_SCHEME_MAP.put("jar", new JarScheme(null));
        DEFAULT_SCHEME_MAP.put("classpath", new ClasspathPath(null, "", ""));
        DEFAULT_SCHEME_MAP.put("http", new HttpPath("127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("https", new HttpsPath("127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("tcp", new TcpPath(null, null, null, "127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("tcps", new TcpsPath(null, null, null, "127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("merge", new MergePath());
        StdoutStream stdout = StdoutStream.create();
        StderrStream stderr = StderrStream.create();
        DEFAULT_SCHEME_MAP.put("stdout", stdout.getPath());
        DEFAULT_SCHEME_MAP.put("stderr", stderr.getPath());
        VfsStream nullStream = new VfsStream(null, null);
        DEFAULT_SCHEME_MAP.put("null", new ConstPath(null, nullStream));
        DEFAULT_SCHEME_MAP.put("jndi", new JndiPath());
        DEFAULT_SCHEME_MAP.put("datastore", new DatastorePath("/"));
        DEFAULT_SCHEME_MAP.put("spy", new SpyScheme());
    }
}

