/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.QSocketWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QServerSocketWrapper
extends QServerSocket {
    private static final Logger log = Logger.getLogger(QServerSocketWrapper.class.getName());
    private ServerSocket _ss;
    private boolean _isTcpNoDelay = true;
    private boolean _isTcpKeepalive;
    private int _connectionSocketTimeout = 65000;

    public QServerSocketWrapper() {
    }

    public QServerSocketWrapper(ServerSocket ss) {
        this.init(ss);
    }

    public void init(ServerSocket ss) {
        this._ss = ss;
    }

    @Override
    public void setTcpNoDelay(boolean delay) {
        this._isTcpNoDelay = delay;
    }

    @Override
    public boolean isTcpNoDelay() {
        return this._isTcpNoDelay;
    }

    @Override
    public void setTcpKeepalive(boolean isEnable) {
        this._isTcpKeepalive = isEnable;
    }

    @Override
    public boolean isTcpKeepalive() {
        return this._isTcpKeepalive;
    }

    @Override
    public void setConnectionSocketTimeout(int socketTimeout) {
        this._connectionSocketTimeout = socketTimeout;
    }

    @Override
    public boolean accept(QSocket qSocket) throws IOException {
        QSocketWrapper s = (QSocketWrapper)qSocket;
        Socket socket = this._ss.accept();
        if (socket == null) {
            return false;
        }
        s.init(socket);
        if (this._connectionSocketTimeout > 0) {
            socket.setSoTimeout(this._connectionSocketTimeout);
        }
        return true;
    }

    @Override
    public QSocket createSocket() throws IOException {
        return new QSocketWrapper();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._ss.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this._ss.getLocalPort();
    }

    @Override
    public Selector getSelector() {
        try {
            ServerSocketChannel channel = this._ss.getChannel();
            if (channel == null) {
                return null;
            }
            SelectorProvider provider = channel.provider();
            if (provider != null) {
                return provider.openSelector();
            }
            return null;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        ServerSocket ss;
        this._ss = ss = this._ss;
        if (ss != null) {
            try {
                ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        return "ServerSocketWrapper[" + this.getLocalAddress() + ":" + this.getLocalPort() + "]";
    }
}

