/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.L10N;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QServerSocketWrapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QJniServerSocket {
    private static final L10N L = new L10N(QJniServerSocket.class);
    private static final Logger log = Logger.getLogger(QJniServerSocket.class.getName());

    private QJniServerSocket() {
    }

    public static QServerSocket create(int port, int listenBacklog) throws IOException {
        return QJniServerSocket.create(null, port, listenBacklog, true);
    }

    public static QServerSocket create(InetAddress host, int port, int listenBacklog) throws IOException {
        return QJniServerSocket.create(host, port, listenBacklog, true);
    }

    public static QServerSocket create(InetAddress host, int port, int listenBacklog, boolean isEnableJni) throws IOException {
        if (isEnableJni) {
            try {
                QServerSocket ss = QJniServerSocket.createJNI(host, port);
                if (ss != null) {
                    return ss;
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        for (int i = 0; i < 10; ++i) {
            try {
                ServerSocket ss = new ServerSocket(port, listenBacklog, host);
                return new QServerSocketWrapper(ss);
            }
            catch (BindException bindException) {
                try {
                    Thread.sleep(1L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                continue;
            }
        }
        try {
            ServerSocket ss = new ServerSocket(port, listenBacklog, host);
            return new QServerSocketWrapper(ss);
        }
        catch (BindException e) {
            if (host != null) {
                throw new BindException(L.l("{0}\nCan't bind to {1}:{2}.\nCheck for another server listening to that port.", (Object)e.getMessage(), (Object)host, (Object)String.valueOf(port)));
            }
            throw new BindException(L.l("{0}\nCan't bind to *:{1}.\nCheck for another server listening to that port.", (Object)e.getMessage(), (Object)String.valueOf(port)));
        }
    }

    public static QServerSocket createJNI(InetAddress host, int port) throws IOException {
        try {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            Class<?> cl = Class.forName("com.caucho.vfs.JniServerSocketImpl", false, loader);
            Method method = cl.getMethod("create", String.class, Integer.TYPE);
            String hostAddress = host != null ? host.getHostAddress() : null;
            try {
                return (QServerSocket)method.invoke(null, hostAddress, port);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            log.fine(e.toString());
            throw new IOException(L.l("JNI Socket support requires Resin Professional."), e);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            throw new IOException(L.l("JNI Socket support requires Resin Professional."), e);
        }
    }

    public static QServerSocket openJNI(int fd, int port) throws IOException {
        try {
            Class<?> cl = Class.forName("com.caucho.vfs.JniServerSocketImpl");
            Method method = cl.getMethod("open", Integer.TYPE, Integer.TYPE);
            try {
                return (QServerSocket)method.invoke(null, fd, port);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            log.fine(e.toString());
            throw new IOException(L.l("JNI Socket support requires Resin Professional."));
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            throw new IOException(L.l("JNI Socket support requires Resin Professional."));
        }
    }
}

