/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Utf8 {
    public static void write(OutputStream os, char ch) throws IOException {
        if (ch < '\u0080') {
            os.write(ch);
        } else if (ch < '\u0800') {
            os.write(192 + (ch >> 6));
            os.write(128 + (ch & 0x3F));
        } else {
            os.write(224 + (ch >> 12));
            os.write(128 + (ch >> 6 & 0x3F));
            os.write(128 + (ch & 0x3F));
        }
    }

    public static void write(CharBuffer cb, char ch) {
        if (ch < '\u0080') {
            cb.append(ch);
        } else if (ch < '\u0800') {
            cb.append((char)(192 + (ch >> 6)));
            cb.append((char)(128 + (ch & 0x3F)));
        } else {
            cb.append((char)(224 + (ch >> 12)));
            cb.append((char)(128 + (ch >> 6 & 0x3F)));
            cb.append((char)(128 + (ch & 0x3F)));
        }
    }

    public static void write(OutputStream os, String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            Utf8.write(os, s.charAt(i));
        }
    }

    public static int read(InputStream is) throws IOException {
        int ch1 = is.read();
        return Utf8.read(is, ch1);
    }

    public static int read(InputStream is, int ch1) throws IOException {
        if (ch1 < 128) {
            return ch1;
        }
        if ((ch1 & 0xE0) == 192) {
            int ch2 = is.read();
            if (ch2 < 0) {
                return -1;
            }
            if ((ch2 & 0x80) != 128) {
                return 65023;
            }
            return (ch1 & 0x1F) << 6 | ch2 & 0x3F;
        }
        if ((ch1 & 0xF0) == 224) {
            int ch2 = is.read();
            int ch3 = is.read();
            if (ch2 < 0) {
                return -1;
            }
            if ((ch2 & 0x80) != 128) {
                return 65023;
            }
            if ((ch3 & 0x80) != 128) {
                return 65023;
            }
            return (ch1 & 0xF) << 12 | (ch2 & 0x3F) << 6 | (ch3 & 0x3F) << 6;
        }
        if (ch1 == 255) {
            return 65535;
        }
        return 65023;
    }
}

