/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class DoubleArray {
    double[] data = new double[16];
    int size = 0;

    public void clear() {
        this.size = 0;
    }

    private void expand(int max) {
        while (max > this.data.length) {
            double[] next = new double[this.data.length * 2];
            for (int i = 0; i < this.data.length; ++i) {
                next[i] = this.data[i];
            }
            this.data = next;
        }
    }

    public int size() {
        return this.size;
    }

    public void append(double i) {
        this.expand(this.size + 1);
        this.data[this.size++] = i;
    }

    public void append(DoubleArray array) {
        this.expand(this.size + array.size);
        for (int i = 0; i < array.size; ++i) {
            this.data[this.size++] = array.data[i];
        }
    }

    public void insert(int i, double value) {
        this.expand(this.size + 1);
        System.arraycopy(this.data, i, this.data, i + 1, this.size - i);
        this.data[i] = value;
        ++this.size;
    }

    public double pop() {
        return this.data[--this.size];
    }

    public void setLength(int size) {
        this.expand(size);
        for (int i = this.size; i < size; ++i) {
            this.data[i] = 0.0;
        }
        this.size = size;
    }

    public double get(int i) {
        return this.data[i];
    }

    public double last() {
        return this.data[this.size - 1];
    }

    public void set(int i, double value) {
        if (i + 1 > this.size) {
            this.setLength(i + 1);
        }
        this.data[i] = value;
    }

    public boolean contains(double test) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != test) continue;
            return true;
        }
        return false;
    }

    public boolean isSubset(DoubleArray subset) {
        for (int i = 0; i < subset.size; ++i) {
            if (this.contains(subset.data[i])) continue;
            return false;
        }
        return true;
    }

    public void union(DoubleArray newArray) {
        for (int i = 0; i < newArray.size; ++i) {
            if (this.contains(newArray.data[i])) continue;
            this.append(newArray.data[i]);
        }
    }
}

