/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.ContextImpl;
import com.caucho.naming.EnvironmentModelRoot;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class InitialContextFactoryImpl
implements InitialContextFactory {
    private static EnvironmentLocal<AbstractModel> _rootModel = new EnvironmentLocal();

    public static AbstractModel getContextModel() {
        return _rootModel.get();
    }

    public static void setContextModel(AbstractModel model) {
        _rootModel.set(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractModel createRoot() {
        EnvironmentLocal<AbstractModel> environmentLocal = _rootModel;
        synchronized (environmentLocal) {
            AbstractModel model = _rootModel.getLevel();
            if (model == null) {
                EnvironmentModelRoot root = EnvironmentModelRoot.create();
                model = root.get("");
                _rootModel.set(model);
                try {
                    AbstractModel javaComp = model.createSubcontext("java:comp");
                    AbstractModel java = model.createSubcontext("java:");
                    java.bind("comp", javaComp);
                    AbstractModel env = javaComp.createSubcontext("env");
                    javaComp.bind("env", env);
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
            return model;
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        AbstractModel model = InitialContextFactoryImpl.createRoot();
        return new ContextImpl(model, env);
    }

    public static Context createInitialContext() {
        return new ContextImpl(InitialContextFactoryImpl.createRoot(), null);
    }
}

