/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make;

import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.env.thread.ThreadPool;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.Dependency;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class DependencyContainer
implements Dependency {
    private static Logger _log;
    private WeakReference<ClassLoader> _classLoaderRef;
    private ArrayList<Dependency> _dependencyList = new ArrayList();
    private volatile boolean _isModified;
    private boolean _isModifiedLog;
    private long _checkInterval = 2000L;
    private volatile long _checkExpiresTime = 0L;
    private final AtomicReference<DependencyCheckWorker> _checkWorkerRef = new AtomicReference();
    private final AtomicBoolean _isChecking = new AtomicBoolean();
    private boolean _isAsync = false;

    public DependencyContainer() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public DependencyContainer(ClassLoader loader) {
        this._classLoaderRef = new WeakReference<ClassLoader>(loader);
        this._checkInterval = DynamicClassLoader.getGlobalDependencyCheckInterval();
        while (loader != null) {
            if (loader instanceof DynamicClassLoader) {
                this._checkInterval = ((DynamicClassLoader)loader).getDependencyCheckInterval();
                break;
            }
            loader = loader.getParent();
        }
    }

    public boolean isAsync() {
        return this._isAsync;
    }

    public void setAsync(boolean isAsync) {
        this._isAsync = isAsync;
    }

    public DependencyContainer add(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't add self as a dependency.");
        }
        if (!this._dependencyList.contains(dependency)) {
            this._dependencyList.add(dependency);
        }
        return this;
    }

    public DependencyContainer addAll(DependencyContainer container) {
        for (Dependency depend : container._dependencyList) {
            this.add(depend);
        }
        return this;
    }

    public DependencyContainer addAll(ArrayList<Dependency> dependencyList) {
        for (Dependency depend : dependencyList) {
            this.add(depend);
        }
        return this;
    }

    public ArrayList<Dependency> getDependencies() {
        return this._dependencyList;
    }

    public DependencyContainer remove(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't remove self as a dependency.");
        }
        this._dependencyList.remove(dependency);
        return this;
    }

    public int size() {
        return this._dependencyList.size();
    }

    public void setCheckInterval(long checkInterval) {
        this._checkInterval = checkInterval < 0L || checkInterval > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : checkInterval;
        this._checkExpiresTime = 0L;
    }

    public long getCheckInterval() {
        return this._checkInterval;
    }

    public ClassLoader getClassLoader() {
        if (this._classLoaderRef != null) {
            return (ClassLoader)this._classLoaderRef.get();
        }
        return null;
    }

    public void setModified(boolean isModified) {
        this._isModified = isModified;
        this._checkExpiresTime = this._isModified ? 0x3FFFFFFFFFFFFFFFL : CurrentTime.getCurrentTime() + this._checkInterval;
        if (!isModified) {
            this._isModifiedLog = false;
        }
    }

    public void resetDependencyCheckInterval() {
        this._checkExpiresTime = 0L;
    }

    public void clearModified() {
        this.setModified(false);
    }

    @Override
    public boolean isModified() {
        return this.isModified(this.isAsync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified(boolean isAsync) {
        long now = CurrentTime.getCurrentTime();
        if (now < this._checkExpiresTime) {
            return this._isModified;
        }
        if (!this._isChecking.compareAndSet(false, true)) {
            return this._isModified;
        }
        this._checkExpiresTime = now + this._checkInterval;
        if (isAsync) {
            this.getWorker().wake();
        } else {
            try {
                this.checkImpl();
            }
            finally {
                this._isChecking.set(false);
            }
        }
        return this._isModified;
    }

    private DependencyCheckWorker getWorker() {
        DependencyCheckWorker worker = this._checkWorkerRef.get();
        if (worker != null) {
            return worker;
        }
        worker = new DependencyCheckWorker(this.getClassLoader());
        this._checkWorkerRef.compareAndSet(null, worker);
        return this._checkWorkerRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkImpl() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            ClassLoader loader = this.getClassLoader();
            if (loader != null) {
                thread.setContextClassLoader(loader);
            }
            for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
                Dependency dependency = this._dependencyList.get(i);
                if (!dependency.isModified()) continue;
                this.setModified(true);
                return;
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    public boolean logModified(Logger log) {
        if (this._isModifiedLog) {
            return true;
        }
        for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
            Dependency dependency = this._dependencyList.get(i);
            if (!dependency.logModified(log)) continue;
            this._isModifiedLog = true;
            return true;
        }
        return false;
    }

    public boolean isModifiedNow() {
        this._checkExpiresTime = 0L;
        return this.isModified(false);
    }

    private Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(DependencyContainer.class.getName());
        }
        return _log;
    }

    public String toString() {
        return "DependencyContainer" + this._dependencyList;
    }

    private class DependencyCheckWorker
    extends AbstractTaskWorker {
        private DependencyCheckWorker(ClassLoader loader) {
            super(loader, ThreadPool.getCurrent());
        }

        @Override
        public long runTask() {
            try {
                DependencyContainer.this.checkImpl();
            }
            finally {
                DependencyContainer.this._isChecking.set(false);
            }
            return 0L;
        }
    }
}

