/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CurrentTime;
import com.caucho.util.QDate;
import com.caucho.vfs.StderrStream;
import com.caucho.vfs.StdoutStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class EnvironmentStream
extends StreamImpl {
    private static final WriteStream _origSystemOut = Vfs.openWrite(System.out);
    private static final WriteStream _origSystemErr = Vfs.openWrite(System.err);
    private static PrintStream _systemOut;
    private static PrintStream _systemErr;
    private static EnvironmentStream _stdoutStream;
    private static EnvironmentStream _stderrStream;
    private EnvironmentLocal<OutputStream> _environmentStream;

    public EnvironmentStream(String envVariable, OutputStream defaultStream) {
        this._environmentStream = new EnvironmentLocal(envVariable);
        this._environmentStream.setGlobal(defaultStream);
    }

    public EnvironmentStream(OutputStream defaultStream) {
        this._environmentStream = new EnvironmentLocal();
        this._environmentStream.setGlobal(defaultStream);
    }

    public String getVariable() {
        return this._environmentStream.getVariable();
    }

    public OutputStream getGlobalStream() {
        return this._environmentStream.getGlobal();
    }

    public Object setGlobalStream(OutputStream defaultStream) {
        return this._environmentStream.setGlobal(defaultStream);
    }

    public OutputStream getStream() {
        return this._environmentStream.get();
    }

    public Object setStream(OutputStream os) {
        return this._environmentStream.set(os);
    }

    @Override
    public boolean canWrite() {
        OutputStream stream = this.getStream();
        return stream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        OutputStream stream = this.getStream();
        if (stream == null) {
            return;
        }
        OutputStream outputStream = stream;
        synchronized (outputStream) {
            stream.write(buf, offset, length);
            if (isEnd) {
                stream.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        OutputStream stream = this.getStream();
        if (stream == null) {
            return;
        }
        OutputStream outputStream = stream;
        synchronized (outputStream) {
            stream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        OutputStream stream = this.getStream();
        if (stream == null) {
            return;
        }
        OutputStream outputStream = stream;
        synchronized (outputStream) {
            stream.flush();
        }
    }

    public static void setStdout(OutputStream os) {
        WriteStream out;
        if (_stdoutStream == null) {
            PrintStream systemOut = System.out;
            _stdoutStream = new EnvironmentStream("caucho.stdout.stream", systemOut);
            WriteStream out2 = new WriteStream(_stdoutStream);
            out2.setDisableClose(true);
            _systemOut = new PrintStream(out2, true);
            System.setOut(_systemOut);
            if (os == systemOut) {
                return;
            }
        }
        if (os == _systemErr || os == _systemOut) {
            return;
        }
        if (os instanceof WriteStream && ((out = (WriteStream)os).getSource() == StdoutStream.create() || out.getSource() == StderrStream.create())) {
            return;
        }
        _stdoutStream.setStream(os);
    }

    public static EnvironmentStream getStdout() {
        return _stdoutStream;
    }

    public static WriteStream getOriginalSystemOut() {
        return _origSystemOut;
    }

    public static void setStderr(OutputStream os) {
        WriteStream out;
        if (_stderrStream == null) {
            PrintStream systemErr = System.err;
            _stderrStream = new EnvironmentStream("caucho.stderr.stream", systemErr);
            WriteStream err = new WriteStream(_stderrStream);
            err.setDisableClose(true);
            _systemErr = new PrintStream(err, true);
            System.setErr(_systemErr);
            if (os == systemErr) {
                return;
            }
        }
        if (os == _systemErr || os == _systemOut) {
            return;
        }
        if (os instanceof WriteStream && ((out = (WriteStream)os).getSource() == StdoutStream.create() || out.getSource() == StderrStream.create())) {
            return;
        }
        _stderrStream.setStream(os);
    }

    public static EnvironmentStream getStderr() {
        return _stderrStream;
    }

    public static WriteStream getOriginalSystemErr() {
        return _origSystemErr;
    }

    public static void logStderr(String msg, Throwable e) {
        try {
            long now = CurrentTime.getCurrentTime();
            msg = QDate.formatLocal(now, "[%Y-%m-%d %H:%M:%S] ") + msg;
            _origSystemErr.println(msg);
            e.printStackTrace(_origSystemErr.getPrintWriter());
            _origSystemErr.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void logStderr(String msg) {
        try {
            long now = CurrentTime.getCurrentTime();
            msg = QDate.formatLocal(now, "[%Y-%m-%d %H:%M:%S] ") + msg;
            _origSystemErr.println(msg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        _origSystemOut.setFlushOnNewline(true);
        _origSystemErr.setFlushOnNewline(true);
    }
}

