/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.ivy;

import com.caucho.config.program.ConfigProgram;
import com.caucho.loader.ivy.IvyCache;
import com.caucho.loader.ivy.IvyMergeDependency;
import com.caucho.loader.ivy.IvyRevision;
import com.caucho.vfs.Path;

public class IvyDependency {
    private String _artifact;
    private String _org;
    private String _name;
    private String _rev = "latest";
    private String[] _versions;

    public void setArtifact(String artifact) {
        this._artifact = artifact;
    }

    public String getArtifact() {
        return this._artifact;
    }

    public void setOrg(String org) {
        this._org = org;
    }

    public String getOrg() {
        return this._org;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setRev(String rev) {
        this._rev = rev;
    }

    public String getRev() {
        return this._rev;
    }

    public void setVersions(String[] versions) {
        this._versions = versions;
    }

    public void addBuilderProgram(ConfigProgram program) {
    }

    public boolean isMatch(IvyDependency dep) {
        return this._org.equals(dep._org) && this._name.equals(dep._name);
    }

    public Path resolve(IvyCache cache) {
        Path path = cache.resolve(this);
        if (path != null) {
            return path;
        }
        if (this._versions == null) {
            return null;
        }
        Path bestPath = null;
        String bestVersion = null;
        for (String version : this._versions) {
            path = cache.resolve(this, version);
            if (path == null) continue;
            if (bestPath == null) {
                bestPath = path;
                bestVersion = version;
                continue;
            }
            if (new IvyRevision(bestVersion).compareTo(new IvyRevision(version)) >= 0) continue;
            bestPath = path;
            bestVersion = version;
        }
        return bestPath;
    }

    public IvyDependency merge(IvyDependency dep) {
        if (this.equals(dep)) {
            return this;
        }
        if (!this.isMatch(dep)) {
            return null;
        }
        return new IvyMergeDependency(this, dep);
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 65521 + this._org.hashCode();
        hash = hash * 65521 + this._name.hashCode();
        hash = hash * 65521 + this._rev.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IvyDependency)) {
            return false;
        }
        IvyDependency dep = (IvyDependency)o;
        return this._org.equals(dep._org) && this._name.equals(dep._name) && this._rev.equals(dep._rev);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._org + "," + this._name + "," + this._rev + "]";
    }
}

