/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.jmx.Jmx;
import com.caucho.lifecycle.StartLifecycleException;
import com.caucho.loader.AddLoaderListener;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.CloseListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentApply;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentProperties;
import com.caucho.loader.RootDynamicClassLoader;
import com.caucho.loader.StartListener;
import com.caucho.loader.WeakCloseListener;
import com.caucho.log.EnvironmentStream;
import com.caucho.log.LogManagerImpl;
import com.caucho.naming.Jndi;
import com.caucho.server.util.CauchoSystem;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.lang.management.ManagementFactory;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class Environment {
    private static boolean _isStaticInit;
    private static Logger _log;
    private static ArrayList<EnvironmentListener> _globalEnvironmentListeners;
    private static ArrayList<ClassLoaderListener> _globalLoaderListeners;
    private static boolean _isInitComplete;
    private static ClassLoader _systemClassLoader;

    public static EnvironmentClassLoader getEnvironmentClassLoader() {
        ClassLoader loader;
        for (loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof EnvironmentClassLoader)) continue;
            return (EnvironmentClassLoader)loader;
        }
        loader = Environment.getSystemClassLoader();
        if (loader instanceof EnvironmentClassLoader) {
            return (EnvironmentClassLoader)loader;
        }
        return null;
    }

    public static EnvironmentClassLoader getEnvironmentClassLoader(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                return (EnvironmentClassLoader)loader;
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static void addEnvironmentListener(EnvironmentListener listener) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.addEnvironmentListener(listener, loader);
    }

    public static void addEnvironmentListener(EnvironmentListener listener, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).addListener(listener);
                return;
            }
            loader = loader.getParent();
        }
        _globalEnvironmentListeners.add(listener);
    }

    public static void removeEnvironmentListener(EnvironmentListener listener) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.removeEnvironmentListener(listener, loader);
    }

    public static void removeEnvironmentListener(EnvironmentListener listener, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).removeListener(listener);
                return;
            }
            loader = loader.getParent();
        }
        _globalEnvironmentListeners.remove(listener);
    }

    public static void addChildEnvironmentListener(EnvironmentListener listener) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.addChildEnvironmentListener(listener, loader);
    }

    public static void addChildEnvironmentListener(EnvironmentListener listener, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).addChildListener(listener);
                return;
            }
            loader = loader.getParent();
        }
    }

    public static void addChildLoaderListener(AddLoaderListener listener) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.addChildLoaderListener(listener, loader);
    }

    public static void addChildLoaderListener(AddLoaderListener listener, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).addLoaderListener(listener);
                return;
            }
            loader = loader.getParent();
        }
    }

    public static void addClassLoaderListener(ClassLoaderListener listener) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.addClassLoaderListener(listener, loader);
    }

    public static void addClassLoaderListener(ClassLoaderListener listener, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).addListener(listener);
                return;
            }
            loader = loader.getParent();
        }
        _globalLoaderListeners.add(listener);
    }

    public static void addStartListener(Object obj) {
        Environment.addEnvironmentListener(new StartListener(obj));
    }

    public static void addCloseListener(Object obj) {
        Environment.addClassLoaderListener(new CloseListener(obj));
    }

    public static void addCloseListener(Object obj, ClassLoader loader) {
        Environment.addClassLoaderListener(new CloseListener(obj), loader);
    }

    public static void addWeakCloseListener(Object obj) {
        Environment.addClassLoaderListener(new WeakCloseListener(obj));
    }

    public static void addWeakCloseListener(Object obj, ClassLoader loader) {
        Environment.addClassLoaderListener(new WeakCloseListener(obj), loader);
    }

    public static void init() {
        Environment.initializeEnvironment();
        Environment.init(Thread.currentThread().getContextClassLoader());
    }

    public static void init(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).init();
                return;
            }
            loader = loader.getParent();
        }
        for (int i = 0; i < _globalLoaderListeners.size(); ++i) {
            ClassLoaderListener listener = _globalLoaderListeners.get(i);
            listener.classLoaderInit(null);
        }
    }

    public static void start() throws StartLifecycleException {
        Environment.start(Thread.currentThread().getContextClassLoader());
    }

    public static void start(ClassLoader loader) throws StartLifecycleException {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).start();
                return;
            }
            loader = loader.getParent();
        }
        Environment.init(loader);
        for (int i = 0; i < _globalEnvironmentListeners.size(); ++i) {
            EnvironmentListener listener = _globalEnvironmentListeners.get(i);
            listener.environmentStart(null);
        }
    }

    public static void stop() {
        Environment.stop(Thread.currentThread().getContextClassLoader());
    }

    public static void stop(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).stop();
                return;
            }
            loader = loader.getParent();
        }
        ArrayList<EnvironmentListener> listeners = new ArrayList<EnvironmentListener>();
        listeners.addAll(_globalEnvironmentListeners);
        _globalEnvironmentListeners.clear();
        for (int i = 0; i < listeners.size(); ++i) {
            EnvironmentListener listener = (EnvironmentListener)listeners.get(i);
            listener.environmentStop(null);
        }
    }

    public static void addDependency(Dependency depend) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.addDependency(depend, loader);
    }

    public static void addDependency(Dependency depend, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).addDependency(depend);
                return;
            }
            loader = loader.getParent();
        }
    }

    public static DynamicClassLoader getDynamicClassLoader() {
        Thread thread = Thread.currentThread();
        return Environment.getDynamicClassLoader(thread.getContextClassLoader());
    }

    public static DynamicClassLoader getDynamicClassLoader(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof DynamicClassLoader) {
                return (DynamicClassLoader)loader;
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static void addDependency(Path path) {
        Environment.addDependency(new Depend(path));
    }

    public static void addDependency(Path path, ClassLoader loader) {
        Environment.addDependency(new Depend(path), loader);
    }

    public static Object getAttribute(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Environment.getAttribute(name, loader);
    }

    public static long getDependencyCheckInterval() {
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof DynamicClassLoader)) continue;
            return ((DynamicClassLoader)loader).getDependencyCheckInterval();
        }
        return DynamicClassLoader.getGlobalDependencyCheckInterval();
    }

    public static long getDependencyCheckInterval(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof DynamicClassLoader) {
                return ((DynamicClassLoader)loader).getDependencyCheckInterval();
            }
            loader = loader.getParent();
        }
        return DynamicClassLoader.getGlobalDependencyCheckInterval();
    }

    public static Object getAttribute(String name, ClassLoader loader) {
        while (loader != null) {
            Object value;
            if (loader instanceof EnvironmentClassLoader && (value = ((EnvironmentClassLoader)loader).getAttribute(name)) != null) {
                return value;
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static Object getLevelAttribute(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Environment.getLevelAttribute(name, loader);
    }

    public static Object getLevelAttribute(String name, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                return ((EnvironmentClassLoader)loader).getAttribute(name);
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static Object setAttribute(String name, Object value) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Environment.setAttribute(name, value, loader);
    }

    public static Object setAttribute(String name, Object value, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
                Object oldValue = envLoader.getAttribute(name);
                envLoader.setAttribute(name, value);
                return oldValue;
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static void addPermission(Permission perm) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.addPermission(perm, loader);
    }

    public static void addPermission(Permission perm, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
                envLoader.addPermission(perm);
            }
            loader = loader.getParent();
        }
    }

    public static Object getOwner() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Environment.getOwner(loader);
    }

    public static Object getOwner(ClassLoader loader) {
        while (loader != null) {
            EnvironmentClassLoader envLoader;
            EnvironmentBean owner;
            if (loader instanceof EnvironmentClassLoader && (owner = (envLoader = (EnvironmentClassLoader)loader).getOwner()) != null) {
                return owner;
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static void setConfigException(Throwable e) {
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof EnvironmentClassLoader)) continue;
            EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
            envLoader.setConfigException(e);
            return;
        }
    }

    public static Throwable getConfigException() {
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            EnvironmentClassLoader envLoader;
            if (!(loader instanceof EnvironmentClassLoader) || (envLoader = (EnvironmentClassLoader)loader).getConfigException() == null) continue;
            return envLoader.getConfigException();
        }
        return null;
    }

    public static String getEnvironmentName() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Environment.getEnvironmentName(loader);
    }

    public static String getEnvironmentName(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                String name = ((EnvironmentClassLoader)loader).getId();
                if (name != null) {
                    return name;
                }
                return "";
            }
            loader = loader.getParent();
        }
        return Thread.currentThread().getContextClassLoader().toString();
    }

    public static void applyVisibleModules(EnvironmentApply apply) {
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof EnvironmentClassLoader)) continue;
            EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
            envLoader.applyVisibleModules(apply);
            return;
        }
    }

    public static String getLocalClassPath() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Environment.getLocalClassPath(loader);
    }

    public static String getLocalClassPath(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                return ((EnvironmentClassLoader)loader).getLocalClassPath();
            }
            loader = loader.getParent();
        }
        return CauchoSystem.getClassPath();
    }

    public static void closeGlobal() {
        ArrayList<ClassLoaderListener> listeners = new ArrayList<ClassLoaderListener>();
        listeners.addAll(_globalLoaderListeners);
        _globalLoaderListeners.clear();
        for (int i = 0; i < listeners.size(); ++i) {
            ClassLoaderListener listener = (ClassLoaderListener)listeners.get(i);
            listener.classLoaderDestroy(null);
        }
    }

    public static boolean isLoggingInitialized() {
        String logManager = System.getProperty("java.util.logging.manager");
        return _isInitComplete && LogManagerImpl.class.getName().equals(logManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initializeEnvironment() {
        if (_isStaticInit) {
            return;
        }
        _isStaticInit = true;
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(systemLoader);
            if ("1.6.".compareTo(System.getProperty("java.runtime.version")) > 0) {
                throw new ConfigException("Resin requires JDK 1.6 or later");
            }
            EnvironmentStream.setStdout(System.out);
            EnvironmentStream.setStderr(System.err);
            try {
                Vfs.initJNI();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Properties props = System.getProperties();
            ClassLoader envClassLoader = EnvironmentClassLoader.class.getClassLoader();
            boolean isGlobalLoadable = false;
            try {
                Class<?> cl = Class.forName("com.caucho.naming.InitialContextFactoryImpl", false, systemLoader);
                isGlobalLoadable = cl != null;
            }
            catch (Exception e) {
                Environment.log().log(Level.FINER, e.toString(), e);
            }
            String namingPkgs = (String)props.get("java.naming.factory.url.pkgs");
            namingPkgs = namingPkgs == null ? "com.caucho.naming" : namingPkgs + ":com.caucho.naming";
            props.put("java.naming.factory.url.pkgs", namingPkgs);
            if (isGlobalLoadable) {
                if (props.get("java.naming.factory.initial") == null) {
                    props.put("java.naming.factory.initial", "com.caucho.naming.InitialContextFactoryImpl");
                }
                Environment.defaultProperty(props, "jdk.tls.ephemeralDHKeySize", "2048");
                Environment.defaultProperty(props, "jdk.tls.rejectClientInitiatedRenegotiation", "true");
                Environment.defaultProperty(props, "sun.security.ssl.allowUnsafeRenegotiation", "false");
                Environment.defaultProperty(props, "sun.security.ssl.allowLegacyHelloMessages", "false");
                EnvironmentProperties.enableEnvironmentSystemProperties(true);
                String oldBuilder = props.getProperty("javax.management.builder.initial");
                if (oldBuilder == null) {
                    oldBuilder = "com.caucho.jmx.MBeanServerBuilderImpl";
                    props.put("javax.management.builder.initial", oldBuilder);
                }
                ManagementFactory.getPlatformMBeanServer();
            }
            Jndi.bindDeep("java:comp/env/jmx/MBeanServer", Jmx.getGlobalMBeanServer());
            Jndi.bindDeep("java:comp/env/jmx/GlobalMBeanServer", Jmx.getGlobalMBeanServer());
            try {
                Class<?> cl = Class.forName("com.caucho.server.resin.EnvInit", false, systemLoader);
                cl.newInstance();
            }
            catch (Exception e) {
                Environment.log().log(Level.FINE, e.toString(), e);
            }
        }
        catch (NamingException e) {
            Environment.log().log(Level.FINE, e.toString(), e);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            _isInitComplete = true;
        }
    }

    private static void defaultProperty(Properties props, String key, String value) {
        if (props.get(key) == null) {
            props.setProperty(key, value);
        }
    }

    private static final Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(Environment.class.getName());
        }
        return _log;
    }

    private static ClassLoader getSystemClassLoader() {
        try {
            if (_systemClassLoader == null && _systemClassLoader == null && (_systemClassLoader = ClassLoader.getSystemClassLoader()) != null) {
                _systemClassLoader = RootDynamicClassLoader.getSystemRootClassLoader();
            }
        }
        catch (Exception e) {
            _systemClassLoader = Environment.class.getClassLoader();
        }
        return _systemClassLoader;
    }

    static {
        _globalEnvironmentListeners = new ArrayList();
        _globalLoaderListeners = new ArrayList();
    }
}

