/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.config.ConfigException;
import com.caucho.env.meter.AbstractMeter;
import com.caucho.jmx.Jmx;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class JmxDeltaMeter
extends AbstractMeter {
    private static final Logger log = Logger.getLogger(JmxDeltaMeter.class.getName());
    private MBeanServer _server;
    private ObjectName _objectName;
    private String _attribute;
    private boolean _isOptional;
    private double _lastValue;
    private double _value;

    public JmxDeltaMeter(String name, String objectName, String attribute, boolean isOptional) {
        super(name);
        try {
            this._objectName = new ObjectName(objectName);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        this._attribute = attribute;
        this._server = Jmx.getGlobalMBeanServer();
        this._isOptional = isOptional;
    }

    @Override
    public void sample() {
        try {
            double value;
            Object objValue = this._server.getAttribute(this._objectName, this._attribute);
            if (objValue == null) {
                this._value = 0.0;
                return;
            }
            double lastValue = this._lastValue;
            this._lastValue = value = ((Number)objValue).doubleValue();
            this._value = value - lastValue;
        }
        catch (Exception e) {
            if (this._isOptional && e instanceof InstanceNotFoundException) {
                log.log(Level.FINEST, e.toString(), e);
            } else {
                log.log(Level.FINE, e.toString(), e);
            }
            this._value = 0.0;
        }
    }

    @Override
    public double calculate() {
        return this._value;
    }
}

