/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.ActiveTimeSensor;
import com.caucho.util.CurrentTime;
import java.util.concurrent.atomic.AtomicLong;

public final class ActiveTimeMeter
extends AbstractMeter
implements ActiveTimeSensor {
    private final double _scale;
    private final Object _lock = new Object();
    private final AtomicLong _activeCount = new AtomicLong();
    private final AtomicLong _activeCountMax = new AtomicLong();
    private final AtomicLong _totalCount = new AtomicLong();
    private final AtomicLong _sum = new AtomicLong();
    private final AtomicLong _max = new AtomicLong();
    private double _sumSquare;
    private long _lastTotalCount;
    private long _lastAvgTotalCount;
    private long _lastAvgSum;
    private long _lastStdTotalCount;
    private double _lastStdSum;
    private double _avg;

    public ActiveTimeMeter(String name) {
        super(name);
        this._scale = 1.0;
    }

    @Override
    public final long start() {
        long max;
        long startTime = CurrentTime.getCurrentTime();
        long activeCount = this._activeCount.incrementAndGet();
        while ((max = this._activeCountMax.get()) < activeCount && !this._activeCountMax.compareAndSet(max, activeCount)) {
        }
        return startTime;
    }

    @Override
    public final long end(long startTime) {
        long max;
        this._totalCount.incrementAndGet();
        this._activeCount.decrementAndGet();
        long endTime = CurrentTime.getCurrentTime();
        long value = endTime - startTime;
        double sqValue = value * value;
        this._sum.addAndGet(value);
        this._sumSquare += sqValue;
        while ((max = this._max.get()) < value && !this._max.compareAndSet(max, value)) {
        }
        return value;
    }

    public AbstractMeter createActiveCount(String name) {
        return new ActiveCountProbe(name);
    }

    public AbstractMeter createActiveCountMax(String name) {
        return new ActiveCountMaxProbe(name);
    }

    public AbstractMeter createTotalCount(String name) {
        return new TotalCountProbe(name);
    }

    public AbstractMeter createMax(String name) {
        return new MaxProbe(name);
    }

    public AbstractMeter createSigma(String name, int n) {
        return new SigmaProbe(name, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sample() {
        Object object = this._lock;
        synchronized (object) {
            long count = this._totalCount.get();
            long lastCount = this._lastAvgTotalCount;
            this._lastAvgTotalCount = count;
            long sum = this._sum.get();
            double lastSum = this._lastAvgSum;
            this._lastAvgSum = sum;
            this._avg = count == lastCount ? 0.0 : this._scale * ((double)sum - lastSum) / (double)(count - lastCount);
        }
    }

    @Override
    public final double calculate() {
        return this._avg;
    }

    public final double sampleActiveCount() {
        return this._activeCount.get();
    }

    public final double sampleActiveCountMax() {
        return this._activeCountMax.getAndSet(this._activeCount.get());
    }

    public final double sampleTotalCount() {
        long count = this._totalCount.get();
        long lastCount = this._lastTotalCount;
        this._lastTotalCount = count;
        return count - lastCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double sampleSigma(int n) {
        Object object = this._lock;
        synchronized (object) {
            long count = this._totalCount.get();
            long lastCount = this._lastStdTotalCount;
            this._lastStdTotalCount = count;
            double sum = this._sum.get();
            double lastSum = this._lastStdSum;
            this._lastStdSum = sum;
            double sumSquare = this._sumSquare;
            this._sumSquare = 0.0;
            if (count == lastCount) {
                return 0.0;
            }
            double avg = (sum - lastSum) / (double)(count - lastCount);
            double part = (double)(count - lastCount) * sumSquare - sum * sum;
            if (part < 0.0) {
                part = 0.0;
            }
            double std = Math.sqrt(part) / (double)(count - lastCount);
            return this._scale * (avg + (double)n * std);
        }
    }

    public final double sampleMax() {
        long max = this._max.getAndSet(0L);
        return this._scale * (double)max;
    }

    class SigmaProbe
    extends AbstractMeter {
        private final int _n;
        private double _value;

        SigmaProbe(String name, int n) {
            super(name);
            this._n = n;
        }

        @Override
        public void sample() {
            this._value = ActiveTimeMeter.this.sampleSigma(this._n);
        }

        @Override
        public double calculate() {
            return this._value;
        }
    }

    class MaxProbe
    extends AbstractMeter {
        private double _value;

        MaxProbe(String name) {
            super(name);
        }

        @Override
        public void sample() {
            this._value = ActiveTimeMeter.this.sampleMax();
        }

        @Override
        public double calculate() {
            return this._value;
        }
    }

    class TotalCountProbe
    extends AbstractMeter {
        private double _value;

        TotalCountProbe(String name) {
            super(name);
        }

        @Override
        public void sample() {
            this._value = ActiveTimeMeter.this.sampleTotalCount();
        }

        @Override
        public double calculate() {
            return this._value;
        }
    }

    class ActiveCountMaxProbe
    extends AbstractMeter {
        private double _value;

        ActiveCountMaxProbe(String name) {
            super(name);
        }

        @Override
        public void sample() {
            this._value = ActiveTimeMeter.this.sampleActiveCountMax();
        }

        @Override
        public double calculate() {
            return this._value;
        }
    }

    class ActiveCountProbe
    extends AbstractMeter {
        private double _value;

        ActiveCountProbe(String name) {
            super(name);
        }

        @Override
        public void sample() {
            this._value = ActiveTimeMeter.this.sampleActiveCount();
        }

        @Override
        public double calculate() {
            return this._value;
        }
    }
}

