/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;

public class StackELResolver
extends ELResolver {
    public final ArrayList<ELResolver> _resolverStack = new ArrayList();

    public StackELResolver() {
    }

    public StackELResolver(ELResolver a, ELResolver b) {
        this.push(b);
        this.push(a);
    }

    public void push(ELResolver elResolver) {
        if (elResolver == null) {
            throw new NullPointerException();
        }
        this._resolverStack.add(elResolver);
    }

    public ELResolver pop() {
        if (this._resolverStack.size() > 0) {
            return this._resolverStack.remove(this._resolverStack.size() - 1);
        }
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext env, Object base) {
        int i = this._resolverStack.size() - 1;
        if (i >= 0) {
            ELResolver resolver = this._resolverStack.get(i);
            return this.getCommonPropertyType(env, base);
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext env, Object base) {
        ArrayList<FeatureDescriptor> descriptors = null;
        for (int i = this._resolverStack.size() - 1; i >= 0; --i) {
            ELResolver resolver = this._resolverStack.get(i);
            Iterator iter = resolver.getFeatureDescriptors(env, base);
            if (iter == null) continue;
            if (descriptors == null) {
                descriptors = new ArrayList<FeatureDescriptor>();
            }
            while (iter.hasNext()) {
                FeatureDescriptor desc = (FeatureDescriptor)iter.next();
                descriptors.add(desc);
            }
        }
        if (descriptors != null) {
            return descriptors.iterator();
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        for (int i = this._resolverStack.size() - 1; i >= 0; --i) {
            ELResolver resolver = this._resolverStack.get(i);
            Class type = resolver.getType(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return type;
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        for (int i = this._resolverStack.size() - 1; i >= 0; --i) {
            ELResolver resolver = this._resolverStack.get(i);
            Object value = resolver.getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return value;
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        for (int i = this._resolverStack.size() - 1; i >= 0; --i) {
            ELResolver resolver = this._resolverStack.get(i);
            boolean isReadOnly = resolver.isReadOnly(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return isReadOnly;
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        context.setPropertyResolved(false);
        for (int i = this._resolverStack.size() - 1; i >= 0; --i) {
            ELResolver resolver = this._resolverStack.get(i);
            resolver.setValue(context, base, property, value);
            if (!context.isPropertyResolved()) continue;
            return;
        }
    }
}

