/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ELException;

public class ModExpr
extends Expr {
    private final Expr _left;
    private final Expr _right;

    public ModExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    @Override
    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    @Override
    public Object getValue(ELContext env) throws ELException {
        Object aObj = this._left.getValue(env);
        Object bObj = this._right.getValue(env);
        if (aObj instanceof BigDecimal || ModExpr.isDouble(aObj) || bObj instanceof BigDecimal || ModExpr.isDouble(bObj)) {
            double a = ModExpr.toDouble(aObj, env);
            double b = ModExpr.toDouble(bObj, env);
            return new Double(a % b);
        }
        if (aObj instanceof BigInteger || bObj instanceof BigInteger) {
            BigInteger a = ModExpr.toBigInteger(aObj, env);
            BigInteger b = ModExpr.toBigInteger(bObj, env);
            return a.remainder(b);
        }
        if (aObj == null && bObj == null) {
            return new Long(0L);
        }
        long a = ModExpr.toLong(aObj, env);
        long b = ModExpr.toLong(bObj, env);
        return new Long(a % b);
    }

    @Override
    public long evalLong(ELContext env) throws ELException {
        long a = this._left.evalLong(env);
        long b = this._right.evalLong(env);
        return a % b;
    }

    @Override
    public double evalDouble(ELContext env) throws ELException {
        double a = this._left.evalDouble(env);
        double b = this._right.evalDouble(env);
        return a % b;
    }

    @Override
    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.ModExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ModExpr)) {
            return false;
        }
        ModExpr expr = (ModExpr)((Object)o);
        return this._left.equals((Object)expr._left) && this._right.equals((Object)expr._right);
    }

    @Override
    public String toString() {
        return "(" + (Object)((Object)this._left) + " + " + (Object)((Object)this._right) + ")";
    }
}

