/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.util;

import com.caucho.config.util.CacheKeyImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheInvocationParameter;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheKeyParam;
import javax.cache.annotation.CacheMethodDetails;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheRemoveEntry;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.CacheValue;

public class CacheKeyGeneratorImpl {
    private CacheKeyGenerator _keyGenerator;
    private CacheResolverFactory _resolverFactory;
    private CacheResolver _cacheResolver;
    private String _cacheName;
    private Method _method;
    private Set<Annotation> _annotations;
    private Annotation _cacheAnnotation;
    private Set<Annotation>[] _paramAnnotations;
    private int[] _keyParameters;
    private int _valueParam = -1;

    public CacheKeyGeneratorImpl(CacheKeyGenerator keyGenerator, CacheResolverFactory resolverFactory, String cacheName, Class<?> targetClass, String methodName, Class<?> ... parameterTypes) {
        int i;
        this._keyGenerator = keyGenerator;
        this._resolverFactory = resolverFactory;
        this._cacheName = cacheName;
        try {
            this._method = targetClass.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (this._method.isAnnotationPresent(CacheResult.class)) {
            this._cacheAnnotation = this._method.getAnnotation(CacheResult.class);
        } else if (this._method.isAnnotationPresent(CachePut.class)) {
            this._cacheAnnotation = this._method.getAnnotation(CachePut.class);
        } else if (this._method.isAnnotationPresent(CacheRemoveEntry.class)) {
            this._cacheAnnotation = this._method.getAnnotation(CacheRemoveEntry.class);
        } else if (this._method.isAnnotationPresent(CacheRemoveAll.class)) {
            this._cacheAnnotation = this._method.getAnnotation(CacheRemoveAll.class);
        }
        this._annotations = new HashSet<Annotation>();
        for (Annotation ann : this._method.getAnnotations()) {
            this._annotations.add(ann);
        }
        Class<?>[] paramTypes = this._method.getParameterTypes();
        Annotation[][] paramAnn = this._method.getParameterAnnotations();
        this._paramAnnotations = new Set[paramTypes.length];
        ArrayList<Integer> keyParameters = new ArrayList<Integer>();
        boolean isKeyParam = false;
        for (i = 0; i < paramTypes.length; ++i) {
            this._paramAnnotations[i] = new HashSet<Annotation>();
            if (paramAnn == null || paramAnn[i] == null) continue;
            for (Annotation ann : paramAnn[i]) {
                this._paramAnnotations[i].add(ann);
                if (!CacheValue.class.equals(ann.annotationType())) continue;
                this._valueParam = i;
            }
            if (this.isAnnotationPresent(CacheKeyParam.class, paramAnn[i])) {
                if (!isKeyParam) {
                    isKeyParam = true;
                    keyParameters.clear();
                }
                keyParameters.add(i);
                continue;
            }
            if (this.isAnnotationPresent(CacheValue.class, paramAnn[i]) || isKeyParam) continue;
            keyParameters.add(i);
        }
        if (keyParameters.size() < paramTypes.length) {
            this._keyParameters = new int[keyParameters.size()];
            for (i = 0; i < this._keyParameters.length; ++i) {
                this._keyParameters[i] = (Integer)keyParameters.get(i);
            }
        }
        if (this._resolverFactory != null) {
            this._cacheResolver = this._resolverFactory.getCacheResolver((CacheMethodDetails)new MethodDetails());
        }
    }

    private boolean isAnnotationPresent(Class<?> annType, Annotation[] annList) {
        if (annList == null) {
            return false;
        }
        for (Annotation ann : annList) {
            if (!annType.equals(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public CacheKey generateKey(Object target, Object ... args) {
        if (this._keyGenerator != null) {
            return this._keyGenerator.generateCacheKey((CacheKeyInvocationContext)new KeyContext(target, args));
        }
        return new CacheKeyImpl(args);
    }

    public Cache resolveCache(Cache cache, Object target, Object ... args) {
        if (this._cacheResolver != null) {
            InvocationContext cxt = new InvocationContext(target, args);
            Cache resolvedCache = this._cacheResolver.resolveCache((CacheInvocationContext)cxt);
            if (resolvedCache != null) {
                return resolvedCache;
            }
            return cache;
        }
        return cache;
    }

    class ParameterContext
    implements CacheInvocationParameter {
        private final int _pos;
        private final Object _value;

        ParameterContext(int pos, Object value) {
            this._pos = pos;
            this._value = value;
        }

        public Object getValue() {
            return this._value;
        }

        public int getParameterPosition() {
            return this._pos;
        }

        public Class<?> getRawType() {
            return CacheKeyGeneratorImpl.this._method.getParameterTypes()[this._pos];
        }

        public Set<Annotation> getAnnotations() {
            return CacheKeyGeneratorImpl.this._paramAnnotations[this._pos];
        }
    }

    class KeyContext
    extends InvocationContext
    implements CacheKeyInvocationContext {
        KeyContext(Object target, Object[] args) {
            super(target, args);
        }

        public CacheInvocationParameter[] getKeyParameters() {
            if (CacheKeyGeneratorImpl.this._keyParameters == null) {
                return this.getAllParameters();
            }
            CacheInvocationParameter[] parameters = this.getAllParameters();
            CacheInvocationParameter[] keyParameters = new CacheInvocationParameter[CacheKeyGeneratorImpl.this._keyParameters.length];
            for (int i = 0; i < keyParameters.length; ++i) {
                keyParameters[i] = parameters[CacheKeyGeneratorImpl.this._keyParameters[i]];
            }
            return keyParameters;
        }

        public CacheInvocationParameter getValueParameter() {
            if (CacheKeyGeneratorImpl.this._valueParam >= 0) {
                return this.getAllParameters()[CacheKeyGeneratorImpl.this._valueParam];
            }
            return null;
        }
    }

    class InvocationContext
    extends MethodDetails
    implements CacheInvocationContext {
        private Object _target;
        private CacheInvocationParameter[] _parameters;

        InvocationContext(Object target, Object[] args) {
            this._target = target;
            int length = args != null ? args.length : 0;
            this._parameters = new CacheInvocationParameter[length];
            for (int i = 0; i < length; ++i) {
                this._parameters[i] = new ParameterContext(i, args[i]);
            }
        }

        public CacheInvocationParameter[] getAllParameters() {
            return this._parameters;
        }

        public Object getTarget() {
            return this._target;
        }

        public Object unwrap(Class cl) {
            return null;
        }
    }

    class MethodDetails
    implements CacheMethodDetails {
        MethodDetails() {
        }

        public String getCacheName() {
            return CacheKeyGeneratorImpl.this._cacheName;
        }

        public Method getMethod() {
            return CacheKeyGeneratorImpl.this._method;
        }

        public Set getAnnotations() {
            return CacheKeyGeneratorImpl.this._annotations;
        }

        public Annotation getCacheAnnotation() {
            return CacheKeyGeneratorImpl.this._cacheAnnotation;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + CacheKeyGeneratorImpl.this._cacheName + "," + CacheKeyGeneratorImpl.this._method.getDeclaringClass().getSimpleName() + "." + CacheKeyGeneratorImpl.this._method.getName();
        }
    }
}

