/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ValueGenerator;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;

public abstract class WebBeanGenerator
extends ValueGenerator {
    private static final L10N L = new L10N(WebBeanGenerator.class);
    private InjectManager _beanManager = InjectManager.create();

    protected <T> T create(Class<T> type, Annotation ... bindings) {
        Set beans = this._beanManager.getBeans(type, bindings);
        Bean bean = this._beanManager.resolve(beans);
        if (bean == null) {
            throw new UnsatisfiedResolutionException(L.l("{0} cannot be instantiated by CDI\n  {1}", (Object)type, (Object)Arrays.toString(bindings)));
        }
        CreationalContext env = this._beanManager.createCreationalContext(bean);
        return (T)this._beanManager.getReference(bean, type, env);
    }
}

