/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.gen.InterceptorException;
import com.caucho.config.inject.AbstractInterceptorBean;
import com.caucho.config.inject.AnnotatedOverrideMap;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

public class InterceptorRuntimeBean<X>
extends AbstractInterceptorBean<X> {
    private Class<X> _type;
    private InterceptorRuntimeBean<X> _parent;
    private InterceptorRuntimeBean<X> _child;
    private Method _aroundInvoke;
    private Method _postConstruct;
    private boolean _isPostConstructOverride;
    private Method _preDestroy;
    private Method _prePassivate;
    private Method _postActivate;
    private HashSet<Annotation> _qualifiers = new HashSet();

    public InterceptorRuntimeBean(InterceptorRuntimeBean<X> child, Class<X> type) {
        this._type = type;
        this._child = child;
        this.introspectMethods(type);
        Class<X> parentClass = this.findParentInterceptor(type.getSuperclass());
        if (parentClass != null) {
            this._parent = new InterceptorRuntimeBean<X>(this, parentClass);
        }
    }

    public Bean<X> getBean() {
        if (this._child != null) {
            return this._child.getBean();
        }
        return this;
    }

    public Class<?> getType() {
        return this._type;
    }

    public InterceptorRuntimeBean<?> getParent() {
        return this._parent;
    }

    public boolean isAllowParent(InterceptionType type) {
        return this._parent != null;
    }

    public Set<Annotation> getQualifiers() {
        return this._qualifiers;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return null;
    }

    public String getName() {
        return null;
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public Set<Type> getTypes() {
        return null;
    }

    public Class<?> getBeanClass() {
        return this._type;
    }

    public X create(CreationalContext<X> cxt) {
        CreationalContextImpl env = (CreationalContextImpl)cxt;
        Object value = CreationalContextImpl.findAny(env, this.getBean().getBeanClass());
        if (value == null) {
            throw new NullPointerException(this.getBean() + "\n  " + env + "\n  " + this.toString());
        }
        return value;
    }

    public void destroy(X instance, CreationalContext<X> env) {
    }

    public Set<Annotation> getInterceptorBindings() {
        return this._qualifiers;
    }

    public boolean intercepts(InterceptionType type) {
        return this.getMethod(type) != null;
    }

    public Method getMethod(InterceptionType type) {
        switch (type) {
            case AROUND_INVOKE: {
                return this._aroundInvoke;
            }
            case POST_CONSTRUCT: {
                return this._postConstruct;
            }
            case PRE_DESTROY: {
                return this._preDestroy;
            }
            case PRE_PASSIVATE: {
                return this._prePassivate;
            }
            case POST_ACTIVATE: {
                return this._postActivate;
            }
        }
        return null;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return new HashSet<InjectionPoint>();
    }

    private void introspectMethods(Class<?> cl) {
        if (cl == null) {
            return;
        }
        Class<?> childClass = null;
        if (this._child != null) {
            childClass = this._child.getType();
        }
        for (Method method : cl.getDeclaredMethods()) {
            Method childMethod;
            if (Modifier.isStatic(method.getModifiers())) continue;
            AnnotatedMethod<?> annMethod = AnnotatedOverrideMap.getMethod(method);
            if (this.isAnnotationPresent(method, annMethod, AroundInvoke.class) && ((childMethod = AnnotatedTypeUtil.findDeclaredMethod(childClass, method)) == null || Modifier.isPrivate(childMethod.getModifiers()))) {
                this._aroundInvoke = method;
                method.setAccessible(true);
            }
            if (method.isAnnotationPresent(PostConstruct.class)) {
                childMethod = AnnotatedTypeUtil.findDeclaredMethod(childClass, method);
                if (this._child != null && this._child._isPostConstructOverride) {
                    this._isPostConstructOverride = true;
                } else if (childMethod == null) {
                    this._postConstruct = method;
                    method.setAccessible(true);
                } else if (Modifier.isPrivate(childMethod.getModifiers())) {
                    this._postConstruct = method;
                    method.setAccessible(true);
                } else if (this._child != null) {
                    this._isPostConstructOverride = true;
                }
            }
            if (method.isAnnotationPresent(PreDestroy.class) && (this._child == null || !this.isMethodMatch(this._child._preDestroy, method))) {
                this._preDestroy = method;
                method.setAccessible(true);
            }
            if (method.isAnnotationPresent(PrePassivate.class) && (this._child == null || !this.isMethodMatch(this._child._prePassivate, method))) {
                this._prePassivate = method;
                method.setAccessible(true);
            }
            if (!method.isAnnotationPresent(PostActivate.class) || this._child != null && this.isMethodMatch(this._child._postActivate, method)) continue;
            this._postActivate = method;
            method.setAccessible(true);
        }
    }

    private boolean isAnnotationPresent(Method method, AnnotatedMethod<?> annMethod, Class<? extends Annotation> annType) {
        if (method.isAnnotationPresent(annType)) {
            return true;
        }
        return annMethod != null && annMethod.isAnnotationPresent(annType);
    }

    private boolean isMethodMatch(Method a, Method b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!AnnotatedTypeUtil.isMatch(a, b)) {
            return false;
        }
        return !Modifier.isPrivate(a.getModifiers()) && !Modifier.isPrivate(b.getModifiers());
    }

    private Class<?> findParentInterceptor(Class<?> cl) {
        if (cl == null) {
            return null;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (method.isAnnotationPresent(AroundInvoke.class)) {
                return cl;
            }
            if (method.isAnnotationPresent(PostConstruct.class)) {
                return cl;
            }
            if (method.isAnnotationPresent(PreDestroy.class)) {
                return cl;
            }
            if (method.isAnnotationPresent(PrePassivate.class)) {
                return cl;
            }
            if (!method.isAnnotationPresent(PostActivate.class)) continue;
            return cl;
        }
        return this.findParentInterceptor(cl.getSuperclass());
    }

    public Object intercept(InterceptionType type, X instance, InvocationContext ctx) {
        try {
            switch (type) {
                case AROUND_INVOKE: {
                    if (this._aroundInvoke == null) {
                        throw new NullPointerException(this + " null AROUND_INVOKE");
                    }
                    if (instance == null) {
                        throw new NullPointerException(this + " NULL instance " + this._aroundInvoke);
                    }
                    return this._aroundInvoke.invoke(instance, ctx);
                }
                case POST_CONSTRUCT: {
                    return this._postConstruct.invoke(instance, ctx);
                }
                case PRE_DESTROY: {
                    return this._preDestroy.invoke(instance, ctx);
                }
                case PRE_PASSIVATE: {
                    return this._prePassivate.invoke(instance, ctx);
                }
                case POST_ACTIVATE: {
                    return this._postActivate.invoke(instance, ctx);
                }
            }
            throw new UnsupportedOperationException(this.toString());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new InterceptorException(e.getCause());
        }
        catch (Exception e) {
            throw new InterceptorException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        InterceptorRuntimeBean bean = (InterceptorRuntimeBean)o;
        if (!this._type.equals(bean._type)) {
            return false;
        }
        if (this._child == bean._child) {
            return true;
        }
        return this._child != null && this._child.equals(bean._child);
    }

    public int hashCode() {
        return this._type.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this._type.getSimpleName());
        sb.append("]");
        return sb.toString();
    }
}

