/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.bytecode.DecoratorAdapter;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Qualifier;
import javax.interceptor.Interceptor;

@Module
public class DecoratorBean<T>
implements Decorator<T> {
    private static final L10N L = new L10N(DecoratorBean.class);
    private Class<T> _selfType;
    private Class<T> _adapterType;
    private Bean<T> _bean;
    private InjectionPoint _delegateInjectionPoint;
    private Field _delegateField;
    private Method _delegateMethod;
    private Constructor<?> _delegateConstructor;
    private Set<Type> _typeSet;
    private HashSet<Annotation> _qualifiers = new HashSet();

    public DecoratorBean(InjectManager beanManager, Class<T> type) {
        this._selfType = type;
        type = DecoratorAdapter.create(type);
        this._adapterType = type;
        this._bean = beanManager.createManagedBean(type);
    }

    public Set<Annotation> getQualifiers() {
        if (this._delegateInjectionPoint != null) {
            return this._delegateInjectionPoint.getQualifiers();
        }
        return this._qualifiers;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this._bean.getStereotypes();
    }

    public String getName() {
        return this._bean.getName();
    }

    public boolean isNullable() {
        return true;
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<? extends Annotation> getScope() {
        return this._bean.getScope();
    }

    public Set<Type> getTypes() {
        return this._bean.getTypes();
    }

    public Set<Type> getDecoratedTypes() {
        return this._typeSet;
    }

    public T create(CreationalContext<T> creationalContext) {
        return (T)this._bean.create(creationalContext);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        if (this._delegateInjectionPoint != null) {
            this.bind();
        }
        return this._bean.getInjectionPoints();
    }

    public Class<?> getBeanClass() {
        return this._bean.getBeanClass();
    }

    public Type getDelegateType() {
        if (this._delegateInjectionPoint == null) {
            this.bind();
        }
        return this._delegateInjectionPoint.getType();
    }

    public Set<Annotation> getDelegateQualifiers() {
        if (this._delegateInjectionPoint != null) {
            return this._delegateInjectionPoint.getQualifiers();
        }
        return this._qualifiers;
    }

    public InjectionPoint getDelegateInjectionPoint() {
        if (this._delegateInjectionPoint != null) {
            this.bind();
        }
        return this._delegateInjectionPoint;
    }

    public void bind() {
        if (this._delegateInjectionPoint != null) {
            return;
        }
        this.introspect();
        if (this._delegateField == null && this._delegateMethod == null && this._delegateConstructor == null) {
            throw new ConfigException(L.l("{0} is missing a @Delegate field.  All @Decorators need a @Delegate field for a delegate injection", (Object)this._adapterType.getName()));
        }
        if (this._adapterType.isAnnotationPresent(Interceptor.class)) {
            throw new ConfigException(L.l("{0} is an invalid @Delegate because it has an @Interceptor annotation.", (Object)this._adapterType.getName()));
        }
        if (Modifier.isFinal(this._adapterType.getModifiers())) {
            throw new ConfigException(L.l("{0} is an invalid @Decorator because it is a final class.", (Object)this._adapterType.getName()));
        }
    }

    protected void introspect() {
        for (InjectionPoint ip : this._bean.getInjectionPoints()) {
            if (!ip.isDelegate()) continue;
            if (this._delegateInjectionPoint != null) {
                throw new ConfigException(L.l("{0}: @Decorator field '{1}' conflicts with earlier field '{2}'. A decorator must have exactly one delegate field.", (Object)ip.getBean().getBeanClass().getName(), (Object)ip.getMember().getName(), (Object)this._delegateInjectionPoint.getMember().getName()));
            }
            this._delegateInjectionPoint = ip;
        }
        if (this._delegateInjectionPoint != null) {
            if (this._delegateInjectionPoint.getMember() instanceof Field) {
                this._delegateField = (Field)this._delegateInjectionPoint.getMember();
                this._delegateField.setAccessible(true);
            } else if (this._delegateInjectionPoint.getMember() instanceof Method) {
                this._delegateMethod = (Method)this._delegateInjectionPoint.getMember();
                this._delegateMethod.setAccessible(true);
            } else if (this._delegateInjectionPoint.getMember() instanceof Constructor) {
                this._delegateConstructor = (Constructor)this._delegateInjectionPoint.getMember();
                this._delegateConstructor.setAccessible(true);
            }
            InjectManager manager = InjectManager.getCurrent();
            BaseType selfType = manager.createTargetBaseType(this._selfType);
            BaseType delegateType = manager.createSourceBaseType(this._delegateInjectionPoint.getType());
            this._typeSet = new LinkedHashSet<Type>();
            for (Type type : selfType.getTypeClosure(manager)) {
                BaseType baseType = manager.createSourceBaseType(type);
                if (!baseType.getRawClass().isInterface() || baseType.getRawClass().equals(Serializable.class)) continue;
                if (baseType.isAssignableFrom(delegateType)) {
                    this._typeSet.add(type);
                    for (Method method : baseType.getRawClass().getMethods()) {
                        Method implMethod = AnnotatedTypeUtil.findMethod(selfType.getRawClass().getMethods(), method);
                        if (implMethod == null || !Modifier.isFinal(implMethod.getModifiers())) continue;
                        throw new ConfigException(L.l("'{0}.{1}' is an invalid decorator method because it is final.", (Object)implMethod.getDeclaringClass().getName(), (Object)implMethod.getName()));
                    }
                    continue;
                }
                if (this.isDeclaredInterface(selfType, baseType)) {
                    throw new ConfigException(L.l("{0}: '{1}' is a Decorator type not implemented by the delegate {2}", (Object)this._selfType.getName(), (Object)baseType, (Object)delegateType));
                }
                this._typeSet.add(type);
            }
        }
    }

    private boolean isDeclaredInterface(BaseType selfType, BaseType baseType) {
        for (Class<?> iface : selfType.getRawClass().getInterfaces()) {
            if (!iface.equals(baseType.getRawClass())) continue;
            return true;
        }
        return false;
    }

    protected void introspectBindingTypes(Annotation[] annList) {
        for (Annotation ann : annList) {
            if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            this._qualifiers.add(ann);
        }
        if (this._qualifiers.size() == 0) {
            this._qualifiers.add((Annotation)DefaultLiteral.DEFAULT);
        }
    }

    public T instantiate() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void destroy(T instance, CreationalContext<T> env) {
        this._bean.destroy(instance, env);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this._adapterType.getSimpleName());
        if (this._delegateField != null) {
            sb.append(",").append(this._delegateField.getType().getSimpleName());
        }
        sb.append("]");
        return sb.toString();
    }
}

