/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.core;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.core.ResinControl;
import com.caucho.config.types.FileVar;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.xml.LooseXml;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.w3c.dom.Document;

public class ResinInclude
extends ResinControl {
    private static final L10N L = new L10N(ResinInclude.class);
    private static final Logger log = Logger.getLogger(ResinInclude.class.getName());
    private Path _path;

    public void setConfigSystemId(String systemId) {
    }

    public void setHref(String path) {
        this._path = Vfs.lookup().lookup(FileVar.__FILE__.toString()).getParent().lookup(path);
    }

    public void setPath(String path) {
        this.setHref(path);
    }

    public void setOptional(boolean optional) {
    }

    @PostConstruct
    public void init() throws Exception {
        if (this._path == null) {
            throw new ConfigException(L.l("'href' attribute missing from resin:include."));
        }
        if (!this._path.canRead() || this._path.isDirectory()) {
            throw new ConfigException(L.l("Required file '{0}' can not be read for resin:include.", (Object)this._path.getNativePath()));
        }
        Object object = this.getObject();
        log.config(L.l("resin:include '{0}'.\nresin:include is deprecated.  Please use resin:import instead.", (Object)this._path.getNativePath()));
        LooseXml xml = new LooseXml();
        Document doc = xml.parseDocument(this._path);
        new Config().configure(object, doc);
    }
}

