/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.attribute;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.reflect.Method;

public class PropertyAttribute
extends Attribute {
    private static final L10N L = new L10N(PropertyAttribute.class);
    private final Method _putMethod;
    private final ConfigType<?> _type;

    public PropertyAttribute(Method putMethod, ConfigType<?> type) {
        this._putMethod = putMethod;
        this._type = type;
    }

    @Override
    public ConfigType<?> getConfigType() {
        return this._type;
    }

    @Override
    public void setText(Object bean, QName name, String value) throws ConfigException {
        if ("#text".equals(name.getLocalName())) {
            if (value == null || value.trim().length() == 0) {
                return;
            }
            throw new ConfigException(L.l("text is not allowed for bean {0}\n  '{1}'", (Object)bean.getClass().getName(), (Object)value.trim()));
        }
        try {
            this._putMethod.invoke(bean, name.getLocalName(), this._type.valueOf(value));
        }
        catch (Exception e) {
            throw ConfigException.create(this._putMethod, (Throwable)e);
        }
    }

    @Override
    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        if ("#text".equals(name.getLocalName())) {
            throw new ConfigException(L.l("text is not allowed in this context\n  '{0}'", value));
        }
        try {
            this._putMethod.invoke(bean, name.getLocalName(), value);
        }
        catch (Exception e) {
            throw ConfigException.create(this._putMethod, (Throwable)e);
        }
    }
}

