/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JavaAnnotation;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.OpaqueAttribute;
import com.caucho.bytecode.SignatureAttribute;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaField
extends JField {
    private static final Logger log = Logger.getLogger(JavaField.class.getName());
    private JavaClass _jClass;
    private int _accessFlags;
    private String _name;
    private String _descriptor;
    private boolean _isWrite;
    private ArrayList<Attribute> _attributes = new ArrayList();
    private JavaAnnotation[] _annotations;

    public void setJavaClass(JavaClass jClass) {
        this._jClass = jClass;
    }

    public void setWrite(boolean isWrite) {
        this._isWrite = isWrite;
    }

    @Override
    public JClass getDeclaringClass() {
        return this._jClass;
    }

    public JavaClassLoader getClassLoader() {
        return this._jClass.getClassLoader();
    }

    public void setName(String name) {
        this._name = name;
        if (this._isWrite) {
            this._jClass.getConstantPool().addUTF8(name);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setAccessFlags(int flags) {
        this._accessFlags = flags;
    }

    public int getAccessFlags() {
        return this._accessFlags;
    }

    public void setDescriptor(String descriptor) {
        this._descriptor = descriptor;
        if (this._isWrite) {
            this._jClass.getConstantPool().addUTF8(descriptor);
        }
    }

    public String getDescriptor() {
        return this._descriptor;
    }

    @Override
    public JClass getType() {
        return this.getClassLoader().descriptorToClass(this.getDescriptor(), 0);
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getAccessFlags());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getAccessFlags());
    }

    @Override
    public boolean isTransient() {
        return Modifier.isTransient(this.getAccessFlags());
    }

    @Override
    public JType getGenericType() {
        SignatureAttribute sigAttr = (SignatureAttribute)this.getAttribute("Signature");
        if (sigAttr != null) {
            return this.getClassLoader().parseParameterizedType(sigAttr.getSignature());
        }
        return this.getType();
    }

    public void addAttribute(Attribute attr) {
        this._attributes.add(attr);
    }

    public Attribute getAttribute(String name) {
        for (int i = this._attributes.size() - 1; i >= 0; --i) {
            Attribute attr = this._attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public JAnnotation[] getDeclaredAnnotations() {
        if (this._annotations == null) {
            Attribute attr = this.getAttribute("RuntimeVisibleAnnotations");
            if (attr instanceof OpaqueAttribute) {
                byte[] buffer = ((OpaqueAttribute)attr).getValue();
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                    ConstantPool cp = this._jClass.getConstantPool();
                    this._annotations = JavaAnnotation.parseAnnotations(is, cp, this.getClassLoader());
                }
                catch (IOException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            if (this._annotations == null) {
                this._annotations = new JavaAnnotation[0];
            }
        }
        return this._annotations;
    }

    public void write(ByteCodeWriter out) throws IOException {
        out.writeShort(this._accessFlags);
        out.writeUTF8Const(this._name);
        out.writeUTF8Const(this._descriptor);
        out.writeShort(this._attributes.size());
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            attr.write(out);
        }
    }

    public JavaField export(JavaClass cl, JavaClass target) {
        JavaField field = new JavaField();
        field.setName(this._name);
        field.setDescriptor(this._descriptor);
        field.setAccessFlags(this._accessFlags);
        target.getConstantPool().addUTF8(this._name);
        target.getConstantPool().addUTF8(this._descriptor);
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            field.addAttribute(attr.export(cl, target));
        }
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !JavaField.class.equals(o.getClass())) {
            return false;
        }
        JavaField field = (JavaField)o;
        return this._name.equals(field._name);
    }

    @Override
    public String toString() {
        return "JavaField[" + this._name + "]";
    }
}

