/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharIntAssociativeContainer;
import com.carrotsearch.hppc.CharIntMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharIntCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.CharIntProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharIntOpenHashMap
implements CharIntMap,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public char[] keys;
    public int[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public CharIntOpenHashMap() {
        this(16);
    }

    public CharIntOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CharIntOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public CharIntOpenHashMap(CharIntAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public int put(char key, int value) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                int oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        this.values[slot] = value;
        return 0;
    }

    @Override
    public final int putAll(CharIntAssociativeContainer container) {
        int count = this.assigned;
        for (CharIntCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public final int putAll(Iterable<? extends CharIntCursor> iterable) {
        int count = this.assigned;
        for (CharIntCursor charIntCursor : iterable) {
            this.put(charIntCursor.key, charIntCursor.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(char key, int value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final int putOrAdd(char key, int putValue, int additionValue) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (this.keys[slot] == key) {
                int n = slot;
                int n2 = this.values[n] + additionValue;
                this.values[n] = n2;
                return n2;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        int v = this.values[slot] = putValue;
        return v;
    }

    private void expandAndRehash() {
        char[] oldKeys = this.keys;
        int[] oldValues = this.values;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            char key = oldKeys[i];
            int value = oldValues[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new char[capacity];
        this.values = new int[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public int remove(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                int v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public final int removeAll(CharContainer container) {
        int before = this.assigned;
        for (CharCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public final int removeAll(CharPredicate predicate) {
        int before = this.assigned;
        char[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public int get(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    public int lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public int lset(int key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        int previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (CharIntCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            CharIntMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof CharIntMap && (other = (CharIntMap)obj).size() == this.size()) {
                for (CharIntCursor c : this) {
                    int v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<CharIntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends CharIntProcedure> T forEach(T procedure) {
        char[] keys = this.keys;
        int[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        return new ValuesContainer();
    }

    public CharIntOpenHashMap clone() {
        try {
            CharIntOpenHashMap cloned = (CharIntOpenHashMap)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.values = (int[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static CharIntOpenHashMap from(char[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharIntOpenHashMap map = new CharIntOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static CharIntOpenHashMap from(CharIntAssociativeContainer container) {
        return new CharIntOpenHashMap(container);
    }

    public static CharIntOpenHashMap newInstance() {
        return new CharIntOpenHashMap();
    }

    public static CharIntOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new CharIntOpenHashMap(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            int max = CharIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return CharIntOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CharIntOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            boolean[] allocated = CharIntOpenHashMap.this.allocated;
            int[] values = CharIntOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            boolean[] allocated = CharIntOpenHashMap.this.allocated;
            int[] values = CharIntOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            boolean[] allocated = CharIntOpenHashMap.this.allocated;
            int[] values = CharIntOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(int e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            int max = CharIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharIntOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharIntOpenHashMap owner;

        public KeysContainer() {
            this.owner = CharIntOpenHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return CharIntOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            char[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            char[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(char e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<CharIntCursor> {
        private final CharIntCursor cursor = new CharIntCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharIntCursor fetch() {
            int i;
            int max = CharIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharIntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = CharIntOpenHashMap.this.keys[i];
            this.cursor.value = CharIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

