/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference.builtin;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.Objects;

public class V8ValueBuiltInReflect
extends V8ValueObject {
    public static final String FUNCTION_APPLY = "apply";
    public static final String FUNCTION_CONSTRUCT = "construct";
    public static final String FUNCTION_DEFINE_PROPERTY = "defineProperty";
    public static final String FUNCTION_DELETE_PROPERTY = "deleteProperty";
    public static final String FUNCTION_GET = "get";
    public static final String FUNCTION_GET_PROTOTYPE_OF = "getPrototypeOf";
    public static final String FUNCTION_GET_OWN_PROPERTY_DESCRIPTOR = "getOwnPropertyDescriptor";
    public static final String FUNCTION_HAS = "has";
    public static final String FUNCTION_IS_EXTENSIBLE = "isExtensible";
    public static final String FUNCTION_OWN_KEYS = "ownKeys";
    public static final String FUNCTION_PREVENT_EXTENSIONS = "preventExtensions";
    public static final String FUNCTION_SET = "set";
    public static final String FUNCTION_SET_PROTOTYPE_OF = "setPrototypeOf";
    public static final String NAME = "Reflect";

    public V8ValueBuiltInReflect(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    public V8Value _get(V8Value target, V8Value property) throws JavetException {
        return this.invoke(FUNCTION_GET, Objects.requireNonNull(target), Objects.requireNonNull(property));
    }

    public V8ValueBoolean _has(V8Value target, V8Value property) throws JavetException {
        return (V8ValueBoolean)this.invoke(FUNCTION_HAS, Objects.requireNonNull(target), Objects.requireNonNull(property));
    }

    public V8ValueBoolean _set(V8Value target, V8Value propertyKey, V8Value propertyValue, V8Value receiver) throws JavetException {
        return (V8ValueBoolean)this.invoke(FUNCTION_SET, Objects.requireNonNull(target), Objects.requireNonNull(propertyKey), Objects.requireNonNull(propertyValue), Objects.requireNonNull(receiver));
    }

    public V8Value apply(V8Value target, V8Value thisObject, V8ValueArray arguments) throws JavetException {
        return this.invoke(FUNCTION_APPLY, Objects.requireNonNull(target), Objects.requireNonNull(thisObject), Objects.requireNonNull(arguments));
    }

    public V8Value construct(V8Value target, V8ValueArray arguments, V8Value newTarget) throws JavetException {
        return this.invoke(FUNCTION_CONSTRUCT, Objects.requireNonNull(target), Objects.requireNonNull(arguments), Objects.requireNonNull(newTarget));
    }

    public V8ValueBoolean defineProperty(V8Value target, V8Value property, V8ValueObject descriptor) throws JavetException {
        return (V8ValueBoolean)this.invoke(FUNCTION_DEFINE_PROPERTY, Objects.requireNonNull(target), Objects.requireNonNull(property), Objects.requireNonNull(descriptor));
    }

    public V8ValueBoolean deleteProperty(V8Value target, V8Value property) throws JavetException {
        return (V8ValueBoolean)this.invoke(FUNCTION_DELETE_PROPERTY, Objects.requireNonNull(target), Objects.requireNonNull(property));
    }

    public V8Value getOwnPropertyDescriptor(V8Value target, V8Value property) throws JavetException {
        return this.invoke(FUNCTION_GET_OWN_PROPERTY_DESCRIPTOR, Objects.requireNonNull(target), Objects.requireNonNull(property));
    }

    public V8Value getPrototypeOf(V8Value target) throws JavetException {
        return this.invoke(FUNCTION_GET_PROTOTYPE_OF, Objects.requireNonNull(target));
    }

    public V8ValueBoolean isExtensible(V8Value target) throws JavetException {
        return (V8ValueBoolean)this.invoke(FUNCTION_IS_EXTENSIBLE, Objects.requireNonNull(target));
    }

    public V8ValueArray ownKeys(V8Value target) throws JavetException {
        return (V8ValueArray)this.invoke(FUNCTION_OWN_KEYS, Objects.requireNonNull(target));
    }

    public V8ValueBoolean preventExtensions(V8Value target) throws JavetException {
        return (V8ValueBoolean)this.invoke(FUNCTION_PREVENT_EXTENSIONS, Objects.requireNonNull(target));
    }

    public V8ValueBoolean setPrototypeOf(V8Value target, V8Value prototype) throws JavetException {
        return (V8ValueBoolean)this.invoke(FUNCTION_SET_PROTOTYPE_OF, Objects.requireNonNull(target), Objects.requireNonNull(prototype));
    }

    public V8ValueBuiltInReflect toClone() throws JavetException {
        return this;
    }
}

