/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ContextType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBigInteger;
import com.caoccao.javet.values.primitive.V8ValueNull;
import com.caoccao.javet.values.primitive.V8ValueUndefined;
import com.caoccao.javet.values.primitive.V8ValueZonedDateTime;
import com.caoccao.javet.values.reference.IV8ValueReference;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public interface IV8Context
extends IV8ValueReference {
    public <T extends V8Value> T get(int var1) throws JavetException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public BigInteger getBigInteger(int index) throws JavetException {
        try (Object v8Value = this.get(index);){
            if (!(v8Value instanceof V8ValueBigInteger)) return null;
            BigInteger bigInteger = (BigInteger)((V8ValueBigInteger)v8Value).getValue();
            return bigInteger;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable7) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Boolean getBoolean(int index) throws JavetException {
        try (Object v8Value = this.get(index);){
            Boolean bl = v8Value.asBoolean();
            return bl;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Double getDouble(int index) throws JavetException {
        try (Object v8Value = this.get(index);){
            Double d = v8Value.asDouble();
            return d;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    default public Float getFloat(int index) throws JavetException {
        Double result = this.getDouble(index);
        return result == null ? null : Float.valueOf(result.floatValue());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Integer getInteger(int index) throws JavetException {
        try (Object v8Value = this.get(index);){
            Integer n = v8Value.asInt();
            return n;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    public int getLength() throws JavetException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Long getLong(int index) throws JavetException {
        try (Object v8Value = this.get(index);){
            Long l = v8Value.asLong();
            return l;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    default public V8ValueNull getNull(int index) throws JavetException {
        return (V8ValueNull)this.get(index);
    }

    default public <T> T getObject(int index) throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.get(index), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public String getString(int index) throws JavetException {
        try (Object v8Value = this.get(index);){
            if (v8Value.isNullOrUndefined()) {
                String string2 = null;
                return string2;
            }
            String string = v8Value.asString();
            return string;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable7) {
            return null;
        }
    }

    default public V8ValueUndefined getUndefined(int index) throws JavetException {
        return (V8ValueUndefined)this.get(index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public ZonedDateTime getZonedDateTime(int index) throws JavetException {
        try (Object v8Value = this.get(index);){
            if (!(v8Value instanceof V8ValueZonedDateTime)) return null;
            ZonedDateTime zonedDateTime = (ZonedDateTime)((V8ValueZonedDateTime)v8Value).getValue();
            return zonedDateTime;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable7) {
            // empty catch block
        }
        return null;
    }

    default public boolean isAwaitContext() throws JavetException {
        return this.isContextType(V8ContextType.Await);
    }

    default public boolean isBlockContext() throws JavetException {
        return this.isContextType(V8ContextType.Block);
    }

    default public boolean isCatchContext() throws JavetException {
        return this.isContextType(V8ContextType.Catch);
    }

    public boolean isContextType(V8ContextType var1) throws JavetException;

    default public boolean isDebugEvaluateContext() throws JavetException {
        return this.isContextType(V8ContextType.DebugEvaluate);
    }

    default public boolean isDeclarationContext() throws JavetException {
        return this.isContextType(V8ContextType.Declaration);
    }

    default public boolean isEvalContext() throws JavetException {
        return this.isContextType(V8ContextType.Eval);
    }

    default public boolean isFunctionContext() throws JavetException {
        return this.isContextType(V8ContextType.Function);
    }

    default public boolean isModuleContext() throws JavetException {
        return this.isContextType(V8ContextType.Module);
    }

    default public boolean isScriptContext() throws JavetException {
        return this.isContextType(V8ContextType.Script);
    }

    default public boolean isWithContext() throws JavetException {
        return this.isContextType(V8ContextType.With);
    }

    public boolean setLength(int var1) throws JavetException;
}

