/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy.plugins;

import com.caoccao.javet.entities.JavetEntityPropertyDescriptor;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetEntityPropertyDescriptor;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.plugins.BaseJavetProxyPluginSingle;
import com.caoccao.javet.utils.ArrayUtils;
import com.caoccao.javet.utils.SimpleList;
import com.caoccao.javet.utils.SimpleSet;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.virtual.V8VirtualIterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class JavetProxyPluginMap
extends BaseJavetProxyPluginSingle<Map<Object, Object>> {
    public static final String NAME = Map.class.getName();
    protected static final String CLEAR = "clear";
    protected static final String DELETE = "delete";
    protected static final String ENTRIES = "entries";
    protected static final String ERROR_TARGET_OBJECT_MUST_BE_AN_INSTANCE_OF_MAP = "Target object must be an instance of Map.";
    protected static final String FOR_EACH = "forEach";
    protected static final String GET = "get";
    protected static final String HAS = "has";
    protected static final String KEYS = "keys";
    protected static final String OBJECT_MAP = "[object Map]";
    protected static final String SET = "set";
    protected static final String SIZE = "size";
    protected static final String[] DEFAULT_PROXYABLE_METHODS = new String[]{"clear", "forEach", "get", "size", "toString"};
    protected static final String VALUES = "values";
    private static final JavetProxyPluginMap instance = new JavetProxyPluginMap();
    protected final Set<String> proxyableMethods = SimpleSet.of(DEFAULT_PROXYABLE_METHODS);

    public JavetProxyPluginMap() {
        this.proxyGetByStringMap.put(CLEAR, this::clear);
        this.proxyGetByStringMap.put(DELETE, this::delete);
        this.proxyGetByStringMap.put(ENTRIES, this::entries);
        this.proxyGetByStringMap.put(FOR_EACH, this::forEach);
        this.proxyGetByStringMap.put(GET, this::get);
        this.proxyGetByStringMap.put(HAS, this::has);
        this.proxyGetByStringMap.put(KEYS, this::keys);
        this.proxyGetByStringMap.put(SET, this::set);
        this.proxyGetByStringMap.put(SIZE, this::size);
        this.proxyGetByStringMap.put("toJSON", this::toJSON);
        this.proxyGetByStringMap.put("toString", this::toString);
        this.proxyGetByStringMap.put("valueOf", this::valueOf);
        this.proxyGetByStringMap.put(VALUES, this::values);
        this.proxyGetBySymbolMap.put("Symbol.iterator", this::entries);
    }

    public static JavetProxyPluginMap getInstance() {
        return instance;
    }

    public V8Value clear(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(CLEAR, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginMap.lambda$clear$f698b129$1((Map)map, v8Runtime, arg_0)));
    }

    @Override
    protected V8Value createTargetObject(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return null;
    }

    public V8Value delete(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(DELETE, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginMap.lambda$delete$f698b129$1((Map)map, v8Runtime, arg_0)));
    }

    @Override
    public boolean deleteByObject(Object targetObject, Object propertyKey) {
        Object map = this.validateTargetObject(targetObject);
        return propertyKey != null && map.remove(propertyKey) != null;
    }

    public V8Value entries(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        List entries = map.entrySet().stream().map(entry -> SimpleList.of(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(ENTRIES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> PROXY_CONVERTER.toV8Value(v8Runtime, new V8VirtualIterator(entries.iterator()))));
    }

    public V8Value forEach(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FOR_EACH, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginMap.lambda$forEach$be777208$1(v8Runtime, (Map)map, arg_0, arg_1)));
    }

    public V8Value get(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(GET, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginMap.lambda$get$f698b129$1((Map)map, v8Runtime, arg_0)));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object[] getProxyOwnKeys(Object targetObject) {
        Object map = this.validateTargetObject(targetObject);
        return map.keySet().toArray();
    }

    @Override
    public <T> IJavetEntityPropertyDescriptor<T> getProxyOwnPropertyDescriptor(Object targetObject, Object propertyName) {
        return new JavetEntityPropertyDescriptor(true, true, true);
    }

    public V8Value has(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(HAS, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginMap.lambda$has$f698b129$1((Map)map, v8Runtime, arg_0)));
    }

    @Override
    public boolean hasByObject(Object targetObject, Object propertyKey) {
        Object map = this.validateTargetObject(targetObject);
        return map.containsKey(propertyKey);
    }

    @Override
    public boolean isDeleteSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isHasSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isMethodProxyable(String methodName, Class<?> targetClass) {
        return this.proxyableMethods.contains(methodName);
    }

    @Override
    public boolean isOwnKeysSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isProxyable(Class<?> targetClass) {
        return targetClass != null && Map.class.isAssignableFrom(targetClass);
    }

    @Override
    public boolean isUniqueKeySupported(Class<?> targetClass) {
        return true;
    }

    public V8Value keys(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(KEYS, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginMap.lambda$keys$63078229$1(v8Runtime, (Map)map, arg_0)));
    }

    @Override
    public void populateUniqueKeys(Set<String> uniqueKeySet, Object targetObject) {
        Object map = this.validateTargetObject(targetObject);
        map.keySet().stream().map(Object::toString).filter(Objects::nonNull).forEach(Objects.requireNonNull(uniqueKeySet)::add);
    }

    public V8Value set(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SET, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginMap.lambda$set$be777208$1(v8Runtime, (Map)map, arg_0, arg_1)));
    }

    public V8Value size(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueInteger(map.size());
    }

    public V8Value toJSON(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("toJSON", targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginMap.lambda$toJSON$f698b129$1((Map)map, v8Runtime, arg_0)));
    }

    public V8Value toString(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("toString", targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> v8Runtime.createV8ValueString(OBJECT_MAP)));
    }

    @Override
    protected Map<Object, Object> validateTargetObject(Object targetObject) {
        assert (targetObject instanceof Map) : "Target object must be an instance of Map.";
        return (Map)targetObject;
    }

    public V8Value valueOf(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(VALUES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginMap.lambda$valueOf$63078229$1(v8Runtime, (Map)map, arg_0)));
    }

    public V8Value values(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object map = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(VALUES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginMap.lambda$values$63078229$1(v8Runtime, (Map)map, arg_0)));
    }

    private static /* synthetic */ V8Value lambda$values$63078229$1(V8Runtime v8Runtime, Map map, V8Value[] v8Values) throws JavetException, Exception {
        return PROXY_CONVERTER.toV8Value(v8Runtime, new V8VirtualIterator(map.values().iterator()));
    }

    private static /* synthetic */ V8Value lambda$valueOf$63078229$1(V8Runtime v8Runtime, Map map, V8Value[] v8Values) throws JavetException, Exception {
        return V8ValueUtils.createV8ValueMap(v8Runtime, map);
    }

    private static /* synthetic */ V8Value lambda$toJSON$f698b129$1(Map map, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        Object[] objects = new Object[map.size() << 1];
        int index = 0;
        for (Map.Entry entry : map.entrySet()) {
            objects[index] = entry.getKey();
            objects[index + 1] = entry.getValue();
            index += 2;
        }
        return V8ValueUtils.createV8ValueObject(v8Runtime, objects);
    }

    private static /* synthetic */ V8Value lambda$set$be777208$1(V8Runtime v8Runtime, Map map, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        Object key = v8Runtime.toObject(V8ValueUtils.asV8Value(v8Values, 0));
        Object value = v8Runtime.toObject(V8ValueUtils.asV8Value(v8Values, 1));
        if (key != null) {
            map.put(key, value);
        }
        return thisObject;
    }

    private static /* synthetic */ V8Value lambda$keys$63078229$1(V8Runtime v8Runtime, Map map, V8Value[] v8Values) throws JavetException, Exception {
        return PROXY_CONVERTER.toV8Value(v8Runtime, new V8VirtualIterator(map.keySet().iterator()));
    }

    private static /* synthetic */ V8Value lambda$has$f698b129$1(Map map, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        boolean found = false;
        if (!map.isEmpty() && ArrayUtils.isNotEmpty(v8Values)) {
            found = map.containsKey(v8Runtime.toObject(v8Values[0]));
        }
        return v8Runtime.createV8ValueBoolean(found);
    }

    private static /* synthetic */ V8Value lambda$get$f698b129$1(Map map, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        Object key;
        if (!map.isEmpty() && ArrayUtils.isNotEmpty(v8Values) && map.containsKey(key = v8Runtime.toObject(v8Values[0]))) {
            return v8Runtime.toV8Value(map.get(key));
        }
        return v8Runtime.createV8ValueUndefined();
    }

    private static /* synthetic */ V8Value lambda$forEach$be777208$1(V8Runtime v8Runtime, Map map, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction != null) {
            V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
            for (Map.Entry entry : map.entrySet()) {
                Object v8ValueResult = v8ValueFunction.call((V8Value)v8ValueObject, entry.getValue(), entry.getKey(), thisObject);
                Throwable throwable = null;
                if (v8ValueResult == null) continue;
                if (throwable != null) {
                    try {
                        ((V8Value)v8ValueResult).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                ((V8Value)v8ValueResult).close();
            }
        }
        return v8Runtime.createV8ValueUndefined();
    }

    private static /* synthetic */ V8Value lambda$delete$f698b129$1(Map map, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        boolean deleted = false;
        if (!map.isEmpty() && ArrayUtils.isNotEmpty(v8Values)) {
            deleted = map.remove(v8Runtime.toObject(v8Values[0])) != null;
        }
        return v8Runtime.createV8ValueBoolean(deleted);
    }

    private static /* synthetic */ V8Value lambda$clear$f698b129$1(Map map, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        map.clear();
        return v8Runtime.createV8ValueUndefined();
    }
}

