/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy.plugins;

import com.caoccao.javet.entities.JavetEntityPropertyDescriptor;
import com.caoccao.javet.enums.V8ValueErrorType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.exceptions.V8ErrorTemplate;
import com.caoccao.javet.interfaces.IJavetEntityPropertyDescriptor;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.plugins.BaseJavetProxyPluginSingle;
import com.caoccao.javet.utils.ArrayUtils;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.ListUtils;
import com.caoccao.javet.utils.SimpleList;
import com.caoccao.javet.utils.SimpleSet;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueInteger;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.virtual.V8VirtualIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class JavetProxyPluginList
extends BaseJavetProxyPluginSingle<List<Object>> {
    public static final String NAME = List.class.getName();
    protected static final String AT = "at";
    protected static final String CONCAT = "concat";
    protected static final String COPY_WITHIN = "copyWithin";
    protected static final String ENTRIES = "entries";
    protected static final String ERROR_TARGET_OBJECT_MUST_BE_AN_INSTANCE_OF_LIST = "Target object must be an instance of List.";
    protected static final String EVERY = "every";
    protected static final String FILL = "fill";
    protected static final String FILTER = "filter";
    protected static final String FIND = "find";
    protected static final String FIND_INDEX = "findIndex";
    protected static final String FIND_LAST = "findLast";
    protected static final String FIND_LAST_INDEX = "findLastIndex";
    protected static final String FLAT = "flat";
    protected static final String FLAT_MAP = "flatMap";
    protected static final String FOR_EACH = "forEach";
    protected static final String INCLUDES = "includes";
    protected static final String INDEX_OF = "indexOf";
    protected static final String JOIN = "join";
    protected static final String KEYS = "keys";
    protected static final String LAST_INDEX_OF = "lastIndexOf";
    protected static final String LENGTH = "length";
    protected static final String MAP = "map";
    protected static final String POP = "pop";
    protected static final String PUSH = "push";
    protected static final String REDUCE = "reduce";
    protected static final String REDUCE_RIGHT = "reduceRight";
    protected static final String REVERSE = "reverse";
    protected static final String SHIFT = "shift";
    protected static final String SLICE = "slice";
    protected static final String SOME = "some";
    protected static final String SORT = "sort";
    protected static final String[] DEFAULT_PROXYABLE_METHODS = new String[]{"forEach", "indexOf", "lastIndexOf", "sort", "toString"};
    protected static final String SPLICE = "splice";
    protected static final String TO_REVERSED = "toReversed";
    protected static final String TO_SORTED = "toSorted";
    protected static final String TO_SPLICED = "toSpliced";
    protected static final String UNSHIFT = "unshift";
    protected static final String VALUES = "values";
    protected static final String WITH = "with";
    private static final JavetProxyPluginList instance = new JavetProxyPluginList();
    protected final Set<String> proxyableMethods = SimpleSet.of(DEFAULT_PROXYABLE_METHODS);

    public JavetProxyPluginList() {
        this.proxyGetByStringMap.put(AT, this::at);
        this.proxyGetByStringMap.put(CONCAT, this::concat);
        this.proxyGetByStringMap.put(COPY_WITHIN, this::copyWithin);
        this.proxyGetByStringMap.put(ENTRIES, this::entries);
        this.proxyGetByStringMap.put(EVERY, this::every);
        this.proxyGetByStringMap.put(FILL, this::fill);
        this.proxyGetByStringMap.put(FILTER, this::filter);
        this.proxyGetByStringMap.put(FIND, this::find);
        this.proxyGetByStringMap.put(FIND_INDEX, this::findIndex);
        this.proxyGetByStringMap.put(FIND_LAST, this::findLast);
        this.proxyGetByStringMap.put(FIND_LAST_INDEX, this::findLastIndex);
        this.proxyGetByStringMap.put(FLAT, this::flat);
        this.proxyGetByStringMap.put(FLAT_MAP, this::flatMap);
        this.proxyGetByStringMap.put(FOR_EACH, this::forEach);
        this.proxyGetByStringMap.put(INCLUDES, this::includes);
        this.proxyGetByStringMap.put(INDEX_OF, this::indexOf);
        this.proxyGetByStringMap.put(JOIN, this::join);
        this.proxyGetByStringMap.put(KEYS, this::keys);
        this.proxyGetByStringMap.put(LAST_INDEX_OF, this::lastIndexOf);
        this.proxyGetByStringMap.put(LENGTH, this::length);
        this.proxyGetByStringMap.put(MAP, this::map);
        this.proxyGetByStringMap.put(POP, this::pop);
        this.proxyGetByStringMap.put(PUSH, this::push);
        this.proxyGetByStringMap.put(REDUCE, this::reduce);
        this.proxyGetByStringMap.put(REDUCE_RIGHT, this::reduceRight);
        this.proxyGetByStringMap.put(REVERSE, this::reverse);
        this.proxyGetByStringMap.put(SHIFT, this::shift);
        this.proxyGetByStringMap.put(SLICE, this::slice);
        this.proxyGetByStringMap.put(SOME, this::some);
        this.proxyGetByStringMap.put(SORT, this::sort);
        this.proxyGetByStringMap.put(SPLICE, this::splice);
        this.proxyGetByStringMap.put("toJSON", this::toJSON);
        this.proxyGetByStringMap.put(TO_REVERSED, this::toReversed);
        this.proxyGetByStringMap.put(TO_SORTED, this::toSorted);
        this.proxyGetByStringMap.put(TO_SPLICED, this::toSpliced);
        this.proxyGetByStringMap.put("toString", this::toString);
        this.proxyGetByStringMap.put(UNSHIFT, this::unshift);
        this.proxyGetByStringMap.put("valueOf", this::valueOf);
        this.proxyGetByStringMap.put(VALUES, this::values);
        this.proxyGetByStringMap.put(WITH, this::with);
        this.proxyGetBySymbolMap.put("Symbol.iterator", this::values);
    }

    public static JavetProxyPluginList getInstance() {
        return instance;
    }

    public V8Value at(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(AT, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$at$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value concat(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(CONCAT, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$concat$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value copyWithin(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(COPY_WITHIN, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$copyWithin$4a84cd3e$1((List)list, arg_0, arg_1)));
    }

    @Override
    protected V8Value createTargetObject(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return v8Runtime.createV8ValueArray();
    }

    @Override
    public boolean deleteByObject(Object targetObject, Object propertyKey) {
        int index;
        String propertyName;
        Object list = this.validateTargetObject(targetObject);
        if (propertyKey instanceof String && StringUtils.isDigital(propertyName = (String)propertyKey) && (index = Integer.parseInt(propertyName)) >= 0 && index < list.size()) {
            list.remove(index);
            return true;
        }
        return false;
    }

    public V8Value entries(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        int length = list.size();
        List entries = IntStream.range(0, length).mapToObj(arg_0 -> JavetProxyPluginList.lambda$entries$0((List)list, arg_0)).collect(Collectors.toList());
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(ENTRIES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> PROXY_CONVERTER.toV8Value(v8Runtime, new V8VirtualIterator(entries.iterator()))));
    }

    public V8Value every(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(EVERY, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$every$a2aa4572$1(v8Runtime, (List)list, arg_0, arg_1)));
    }

    public V8Value fill(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FILL, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$fill$bc245072$1((List)list, v8Runtime, arg_0, arg_1)));
    }

    public V8Value filter(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FILTER, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$filter$bc245072$1((List)list, v8Runtime, arg_0, arg_1)));
    }

    public V8Value find(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FIND, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$find$a2aa4572$1(v8Runtime, (List)list, arg_0, arg_1)));
    }

    public V8Value findIndex(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FIND_INDEX, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$findIndex$a2aa4572$1(v8Runtime, (List)list, arg_0, arg_1)));
    }

    public V8Value findLast(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FIND_LAST, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$findLast$a2aa4572$1(v8Runtime, (List)list, arg_0, arg_1)));
    }

    public V8Value findLastIndex(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FIND_LAST_INDEX, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$findLastIndex$a2aa4572$1(v8Runtime, (List)list, arg_0, arg_1)));
    }

    public V8Value flat(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FLAT, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$flat$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value flatMap(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FLAT_MAP, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$flatMap$bc245072$1((List)list, v8Runtime, arg_0, arg_1)));
    }

    public V8Value forEach(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FOR_EACH, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$forEach$a2aa4572$1(v8Runtime, (List)list, arg_0, arg_1)));
    }

    @Override
    public Object getByIndex(Object targetObject, int index) {
        Object list = this.validateTargetObject(targetObject);
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object[] getProxyOwnKeys(Object targetObject) {
        Object list = this.validateTargetObject(targetObject);
        ArrayList<String> keys = new ArrayList<String>();
        IntStream.range(0, list.size()).boxed().forEach(keys::add);
        keys.add(LENGTH);
        return keys.toArray();
    }

    @Override
    public <T> IJavetEntityPropertyDescriptor<T> getProxyOwnPropertyDescriptor(Object targetObject, Object propertyName) {
        if (propertyName instanceof String) {
            if (LENGTH.equals(propertyName)) {
                return new JavetEntityPropertyDescriptor(false, false, true);
            }
            return new JavetEntityPropertyDescriptor(true, true, true);
        }
        return new JavetEntityPropertyDescriptor(false, false, false);
    }

    @Override
    public boolean hasByObject(Object targetObject, Object propertyKey) {
        String propertyName;
        Object list = this.validateTargetObject(targetObject);
        if (propertyKey instanceof String && StringUtils.isDigital(propertyName = (String)propertyKey)) {
            int index = Integer.parseInt(propertyName);
            return index >= 0 && index < list.size();
        }
        return false;
    }

    public V8Value includes(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(INCLUDES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$includes$9878b793$1(v8Runtime, (List)list, arg_0)));
    }

    public V8Value indexOf(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(INDEX_OF, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$indexOf$9878b793$1(v8Runtime, (List)list, arg_0)));
    }

    @Override
    public boolean isDeleteSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isHasSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isIndexSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isMethodProxyable(String methodName, Class<?> targetClass) {
        return this.proxyableMethods.contains(methodName);
    }

    @Override
    public boolean isOwnKeysSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isProxyable(Class<?> targetClass) {
        return targetClass != null && List.class.isAssignableFrom(targetClass);
    }

    public V8Value join(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(JOIN, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$join$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value keys(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(KEYS, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$keys$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value lastIndexOf(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(LAST_INDEX_OF, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$lastIndexOf$9878b793$1(v8Runtime, (List)list, arg_0)));
    }

    public V8Value length(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueInteger(list.size());
    }

    public V8Value map(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(MAP, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$map$bc245072$1((List)list, v8Runtime, arg_0, arg_1)));
    }

    public V8Value pop(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(POP, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$pop$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value push(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(PUSH, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$push$9878b793$1(v8Runtime, (List)list, arg_0)));
    }

    public V8Value reduce(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(REDUCE, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$reduce$a2aa4572$1(v8Runtime, (List)list, arg_0, arg_1)));
    }

    public V8Value reduceRight(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(REDUCE, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$reduceRight$a2aa4572$1(v8Runtime, (List)list, arg_0, arg_1)));
    }

    public V8Value reverse(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(REVERSE, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$reverse$4a84cd3e$1((List)list, arg_0, arg_1)));
    }

    @Override
    public boolean setByIndex(Object targetObject, int index, Object value) {
        Object list = this.validateTargetObject(targetObject);
        if (index >= 0 && index < list.size()) {
            list.set(index, value);
            return true;
        }
        return false;
    }

    public V8Value shift(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SHIFT, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$shift$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value slice(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SLICE, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$slice$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value some(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SOME, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$some$a2aa4572$1(v8Runtime, (List)list, arg_0, arg_1)));
    }

    public V8Value sort(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SORT, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$sort$bc245072$1((List)list, v8Runtime, arg_0, arg_1)));
    }

    public V8Value splice(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SPLICE, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$splice$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value toJSON(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("toJSON", targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$toJSON$9878b793$1(v8Runtime, (List)list, arg_0)));
    }

    public V8Value toReversed(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(TO_REVERSED, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginList.lambda$toReversed$bc245072$1((List)list, v8Runtime, arg_0, arg_1)));
    }

    public V8Value toSorted(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(TO_SORTED, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$toSorted$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value toSpliced(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(TO_SPLICED, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$toSpliced$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    public V8Value toString(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("toString", targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$toString$9878b793$1(v8Runtime, (List)list, arg_0)));
    }

    public V8Value unshift(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(UNSHIFT, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$unshift$9878b793$1(v8Runtime, (List)list, arg_0)));
    }

    @Override
    protected List<Object> validateTargetObject(Object targetObject) {
        assert (targetObject instanceof List) : "Target object must be an instance of List.";
        return (List)targetObject;
    }

    public V8Value valueOf(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("valueOf", targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$valueOf$9878b793$1(v8Runtime, (List)list, arg_0)));
    }

    public V8Value values(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(VALUES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$values$9878b793$1(v8Runtime, (List)list, arg_0)));
    }

    public V8Value with(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object list = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(WITH, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginList.lambda$with$b1f2c293$1((List)list, v8Runtime, arg_0)));
    }

    private static /* synthetic */ V8Value lambda$with$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        Object[] objects = list.toArray();
        int index = V8ValueUtils.asInt(v8Values, 0);
        if (index >= 0 && index < objects.length) {
            objects[index] = v8Values.length > 1 ? v8Values[1] : v8Runtime.createV8ValueUndefined();
        } else {
            v8Runtime.throwError(V8ValueErrorType.RangeError, V8ErrorTemplate.rangeErrorInvalidIndex(index));
        }
        return V8ValueUtils.createV8ValueArray(v8Runtime, objects);
    }

    private static /* synthetic */ V8Value lambda$values$9878b793$1(V8Runtime v8Runtime, List list, V8Value[] v8Values) throws JavetException, Exception {
        return PROXY_CONVERTER.toV8Value(v8Runtime, new V8VirtualIterator(list.iterator()));
    }

    private static /* synthetic */ V8Value lambda$valueOf$9878b793$1(V8Runtime v8Runtime, List list, V8Value[] v8Values) throws JavetException, Exception {
        return V8ValueUtils.createV8ValueArray(v8Runtime, list.toArray());
    }

    private static /* synthetic */ V8Value lambda$unshift$9878b793$1(V8Runtime v8Runtime, List list, V8Value[] v8Values) throws JavetException, Exception {
        return v8Runtime.createV8ValueInteger(ListUtils.unshift(list, V8ValueUtils.toArray(v8Runtime, v8Values)));
    }

    private static /* synthetic */ V8Value lambda$toString$9878b793$1(V8Runtime v8Runtime, List list, V8Value[] v8Values) throws JavetException, Exception {
        try (V8ValueArray v8ValueArray = V8ValueUtils.createV8ValueArray(v8Runtime, list.toArray());){
            V8ValueString v8ValueString = v8Runtime.createV8ValueString(v8ValueArray.toString());
            return v8ValueString;
        }
    }

    private static /* synthetic */ V8Value lambda$toSpliced$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        ArrayList results = new ArrayList(list);
        if (ArrayUtils.isNotEmpty(v8Values)) {
            int length = list.size();
            int startIndex = V8ValueUtils.asInt(v8Values, 0);
            if (startIndex < 0) {
                startIndex += length;
            }
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (startIndex >= length) {
                v8Runtime.throwError(V8ValueErrorType.RangeError, V8ErrorTemplate.rangeErrorStartIsOutOfRange(startIndex));
            } else {
                int deleteCount = V8ValueUtils.asInt(v8Values, 1);
                if ((deleteCount = Math.min(deleteCount, length - startIndex)) > 0) {
                    results.subList(startIndex, startIndex + deleteCount).clear();
                }
                if (v8Values.length > 2) {
                    ArrayList toBeAddedList = new ArrayList();
                    for (int i = 2; i < v8Values.length; ++i) {
                        toBeAddedList.add(v8Runtime.toObject(v8Values[i]));
                    }
                    results.addAll(startIndex, toBeAddedList);
                }
            }
        }
        return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
    }

    private static /* synthetic */ V8Value lambda$toSorted$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        ArrayList results = new ArrayList(list);
        int length = list.size();
        if (length > 1) {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunction(v8Values, 0);
            if (v8ValueFunction == null) {
                results.sort((o1, o2) -> Comparator.naturalOrder().compare(String.valueOf(o1), String.valueOf(o2)));
            } else {
                try {
                    results.sort((o1, o2) -> {
                        try (Object v8Value = v8ValueFunction.call(null, o1, o2);){
                            int n = v8Value.asInt();
                            return n;
                        }
                        catch (JavetException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Throwable t) {
                    v8Runtime.throwError(V8ValueErrorType.Error, t.getMessage());
                }
            }
        }
        return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
    }

    private static /* synthetic */ V8Value lambda$toReversed$bc245072$1(List list, V8Runtime v8Runtime, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        ArrayList reversedList = new ArrayList(list);
        Collections.reverse(reversedList);
        return V8ValueUtils.createV8ValueArray(v8Runtime, reversedList.toArray());
    }

    private static /* synthetic */ V8Value lambda$toJSON$9878b793$1(V8Runtime v8Runtime, List list, V8Value[] v8Values) throws JavetException, Exception {
        return V8ValueUtils.createV8ValueArray(v8Runtime, list.toArray());
    }

    private static /* synthetic */ V8Value lambda$splice$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        ArrayList results = new ArrayList();
        if (ArrayUtils.isNotEmpty(v8Values)) {
            int length = list.size();
            int startIndex = V8ValueUtils.asInt(v8Values, 0);
            if (startIndex < 0) {
                startIndex += length;
            }
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (startIndex >= length) {
                v8Runtime.throwError(V8ValueErrorType.RangeError, V8ErrorTemplate.rangeErrorStartIsOutOfRange(startIndex));
            } else {
                int deleteCount = V8ValueUtils.asInt(v8Values, 1);
                if ((deleteCount = Math.min(deleteCount, length - startIndex)) > 0) {
                    List subList = list.subList(startIndex, startIndex + deleteCount);
                    results.addAll(subList);
                    subList.clear();
                }
                if (v8Values.length > 2) {
                    ArrayList toBeAddedList = new ArrayList();
                    for (int i = 2; i < v8Values.length; ++i) {
                        toBeAddedList.add(v8Runtime.toObject(v8Values[i]));
                    }
                    list.addAll(startIndex, toBeAddedList);
                }
            }
        }
        return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
    }

    private static /* synthetic */ V8Value lambda$sort$bc245072$1(List list, V8Runtime v8Runtime, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        int length = list.size();
        if (length > 1) {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunction(v8Values, 0);
            if (v8ValueFunction == null) {
                list.sort((o1, o2) -> Comparator.naturalOrder().compare(String.valueOf(o1), String.valueOf(o2)));
            } else {
                try {
                    list.sort((o1, o2) -> {
                        try (Object v8Value = v8ValueFunction.call(null, o1, o2);){
                            int n = v8Value.asInt();
                            return n;
                        }
                        catch (JavetException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Throwable t) {
                    v8Runtime.throwError(V8ValueErrorType.Error, t.getMessage());
                }
            }
        }
        return thisObject;
    }

    private static /* synthetic */ V8Value lambda$some$a2aa4572$1(V8Runtime v8Runtime, List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction != null) {
            V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
            int index = 0;
            for (Object object : list) {
                try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(index), thisObject);){
                    if (result.asBoolean()) {
                        V8ValueBoolean v8ValueBoolean = v8Runtime.createV8ValueBoolean(true);
                        return v8ValueBoolean;
                    }
                }
                ++index;
            }
        }
        return v8Runtime.createV8ValueBoolean(false);
    }

    private static /* synthetic */ V8Value lambda$slice$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        ArrayList results = new ArrayList();
        if (!list.isEmpty()) {
            int endIndex;
            int length = list.size();
            int startIndex = V8ValueUtils.asInt(v8Values, 0);
            if (startIndex < 0) {
                startIndex += length;
            }
            if (startIndex < 0) {
                startIndex = 0;
            }
            if ((endIndex = V8ValueUtils.asInt(v8Values, 1, length)) < 0) {
                endIndex += length;
            }
            if (endIndex < 0) {
                endIndex = 0;
            }
            if (endIndex > length) {
                endIndex = length;
            }
            if (startIndex < endIndex) {
                results.addAll(list.subList(startIndex, endIndex));
            }
        }
        return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
    }

    private static /* synthetic */ V8Value lambda$shift$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        if (list.isEmpty()) {
            return v8Runtime.createV8ValueUndefined();
        }
        return v8Runtime.toV8Value(ListUtils.shift(list));
    }

    private static /* synthetic */ V8Value lambda$reverse$4a84cd3e$1(List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        if (!list.isEmpty()) {
            Collections.reverse(list);
        }
        return thisObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ V8Value lambda$reduceRight$a2aa4572$1(V8Runtime v8Runtime, List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        void var7_11;
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction == null) return v8Runtime.createV8ValueUndefined();
        V8Value initialValue = V8ValueUtils.asV8Value(v8Values, 1);
        int length = list.size();
        if (initialValue == null) {
            void var7_8;
            if (length == 0) {
                v8Runtime.throwError(V8ValueErrorType.TypeError, V8ErrorTemplate.typeErrorReduceOfEmptyArrayWithNoInitialValue());
                return v8Runtime.createV8ValueUndefined();
            }
            if (length == 1) {
                return v8Runtime.toV8Value(list.get(0));
            }
            Object v = v8Runtime.toV8Value(list.get(length - 1));
            int index = length - 1;
            ListIterator listIterator = list.listIterator(length);
            while (listIterator.hasPrevious()) {
                Object result;
                if (index == length - 1) {
                    listIterator.previous();
                    --index;
                    continue;
                }
                try (Object currentValue = v8Runtime.toV8Value(listIterator.previous());){
                    result = v8ValueFunction.call((V8Value)null, new V8Value[]{var7_8, currentValue, v8Runtime.createV8ValueInteger(index), thisObject});
                }
                finally {
                    JavetResourceUtils.safeClose((Object)var7_8);
                }
                Object t = result;
                --index;
            }
            return var7_8;
        }
        if (length == 0) {
            return initialValue;
        }
        Object t = initialValue.toClone();
        int index = length - 1;
        ListIterator listIterator = list.listIterator(length);
        while (listIterator.hasPrevious()) {
            Object result;
            try (Object currentValue = v8Runtime.toV8Value(listIterator.previous());){
                result = v8ValueFunction.call((V8Value)null, new V8Value[]{var7_11, currentValue, v8Runtime.createV8ValueInteger(index), thisObject});
            }
            finally {
                JavetResourceUtils.safeClose((Object)var7_11);
            }
            Object t2 = result;
            --index;
        }
        return var7_11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ V8Value lambda$reduce$a2aa4572$1(V8Runtime v8Runtime, List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        void var7_11;
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction == null) return v8Runtime.createV8ValueUndefined();
        V8Value initialValue = V8ValueUtils.asV8Value(v8Values, 1);
        int length = list.size();
        if (initialValue == null) {
            void var7_8;
            if (length == 0) {
                v8Runtime.throwError(V8ValueErrorType.TypeError, V8ErrorTemplate.typeErrorReduceOfEmptyArrayWithNoInitialValue());
                return v8Runtime.createV8ValueUndefined();
            }
            if (length == 1) {
                return v8Runtime.toV8Value(list.get(0));
            }
            Object v = v8Runtime.toV8Value(list.get(0));
            int index = 0;
            for (Object object : list) {
                Object result;
                if (index == 0) {
                    ++index;
                    continue;
                }
                try (Object currentValue = v8Runtime.toV8Value(object);){
                    result = v8ValueFunction.call((V8Value)null, new V8Value[]{var7_8, currentValue, v8Runtime.createV8ValueInteger(index), thisObject});
                }
                finally {
                    JavetResourceUtils.safeClose((Object)var7_8);
                }
                Object t = result;
                ++index;
            }
            return var7_8;
        }
        if (length == 0) {
            return initialValue;
        }
        Object t = initialValue.toClone();
        int index = 0;
        for (Object object : list) {
            Object result;
            try (Object currentValue = v8Runtime.toV8Value(object);){
                result = v8ValueFunction.call((V8Value)null, new V8Value[]{var7_11, currentValue, v8Runtime.createV8ValueInteger(index), thisObject});
            }
            finally {
                JavetResourceUtils.safeClose((Object)var7_11);
            }
            Object t2 = result;
            ++index;
        }
        return var7_11;
    }

    private static /* synthetic */ V8Value lambda$push$9878b793$1(V8Runtime v8Runtime, List list, V8Value[] v8Values) throws JavetException, Exception {
        return v8Runtime.createV8ValueInteger(ListUtils.push(list, V8ValueUtils.toArray(v8Runtime, v8Values)));
    }

    private static /* synthetic */ V8Value lambda$pop$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        if (list.isEmpty()) {
            return v8Runtime.createV8ValueUndefined();
        }
        return v8Runtime.toV8Value(ListUtils.pop(list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ V8Value lambda$map$bc245072$1(List list, V8Runtime v8Runtime, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        ArrayList results = new ArrayList(list.size());
        try {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction != null) {
                V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                int index = 0;
                for (Object object : list) {
                    results.add(v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(index), thisObject));
                    ++index;
                }
            }
            V8ValueArray v8ValueArray = V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
            return v8ValueArray;
        }
        finally {
            JavetResourceUtils.safeClose(results);
        }
    }

    private static /* synthetic */ V8Value lambda$lastIndexOf$9878b793$1(V8Runtime v8Runtime, List list, V8Value[] v8Values) throws JavetException, Exception {
        int index = -1;
        if (ArrayUtils.isNotEmpty(v8Values)) {
            Object object = v8Runtime.toObject(v8Values[0]);
            int length = list.size();
            int fromIndex = V8ValueUtils.asInt(v8Values, 1, length - 1);
            if (fromIndex < 0) {
                fromIndex += length;
            }
            if (fromIndex < 0) {
                fromIndex = length - 1;
            }
            if (fromIndex < length) {
                index = ListUtils.lastIndexOf(list, object, fromIndex);
            }
        }
        return v8Runtime.createV8ValueInteger(index);
    }

    private static /* synthetic */ V8Value lambda$keys$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        int length = list.size();
        Object[] indexes = new Object[length];
        for (int i = 0; i < length; ++i) {
            indexes[i] = v8Runtime.createV8ValueInteger(i);
        }
        return V8ValueUtils.createV8ValueArray(v8Runtime, indexes);
    }

    private static /* synthetic */ V8Value lambda$join$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        String delimiter = V8ValueUtils.asString(v8Values, 0, "");
        String result = list.stream().map(Object::toString).collect(Collectors.joining(delimiter));
        return v8Runtime.createV8ValueString(result);
    }

    private static /* synthetic */ V8Value lambda$indexOf$9878b793$1(V8Runtime v8Runtime, List list, V8Value[] v8Values) throws JavetException, Exception {
        int index = -1;
        if (ArrayUtils.isNotEmpty(v8Values)) {
            Object object = v8Runtime.toObject(v8Values[0]);
            int fromIndex = V8ValueUtils.asInt(v8Values, 1);
            int length = list.size();
            if (fromIndex < 0) {
                fromIndex += length;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (fromIndex < length) {
                index = ListUtils.indexOf(list, object, fromIndex);
            }
        }
        return v8Runtime.createV8ValueInteger(index);
    }

    private static /* synthetic */ V8Value lambda$includes$9878b793$1(V8Runtime v8Runtime, List list, V8Value[] v8Values) throws JavetException, Exception {
        boolean included = false;
        if (ArrayUtils.isNotEmpty(v8Values)) {
            Object object = v8Runtime.toObject(v8Values[0]);
            int fromIndex = V8ValueUtils.asInt(v8Values, 1);
            int length = list.size();
            if (fromIndex < 0) {
                fromIndex += length;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (fromIndex < length) {
                included = ListUtils.includes(list, object, fromIndex);
            }
        }
        return v8Runtime.createV8ValueBoolean(included);
    }

    private static /* synthetic */ V8Value lambda$forEach$a2aa4572$1(V8Runtime v8Runtime, List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction != null) {
            V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
            int index = 0;
            for (Object object : list) {
                Object v8ValueResult = v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(index), thisObject);
                Throwable throwable = null;
                if (v8ValueResult != null) {
                    if (throwable != null) {
                        try {
                            ((V8Value)v8ValueResult).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ((V8Value)v8ValueResult).close();
                    }
                }
                ++index;
            }
        }
        return v8Runtime.createV8ValueUndefined();
    }

    /*
     * Loose catch block
     */
    private static /* synthetic */ V8Value lambda$flatMap$bc245072$1(List list, V8Runtime v8Runtime, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        ArrayList results = new ArrayList(list.size());
        try {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction != null) {
                V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                int index = 0;
                for (Object object : list) {
                    results.add(v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(index), thisObject));
                    ++index;
                }
            }
            try (V8ValueArray v8ValueArray = V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());){
                V8ValueArray v8ValueArray2 = (V8ValueArray)v8ValueArray.flat();
                return v8ValueArray2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            JavetResourceUtils.safeClose(results);
        }
    }

    private static /* synthetic */ V8Value lambda$flat$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        int depth = V8ValueUtils.asInt(v8Values, 0, 1);
        ArrayList results = new ArrayList(list.size());
        ListUtils.flat(results, list, depth);
        return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
    }

    private static /* synthetic */ V8Value lambda$findLastIndex$a2aa4572$1(V8Runtime v8Runtime, List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction != null) {
            V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
            int index = list.size() - 1;
            ListIterator listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, listIterator.previous(), v8Runtime.createV8ValueInteger(index), thisObject);){
                    if (result.asBoolean()) {
                        V8ValueInteger v8ValueInteger = v8Runtime.createV8ValueInteger(index);
                        return v8ValueInteger;
                    }
                }
                --index;
            }
        }
        return v8Runtime.createV8ValueInteger(-1);
    }

    private static /* synthetic */ V8Value lambda$findLast$a2aa4572$1(V8Runtime v8Runtime, List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction != null) {
            V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
            int index = list.size() - 1;
            ListIterator listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Object object = listIterator.previous();
                try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(index), thisObject);){
                    if (result.asBoolean()) {
                        Object v = v8Runtime.toV8Value(object);
                        return v;
                    }
                }
                --index;
            }
        }
        return v8Runtime.createV8ValueUndefined();
    }

    private static /* synthetic */ V8Value lambda$findIndex$a2aa4572$1(V8Runtime v8Runtime, List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction != null) {
            V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
            int index = 0;
            for (Object object : list) {
                try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(index), thisObject);){
                    if (result.asBoolean()) {
                        V8ValueInteger v8ValueInteger = v8Runtime.createV8ValueInteger(index);
                        return v8ValueInteger;
                    }
                }
                ++index;
            }
        }
        return v8Runtime.createV8ValueInteger(-1);
    }

    private static /* synthetic */ V8Value lambda$find$a2aa4572$1(V8Runtime v8Runtime, List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction != null) {
            V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
            int index = 0;
            for (Object object : list) {
                try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(index), thisObject);){
                    if (result.asBoolean()) {
                        Object v = v8Runtime.toV8Value(object);
                        return v;
                    }
                }
                ++index;
            }
        }
        return v8Runtime.createV8ValueUndefined();
    }

    private static /* synthetic */ V8Value lambda$filter$bc245072$1(List list, V8Runtime v8Runtime, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        ArrayList results = new ArrayList(list.size());
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction != null) {
            V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
            int index = 0;
            for (Object object : list) {
                try (Object v8ValueResult = v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(index), thisObject);){
                    if (v8ValueResult.asBoolean()) {
                        results.add(object);
                    }
                }
                ++index;
            }
        }
        return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
    }

    private static /* synthetic */ V8Value lambda$fill$bc245072$1(List list, V8Runtime v8Runtime, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        if (!list.isEmpty() && ArrayUtils.isNotEmpty(v8Values)) {
            int endIndex;
            int length = list.size();
            V8Value v8Value = v8Values[0];
            int startIndex = V8ValueUtils.asInt(v8Values, 1);
            if (startIndex < 0 && (startIndex += length) < 0) {
                startIndex = 0;
            }
            if ((endIndex = V8ValueUtils.asInt(v8Values, 2)) < 0 && (endIndex += length) < 0) {
                endIndex = 0;
            }
            if (endIndex == 0) {
                endIndex = length;
            }
            if (startIndex < length && endIndex > startIndex) {
                for (int i = startIndex; i < endIndex; ++i) {
                    list.set(i, v8Runtime.toObject(v8Value));
                }
            }
        }
        return thisObject;
    }

    private static /* synthetic */ V8Value lambda$every$a2aa4572$1(V8Runtime v8Runtime, List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction != null) {
            V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
            int index = 0;
            for (Object object : list) {
                try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(index), thisObject);){
                    if (!result.asBoolean()) {
                        V8ValueBoolean v8ValueBoolean = v8Runtime.createV8ValueBoolean(false);
                        return v8ValueBoolean;
                    }
                }
                ++index;
            }
            return v8Runtime.createV8ValueBoolean(true);
        }
        return v8Runtime.createV8ValueBoolean(false);
    }

    private static /* synthetic */ List lambda$entries$0(List list, int i) {
        return SimpleList.of(i, list.get(i));
    }

    private static /* synthetic */ V8Value lambda$copyWithin$4a84cd3e$1(List list, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        Object[] objects = list.toArray();
        if (!list.isEmpty() && ArrayUtils.isNotEmpty(v8Values)) {
            int endIndex;
            int startIndex;
            int length = list.size();
            int targetIndex = V8ValueUtils.asInt(v8Values, 0);
            if (targetIndex < 0 && (targetIndex += length) < 0) {
                targetIndex = 0;
            }
            if ((startIndex = V8ValueUtils.asInt(v8Values, 1)) < 0 && (startIndex += length) < 0) {
                startIndex = 0;
            }
            if ((endIndex = V8ValueUtils.asInt(v8Values, 2)) < 0 && (endIndex += length) < 0) {
                endIndex = 0;
            }
            if (endIndex > length) {
                endIndex = length;
            }
            if (endIndex == 0) {
                endIndex = length;
            }
            if (targetIndex < length && startIndex < length && endIndex > startIndex) {
                if (targetIndex + endIndex - startIndex > length) {
                    endIndex = length + startIndex - targetIndex;
                }
                for (int i = startIndex; i < endIndex; ++i) {
                    list.set(targetIndex + i - startIndex, objects[i]);
                }
            }
        }
        return thisObject;
    }

    private static /* synthetic */ V8Value lambda$concat$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        ArrayList<V8Value> results = new ArrayList<V8Value>(list.size());
        if (!list.isEmpty()) {
            results.addAll(list);
        }
        if (ArrayUtils.isNotEmpty(v8Values)) {
            for (V8Value v8Value : v8Values) {
                if (v8Value instanceof IV8ValueArray) {
                    IV8ValueArray iV8ValueArray = (IV8ValueArray)((Object)v8Value);
                    V8Value[] items = new V8Value[iV8ValueArray.getLength()];
                    if (!ArrayUtils.isNotEmpty(items)) continue;
                    iV8ValueArray.batchGet(items, 0, items.length);
                    Collections.addAll(results, items);
                    continue;
                }
                Object object = v8Runtime.toObject(v8Value);
                if (object instanceof List) {
                    Collections.addAll(results, (List)object);
                    continue;
                }
                if (object != null && object.getClass().isArray()) {
                    ListUtils.addAll(results, object);
                    continue;
                }
                results.add(v8Value);
            }
        }
        return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
    }

    private static /* synthetic */ V8Value lambda$at$b1f2c293$1(List list, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        int length = list.size();
        int index = V8ValueUtils.asInt(v8Values, 0);
        if (index < 0) {
            index += length;
        }
        if (index >= 0 && index < length) {
            return v8Runtime.toV8Value(list.get(index));
        }
        return v8Runtime.createV8ValueUndefined();
    }
}

