/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy.plugins;

import com.caoccao.javet.enums.V8ValueErrorType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.exceptions.V8ErrorTemplate;
import com.caoccao.javet.interfaces.IJavetEntityPropertyDescriptor;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.binding.IClassProxyPlugin;
import com.caoccao.javet.interop.binding.IClassProxyPluginFunction;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.converters.JavetObjectConverter;
import com.caoccao.javet.interop.converters.JavetProxyConverter;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueFunction;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Set;

public abstract class BaseJavetProxyPlugin
implements IClassProxyPlugin {
    protected static final String HINT_BOOLEAN = "boolean";
    protected static final String HINT_DEFAULT = "default";
    protected static final String HINT_NUMBER = "number";
    protected static final String HINT_STRING = "string";
    protected static final JavetObjectConverter OBJECT_CONVERTER = new JavetObjectConverter();
    protected static final JavetProxyConverter PROXY_CONVERTER = new JavetProxyConverter();
    protected static final String TO_JSON = "toJSON";
    protected static final String TO_STRING = "toString";
    protected static final String VALUE_OF = "valueOf";

    protected V8Value callWithObjectConverter(String functionName, V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Objects.requireNonNull(functionName);
        Objects.requireNonNull(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(functionName, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            try (V8ValueFunction v8ValueFunction = (V8ValueFunction)v8Runtime.getExecutor(functionName).execute();){
                Object t = v8ValueFunction.call((V8Value)OBJECT_CONVERTER.toV8Value(v8Runtime, targetObject), v8Values);
                return t;
            }
        }));
    }

    @Override
    public boolean deleteByObject(Object targetObject, Object propertyKey) {
        return false;
    }

    @Override
    public Object getByIndex(Object targetObject, int index) {
        return null;
    }

    @Override
    public <E extends Exception> IClassProxyPluginFunction<E> getProxyGetBySymbol(Class<?> targetClass, String symbolName) {
        if ("Symbol.toPrimitive".equals(symbolName)) {
            return this::symbolToPrimitive;
        }
        return null;
    }

    @Override
    public Object[] getProxyOwnKeys(Object targetObject) {
        return new Object[0];
    }

    @Override
    public <T> IJavetEntityPropertyDescriptor<T> getProxyOwnPropertyDescriptor(Object targetObject, Object propertyName) {
        return null;
    }

    @Override
    public <E extends Exception> IClassProxyPluginFunction<E> getProxySymbolToPrimitive() {
        return this::symbolToPrimitive;
    }

    @Override
    public <E extends Exception> IClassProxyPluginFunction<E> getTargetObjectConstructor(Class<?> targetClass) {
        return (v8Runtime, targetObject) -> null;
    }

    @Override
    public boolean hasByObject(Object targetObject, Object propertyKey) {
        return false;
    }

    @Override
    public boolean isDeleteSupported(Class<?> targetClass) {
        return false;
    }

    @Override
    public boolean isHasSupported(Class<?> targetClass) {
        return false;
    }

    @Override
    public boolean isIndexSupported(Class<?> targetClass) {
        return false;
    }

    @Override
    public boolean isOwnKeysSupported(Class<?> targetClass) {
        return false;
    }

    @Override
    public boolean isUniqueKeySupported(Class<?> targetClass) {
        return false;
    }

    @Override
    public void populateUniqueKeys(Set<String> uniqueKeySet, Object targetObject) {
    }

    @Override
    public boolean setByIndex(Object targetObject, int index, Object value) {
        return false;
    }

    public V8Value symbolToPrimitive(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("Symbol.toPrimitive", targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            if (targetObject != null) {
                String hintString = V8ValueUtils.asString(v8Values, 0, null);
                if (HINT_NUMBER.equals(hintString)) {
                    if (targetObject instanceof Integer) {
                        return v8Runtime.createV8ValueInteger((Integer)targetObject);
                    }
                    if (targetObject instanceof Double) {
                        return v8Runtime.createV8ValueDouble((Double)targetObject);
                    }
                    if (targetObject instanceof Long) {
                        return v8Runtime.createV8ValueInteger(((Long)targetObject).intValue());
                    }
                    if (targetObject instanceof Float) {
                        return v8Runtime.createV8ValueDouble(((Float)targetObject).doubleValue());
                    }
                    if (targetObject instanceof Short) {
                        return v8Runtime.createV8ValueInteger(((Short)targetObject).intValue());
                    }
                    if (targetObject instanceof Boolean) {
                        return v8Runtime.createV8ValueInteger((Boolean)targetObject != false ? 1 : 0);
                    }
                    if (targetObject instanceof BigInteger) {
                        return v8Runtime.createV8ValueBigInteger((BigInteger)targetObject);
                    }
                    return v8Runtime.createV8ValueInteger(0);
                }
                if (HINT_STRING.equals(hintString)) {
                    return v8Runtime.createV8ValueString(targetObject.toString());
                }
                if (HINT_BOOLEAN.equals(hintString)) {
                    if (targetObject instanceof Boolean) {
                        return v8Runtime.createV8ValueBoolean((Boolean)targetObject);
                    }
                    if (targetObject instanceof Integer) {
                        return v8Runtime.createV8ValueBoolean((Integer)targetObject != 0);
                    }
                    if (targetObject instanceof Double) {
                        double value = (Double)targetObject;
                        return v8Runtime.createV8ValueBoolean(value != 0.0 && !Double.isNaN(value) && Double.isFinite(value));
                    }
                    if (targetObject instanceof Long) {
                        return v8Runtime.createV8ValueBoolean((Long)targetObject != 0L);
                    }
                    if (targetObject instanceof Float) {
                        float value = ((Float)targetObject).floatValue();
                        return v8Runtime.createV8ValueBoolean(value != 0.0f && !Float.isNaN(value) && Float.isFinite(value));
                    }
                    if (targetObject instanceof Short) {
                        return v8Runtime.createV8ValueBoolean((Short)targetObject != 0);
                    }
                    if (targetObject instanceof String) {
                        return v8Runtime.createV8ValueBoolean(StringUtils.isNotEmpty((String)targetObject));
                    }
                    if (targetObject instanceof Character) {
                        return v8Runtime.createV8ValueBoolean(true);
                    }
                    if (targetObject instanceof BigInteger) {
                        return v8Runtime.createV8ValueBoolean(!BigInteger.ZERO.equals(targetObject));
                    }
                    return v8Runtime.createV8ValueBoolean(false);
                }
                if (HINT_DEFAULT.equals(hintString)) {
                    if (targetObject instanceof Integer) {
                        return v8Runtime.createV8ValueInteger((Integer)targetObject);
                    }
                    if (targetObject instanceof Double) {
                        return v8Runtime.createV8ValueDouble((Double)targetObject);
                    }
                    if (targetObject instanceof Long) {
                        return v8Runtime.createV8ValueLong((Long)targetObject);
                    }
                    if (targetObject instanceof Float) {
                        return v8Runtime.createV8ValueDouble(((Float)targetObject).doubleValue());
                    }
                    if (targetObject instanceof Short) {
                        return v8Runtime.createV8ValueInteger(((Short)targetObject).intValue());
                    }
                    if (targetObject instanceof Boolean) {
                        return v8Runtime.createV8ValueBoolean((Boolean)targetObject);
                    }
                    if (targetObject instanceof BigInteger) {
                        return v8Runtime.createV8ValueBigInteger((BigInteger)targetObject);
                    }
                    return v8Runtime.createV8ValueString(targetObject.toString());
                }
            }
            return OBJECT_CONVERTER.toV8Value(v8Runtime, targetObject);
        }));
    }

    protected V8Value typeErrorFunctionIsNotSupported(String functionName, V8Runtime v8Runtime) {
        String message = V8ErrorTemplate.typeErrorFunctionIsNotSupported(functionName);
        Objects.requireNonNull(v8Runtime).throwError(V8ValueErrorType.TypeError, message);
        return v8Runtime.createV8ValueUndefined();
    }
}

