/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine.observers;

import com.caoccao.javet.enums.V8AllocationSpace;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.observers.IV8RuntimeObserver;
import com.caoccao.javet.interop.monitoring.V8HeapSpaceStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V8RuntimeObserverAverageV8HeapSpaceStatistics
implements IV8RuntimeObserver<V8HeapSpaceStatistics> {
    protected final V8AllocationSpace v8AllocationSpace;
    protected final List<V8HeapSpaceStatistics> v8HeapSpaceStatisticsList;

    public V8RuntimeObserverAverageV8HeapSpaceStatistics(V8AllocationSpace v8AllocationSpace) {
        this(v8AllocationSpace, 256);
    }

    public V8RuntimeObserverAverageV8HeapSpaceStatistics(V8AllocationSpace v8AllocationSpace, int capacity) {
        this.v8AllocationSpace = Objects.requireNonNull(v8AllocationSpace);
        this.v8HeapSpaceStatisticsList = new ArrayList<V8HeapSpaceStatistics>(capacity);
    }

    @Override
    public V8HeapSpaceStatistics getResult() {
        long physicalSpaceSize = 0L;
        long spaceAvailableSize = 0L;
        String spaceName = "";
        long spaceSize = 0L;
        long spaceUsedSize = 0L;
        if (!this.v8HeapSpaceStatisticsList.isEmpty()) {
            for (V8HeapSpaceStatistics v8HeapSpaceStatistics : this.v8HeapSpaceStatisticsList) {
                if (spaceName.isEmpty()) {
                    spaceName = v8HeapSpaceStatistics.getSpaceName();
                }
                physicalSpaceSize += v8HeapSpaceStatistics.getPhysicalSpaceSize();
                spaceAvailableSize += v8HeapSpaceStatistics.getSpaceAvailableSize();
                spaceSize += v8HeapSpaceStatistics.getSpaceSize();
                spaceUsedSize += v8HeapSpaceStatistics.getSpaceUsedSize();
            }
            int v8RuntimeCount = this.v8HeapSpaceStatisticsList.size();
            physicalSpaceSize /= (long)v8RuntimeCount;
            spaceAvailableSize /= (long)v8RuntimeCount;
            spaceSize /= (long)v8RuntimeCount;
            spaceUsedSize /= (long)v8RuntimeCount;
        }
        return new V8HeapSpaceStatistics(spaceName, physicalSpaceSize, spaceAvailableSize, spaceSize, spaceUsedSize).setAllocationSpace(this.v8AllocationSpace);
    }

    @Override
    public boolean observe(V8Runtime v8Runtime) {
        this.v8HeapSpaceStatisticsList.add(v8Runtime.getV8HeapSpaceStatistics(this.v8AllocationSpace));
        return true;
    }

    @Override
    public void reset() {
        this.v8HeapSpaceStatisticsList.clear();
    }
}

