/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.converters;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.converters.BaseJavetConverter;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class JavetPrimitiveConverter
extends BaseJavetConverter {
    @Override
    protected <T> T toObject(V8Value v8Value, int depth) throws JavetException {
        this.validateDepth(depth);
        if (v8Value == null || v8Value.isNull() || v8Value.isUndefined()) {
            return null;
        }
        if (v8Value instanceof V8ValuePrimitive) {
            return (T)((V8ValuePrimitive)v8Value).getValue();
        }
        return (T)v8Value;
    }

    @Override
    protected <T extends V8Value> T toV8Value(V8Runtime v8Runtime, Object object, int depth) throws JavetException {
        Optional optional;
        Class<?> objectClass;
        this.validateDepth(depth);
        Object v8Value = object == null ? v8Runtime.createV8ValueNull() : (object.getClass().isPrimitive() ? ((objectClass = object.getClass()) == Integer.TYPE ? v8Runtime.createV8ValueInteger((Integer)object) : (objectClass == Boolean.TYPE ? v8Runtime.createV8ValueBoolean((Boolean)object) : (objectClass == Double.TYPE ? v8Runtime.createV8ValueDouble((Double)object) : (objectClass == Float.TYPE ? v8Runtime.createV8ValueDouble((Double)object) : (objectClass == Long.TYPE ? v8Runtime.createV8ValueLong((Long)object) : (objectClass == Short.TYPE ? v8Runtime.createV8ValueInteger((Integer)object) : (objectClass == Byte.TYPE ? v8Runtime.createV8ValueInteger((Integer)object) : (objectClass == Character.TYPE ? v8Runtime.createV8ValueString(Character.toString(((Character)object).charValue())) : v8Runtime.createV8ValueUndefined())))))))) : (object instanceof V8Value ? (V8Value)object : (object instanceof Integer ? v8Runtime.createV8ValueInteger((Integer)object) : (object instanceof Boolean ? v8Runtime.createV8ValueBoolean((Boolean)object) : (object instanceof String ? v8Runtime.createV8ValueString((String)object) : (object instanceof Double ? v8Runtime.createV8ValueDouble((Double)object) : (object instanceof Float ? v8Runtime.createV8ValueDouble(((Float)object).floatValue()) : (object instanceof Long ? v8Runtime.createV8ValueLong((Long)object) : (object instanceof Short ? v8Runtime.createV8ValueInteger(((Short)object).shortValue()) : (object instanceof ZonedDateTime ? v8Runtime.createV8ValueZonedDateTime((ZonedDateTime)object) : (object instanceof Byte ? v8Runtime.createV8ValueInteger(((Byte)object).byteValue()) : (object instanceof Character ? v8Runtime.createV8ValueString(((Character)object).toString()) : (object instanceof BigInteger ? v8Runtime.createV8ValueBigInteger((BigInteger)object) : (object instanceof Optional ? ((optional = (Optional)object).isPresent() ? this.toV8Value(v8Runtime, optional.get(), depth) : v8Runtime.createV8ValueNull()) : (object instanceof OptionalInt ? ((optional = (OptionalInt)object).isPresent() ? this.toV8Value(v8Runtime, optional.getAsInt(), depth) : v8Runtime.createV8ValueNull()) : (object instanceof OptionalDouble ? ((optional = (OptionalDouble)object).isPresent() ? this.toV8Value(v8Runtime, optional.getAsDouble(), depth) : v8Runtime.createV8ValueNull()) : (object instanceof OptionalLong ? ((optional = (OptionalLong)object).isPresent() ? this.toV8Value(v8Runtime, optional.getAsLong(), depth) : v8Runtime.createV8ValueNull()) : v8Runtime.createV8ValueUndefined())))))))))))))))));
        return (T)v8Value;
    }
}

