/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.IV8Convertible;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBigInteger;
import com.caoccao.javet.values.primitive.V8ValueZonedDateTime;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public interface IV8Executable
extends IV8Convertible {
    default public <T extends V8Value> T execute() throws JavetException {
        return this.execute(true);
    }

    public <T extends V8Value> T execute(boolean var1) throws JavetException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public BigInteger executeBigInteger() throws JavetException {
        try (Object v8Value = this.execute();){
            if (!(v8Value instanceof V8ValueBigInteger)) return null;
            BigInteger bigInteger = (BigInteger)((V8ValueBigInteger)v8Value).getValue();
            return bigInteger;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable7) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Boolean executeBoolean() throws JavetException {
        try (Object v8Value = this.execute();){
            Boolean bl = v8Value.asBoolean();
            return bl;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Double executeDouble() throws JavetException {
        try (Object v8Value = this.execute();){
            Double d = v8Value.asDouble();
            return d;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Integer executeInteger() throws JavetException {
        try (Object v8Value = this.execute();){
            Integer n = v8Value.asInt();
            return n;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Long executeLong() throws JavetException {
        try (Object v8Value = this.execute();){
            Long l = v8Value.asLong();
            return l;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T executeObject() throws JavetException {
        try (T v8Value = this.execute();){
            Object t = this.toObject(v8Value);
            return t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public String executeString() throws JavetException {
        try (Object v8Value = this.execute();){
            if (v8Value.isNullOrUndefined()) {
                String string2 = null;
                return string2;
            }
            String string = v8Value.asString();
            return string;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable7) {
            return null;
        }
    }

    default public void executeVoid() throws JavetException {
        this.execute(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public ZonedDateTime executeZonedDateTime() throws JavetException {
        try (Object v8Value = this.execute();){
            if (!(v8Value instanceof V8ValueZonedDateTime)) return null;
            ZonedDateTime zonedDateTime = (ZonedDateTime)((V8ValueZonedDateTime)v8Value).getValue();
            return zonedDateTime;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable7) {
            // empty catch block
        }
        return null;
    }
}

