/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public enum V8ValueErrorType {
    Error(0, "Error"),
    RangeError(1, "RangeError"),
    ReferenceError(2, "ReferenceError"),
    SyntaxError(3, "SyntaxError"),
    TypeError(4, "TypeError"),
    WasmCompileError(5, "CompileError"),
    WasmLinkError(6, "LinkError"),
    WasmRuntimeError(7, "RuntimeError"),
    UnknownError(8, "UnknownError");

    private static final int LENGTH;
    private static final Map<String, V8ValueErrorType> NAME_MAP;
    private static final V8ValueErrorType[] TYPES;
    private final int id;
    private final String name;

    private V8ValueErrorType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static V8ValueErrorType parse(int id) {
        return id >= 0 && id < LENGTH ? TYPES[id] : UnknownError;
    }

    public static V8ValueErrorType parse(String name) {
        return NAME_MAP.getOrDefault(name, UnknownError);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    static {
        LENGTH = V8ValueErrorType.values().length;
        NAME_MAP = new HashMap<String, V8ValueErrorType>();
        TYPES = new V8ValueErrorType[LENGTH];
        Stream.of(V8ValueErrorType.values()).forEach(v -> {
            V8ValueErrorType.TYPES[v.getId()] = v;
            NAME_MAP.put(v.getName(), (V8ValueErrorType)((Object)v));
        });
    }
}

