/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import java.util.stream.Stream;

public enum JSScopeType {
    Class(0, "Class"),
    Eval(1, "Eval"),
    Function(2, "Function"),
    Module(3, "Module"),
    Script(4, "Script"),
    Catch(5, "Catch"),
    Block(6, "Block"),
    With(7, "With"),
    Unknown(8, "Unknown");

    private static final int LENGTH;
    private static final JSScopeType[] TYPES;
    private final int id;
    private final String name;

    private JSScopeType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static JSScopeType parse(int id) {
        return id >= 0 && id < LENGTH ? TYPES[id] : Unknown;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBlock() {
        return this == Block;
    }

    public boolean isCatch() {
        return this == Catch;
    }

    public boolean isClass() {
        return this == Class;
    }

    public boolean isEval() {
        return this == Eval;
    }

    public boolean isFunction() {
        return this == Function;
    }

    public boolean isModule() {
        return this == Module;
    }

    public boolean isScript() {
        return this == Script;
    }

    public boolean isWith() {
        return this == With;
    }

    static {
        LENGTH = JSScopeType.values().length;
        TYPES = new JSScopeType[LENGTH];
        Stream.of(JSScopeType.values()).forEach(v -> {
            JSScopeType.TYPES[v.getId()] = v;
        });
    }
}

