/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import java.util.stream.Stream;

public enum JSFunctionType {
    Native(0, "Native"),
    API(1, "API"),
    UserDefined(2, "UserDefined"),
    Unknown(3, "Unknown");

    private static final int LENGTH;
    private static final JSFunctionType[] TYPES;
    private final int id;
    private final String name;

    private JSFunctionType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static JSFunctionType parse(int id) {
        return id >= 0 && id < LENGTH ? TYPES[id] : Unknown;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAPI() {
        return this == API;
    }

    public boolean isNative() {
        return this == Native;
    }

    public boolean isUserDefined() {
        return this == UserDefined;
    }

    static {
        LENGTH = JSFunctionType.values().length;
        TYPES = new JSFunctionType[LENGTH];
        Stream.of(JSFunctionType.values()).forEach(v -> {
            JSFunctionType.TYPES[v.getId()] = v;
        });
    }
}

