/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInJson;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInObject;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInPromise;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInReflect;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInSymbol;

public final class V8ValueGlobalObject
extends V8ValueObject {
    V8ValueGlobalObject(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    @Override
    protected void addReference() {
    }

    @Override
    public void clearWeak() {
    }

    @Override
    public void close(boolean forceClose) throws JavetException {
    }

    public V8ValueBuiltInJson getBuiltInJson() throws JavetException {
        Object v8Value = this.v8Runtime.getExecutor("JSON").execute();
        if (v8Value instanceof V8ValueObject) {
            return new V8ValueBuiltInJson(this.v8Runtime, ((V8ValueObject)v8Value).getHandle());
        }
        JavetResourceUtils.safeClose(v8Value);
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", "JSON"));
    }

    public V8ValueBuiltInObject getBuiltInObject() throws JavetException {
        Object v8Value = this.v8Runtime.getExecutor("Object").execute();
        if (v8Value instanceof V8ValueObject) {
            return new V8ValueBuiltInObject(this.v8Runtime, ((V8ValueObject)v8Value).getHandle());
        }
        JavetResourceUtils.safeClose(v8Value);
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", "Object"));
    }

    public V8ValueBuiltInPromise getBuiltInPromise() throws JavetException {
        Object v8Value = this.v8Runtime.getExecutor("Promise").execute();
        if (v8Value instanceof V8ValueObject) {
            return new V8ValueBuiltInPromise(this.v8Runtime, ((V8ValueObject)v8Value).getHandle());
        }
        JavetResourceUtils.safeClose(v8Value);
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", "Promise"));
    }

    public V8ValueBuiltInReflect getBuiltInReflect() throws JavetException {
        Object v8Value = this.v8Runtime.getExecutor("Reflect").execute();
        if (v8Value instanceof V8ValueObject) {
            return new V8ValueBuiltInReflect(this.v8Runtime, ((V8ValueObject)v8Value).getHandle());
        }
        JavetResourceUtils.safeClose(v8Value);
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", "Reflect"));
    }

    public V8ValueBuiltInSymbol getBuiltInSymbol() throws JavetException {
        Object v8Value = this.v8Runtime.getExecutor("Symbol").execute();
        if (v8Value instanceof V8ValueObject) {
            return new V8ValueBuiltInSymbol(this.v8Runtime, ((V8ValueObject)v8Value).getHandle());
        }
        JavetResourceUtils.safeClose(v8Value);
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", "Symbol"));
    }

    @Override
    public boolean isWeak() {
        return false;
    }

    @Override
    protected void removeReference() {
    }

    @Override
    public void setWeak() {
    }

    public V8ValueGlobalObject toClone(boolean referenceCopy) {
        return this;
    }
}

