/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class ThreadSafeMap<TKey, TValue> {
    private Map<TKey, TValue> map;
    private Type type;

    public ThreadSafeMap() {
        this(Type.Permanent);
    }

    public ThreadSafeMap(Type type) {
        this.setType(type);
    }

    public void clear() {
        this.map.clear();
    }

    public TValue get(TKey key) {
        return this.map.get(key);
    }

    public Type getType() {
        return this.type;
    }

    public TValue put(TKey key, TValue value) {
        return this.map.put(key, value);
    }

    public void setType(Type type) {
        Objects.requireNonNull(type);
        if (this.type == null) {
            this.map = type == Type.Weak ? Collections.synchronizedMap(new WeakHashMap()) : new ConcurrentHashMap<TKey, TValue>();
        } else if (this.type != type) {
            this.map = type == Type.Weak ? Collections.synchronizedMap(new WeakHashMap<TKey, TValue>(this.map)) : new ConcurrentHashMap<TKey, TValue>(this.map);
        }
        this.type = type;
    }

    public static enum Type {
        Permanent,
        Weak;

    }
}

