/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import java.util.stream.Stream;

public enum JavetPromiseRejectEvent {
    PromiseRejectWithNoHandler(0, "PromiseRejectWithNoHandler"),
    PromiseHandlerAddedAfterReject(1, "PromiseHandlerAddedAfterReject"),
    PromiseResolveAfterResolved(2, "PromiseResolveAfterResolved"),
    PromiseRejectAfterResolved(3, "PromiseRejectAfterResolved");

    private static final int LENGTH;
    private static final JavetPromiseRejectEvent[] EVENTS;
    private final int code;
    private final String name;

    private JavetPromiseRejectEvent(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static JavetPromiseRejectEvent parse(int code) {
        return code >= 0 && code < LENGTH ? EVENTS[code] : null;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    static {
        LENGTH = JavetPromiseRejectEvent.values().length;
        EVENTS = new JavetPromiseRejectEvent[LENGTH];
        Stream.of(JavetPromiseRejectEvent.values()).forEach(v -> {
            JavetPromiseRejectEvent.EVENTS[v.getCode()] = v;
        });
    }
}

