/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.exceptions;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetEntityError;
import com.caoccao.javet.interop.converters.JavetObjectConverter;
import com.caoccao.javet.values.V8Value;
import java.util.Map;

public final class JavetScriptingError {
    private static final JavetObjectConverter CONVERTER = new JavetObjectConverter();
    private static final String DETAILED_MESSAGE = "detailedMessage";
    private static final String MESSAGE = "message";
    private static final String STACK = "stack";
    private final int endColumn;
    private final int endPosition;
    private final int lineNumber;
    private final String message;
    private final String resourceName;
    private final String sourceLine;
    private final String stack;
    private final int startColumn;
    private final int startPosition;
    private Object context;
    private String detailedMessage;

    JavetScriptingError(V8Value v8Value, String resourceName, String sourceLine, int lineNumber, int startColumn, int endColumn, int startPosition, int endPosition) {
        try {
            this.context = CONVERTER.toObject(v8Value, true);
        }
        catch (JavetException e) {
            this.context = null;
        }
        if (this.context instanceof IJavetEntityError) {
            IJavetEntityError javetEntityError = (IJavetEntityError)this.context;
            this.detailedMessage = javetEntityError.getDetailedMessage();
            this.message = javetEntityError.getMessage();
            this.stack = javetEntityError.getStack();
        } else if (this.context instanceof Map) {
            Map map = (Map)this.context;
            this.detailedMessage = map.containsKey(DETAILED_MESSAGE) ? String.valueOf(map.get(DETAILED_MESSAGE)) : null;
            this.message = String.valueOf(map.getOrDefault(MESSAGE, null));
            this.stack = String.valueOf(map.getOrDefault(STACK, null));
        } else {
            this.detailedMessage = null;
            this.message = null;
            this.stack = null;
        }
        if (this.detailedMessage == null) {
            this.detailedMessage = this.message;
        }
        this.endColumn = endColumn;
        this.endPosition = endPosition;
        this.lineNumber = lineNumber;
        this.resourceName = resourceName;
        this.sourceLine = sourceLine;
        this.startColumn = startColumn;
        this.startPosition = startPosition;
    }

    public Object getContext() {
        return this.context;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getSourceLine() {
        return this.sourceLine;
    }

    public String getStack() {
        return this.stack;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.detailedMessage).append("\n");
        sb.append("Resource: ").append(this.resourceName).append("\n");
        sb.append("Source Code: ").append(this.sourceLine).append("\n");
        sb.append("Line Number: ").append(this.lineNumber).append("\n");
        sb.append("Column: ").append(this.startColumn).append(", ").append(this.endColumn).append("\n");
        sb.append("Position: ").append(this.startPosition).append(", ").append(this.endPosition);
        return sb.toString();
    }
}

