/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import com.caoccao.javet.utils.ArrayUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> boolean includes(List<T> list, T element, int fromIndex) {
        int index = 0;
        for (T item : list) {
            if (Objects.equals(item, element) && index >= fromIndex) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public static <T> T pop(List<T> list) {
        int size = list.size();
        if (size > 0) {
            return list.remove(size - 1);
        }
        return null;
    }

    public static <T> int push(List<T> list, T ... elements) {
        if (ArrayUtils.isNotEmpty(elements)) {
            Collections.addAll(list, elements);
        }
        return list.size();
    }

    public static <T> T shift(List<T> list) {
        int size = list.size();
        if (size > 0) {
            return list.remove(0);
        }
        return null;
    }

    public static <T> int unshift(List<T> list, T ... elements) {
        if (ArrayUtils.isNotEmpty(elements)) {
            list.addAll(0, Arrays.asList(elements));
        }
        return list.size();
    }
}

