/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.enums.V8ConversionMode;
import com.caoccao.javet.enums.V8ProxyMode;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.V8Scope;
import com.caoccao.javet.interop.binding.ClassDescriptor;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.BaseJavetReflectionProxyHandler;
import com.caoccao.javet.interop.proxy.IJavetProxyHandler;
import com.caoccao.javet.interop.proxy.IJavetProxyPolyfillFunction;
import com.caoccao.javet.interop.proxy.IJavetReflectionObjectFactory;
import com.caoccao.javet.interop.proxy.JavetProxySymbolIterableConverter;
import com.caoccao.javet.interop.proxy.JavetProxySymbolToPrimitiveConverter;
import com.caoccao.javet.utils.ArrayUtils;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.ListUtils;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.utils.ThreadSafeMap;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueInteger;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JavetReflectionProxyObjectHandler<T, E extends Exception>
extends BaseJavetReflectionProxyHandler<T, E> {
    protected static final String POLYFILL_LIST_AT = "at";
    protected static final String POLYFILL_LIST_EVERY = "every";
    protected static final String POLYFILL_LIST_INCLUDES = "includes";
    protected static final String POLYFILL_LIST_KEYS = "keys";
    protected static final String POLYFILL_LIST_MAP = "map";
    protected static final String POLYFILL_LIST_POP = "pop";
    protected static final String POLYFILL_LIST_PUSH = "push";
    protected static final String POLYFILL_LIST_REVERSE = "reverse";
    protected static final String POLYFILL_LIST_SHIFT = "shift";
    protected static final String POLYFILL_LIST_SOME = "some";
    protected static final String POLYFILL_LIST_TO_REVERSED = "toReversed";
    protected static final String POLYFILL_LIST_UNSHIFT = "unshift";
    protected static final String POLYFILL_LIST_WITH = "with";
    protected static final String POLYFILL_SET_DELETE = "delete";
    protected static final String POLYFILL_SET_HAS = "has";
    protected static final String POLYFILL_SET_KEYS = "keys";
    protected static final String POLYFILL_SHARED_LENGTH = "length";
    protected static final String POLYFILL_SHARED_TO_JSON = "toJSON";
    protected static final String POLYFILL_SHARED_VALUES = "values";
    protected static final ThreadSafeMap<Class<?>, ClassDescriptor> classDescriptorMap = new ThreadSafeMap();
    protected static final Map<String, IJavetProxyPolyfillFunction<?, ?>> polyfillListFunctionMap = new HashMap();
    protected static final Map<String, IJavetProxyPolyfillFunction<?, ?>> polyfillMapFunctionMap;
    protected static final Map<String, IJavetProxyPolyfillFunction<?, ?>> polyfillSetFunctionMap;

    public JavetReflectionProxyObjectHandler(V8Runtime v8Runtime, IJavetReflectionObjectFactory reflectionObjectFactory, T targetObject) {
        super(v8Runtime, reflectionObjectFactory, Objects.requireNonNull(targetObject));
    }

    protected static V8Value polyfillListAt(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_AT, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            if (ArrayUtils.isNotEmpty(v8Values) && v8Values[0] instanceof V8ValueInteger) {
                int size = list.size();
                int index = (Integer)((V8ValueInteger)v8Values[0]).getValue();
                if (index < 0) {
                    index += size;
                }
                if (index >= 0 && index < size) {
                    return handler.getV8Runtime().toV8Value(list.get(index));
                }
            }
            return handler.getV8Runtime().createV8ValueUndefined();
        }));
    }

    protected static V8Value polyfillListEvery(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_EVERY, handler, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            boolean valid = false;
            if (ArrayUtils.isNotEmpty(v8Values) && v8Values[0] instanceof V8ValueFunction) {
                V8ValueFunction v8ValueFunction = (V8ValueFunction)v8Values[0];
                IV8ValueObject thisArg = v8Values.length > 1 && v8Values[1] instanceof IV8ValueObject ? (IV8ValueObject)((Object)v8Values[1]) : null;
                int index = 0;
                valid = true;
                for (Object object : list) {
                    try (Object result = v8ValueFunction.call(thisArg, object, index, thisObject);){
                        if (!(result instanceof V8ValueBoolean) || !((Boolean)((V8ValueBoolean)result).getValue()).booleanValue()) {
                            valid = false;
                            break;
                        }
                    }
                    ++index;
                }
            }
            return handler.getV8Runtime().createV8ValueBoolean(valid);
        }));
    }

    protected static V8Value polyfillListIncludes(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_INCLUDES, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            boolean included = false;
            if (ArrayUtils.isNotEmpty(v8Values)) {
                Object object = handler.getV8Runtime().toObject(v8Values[0]);
                int fromIndex = 0;
                if (v8Values.length > 1 && v8Values[1] instanceof V8ValueInteger) {
                    fromIndex = (Integer)((V8ValueInteger)v8Values[1]).getValue();
                }
                included = ListUtils.includes(list, object, fromIndex);
            }
            return handler.getV8Runtime().createV8ValueBoolean(included);
        }));
    }

    protected static V8Value polyfillListKeys(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext("keys", handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int size = list.size();
            Object[] indexes = new Object[size];
            for (int i = 0; i < size; ++i) {
                indexes[i] = handler.getV8Runtime().createV8ValueInteger(i);
            }
            try (V8Scope v8Scope = handler.getV8Runtime().getV8Scope();){
                V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
                if (size > 0) {
                    v8ValueArray.push(indexes);
                }
                v8Scope.setEscapable();
                V8ValueArray v8ValueArray2 = v8ValueArray;
                return v8ValueArray2;
            }
        }));
    }

    protected static V8Value polyfillListLength(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueInteger(list.size());
    }

    protected static V8Value polyfillListMap(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_MAP, handler, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            try (V8Scope v8Scope = handler.getV8Runtime().getV8Scope();){
                V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
                if (ArrayUtils.isNotEmpty(v8Values) && v8Values[0] instanceof V8ValueFunction) {
                    V8ValueFunction v8ValueFunction = (V8ValueFunction)v8Values[0];
                    IV8ValueObject thisArg = v8Values.length > 1 && v8Values[1] instanceof IV8ValueObject ? (IV8ValueObject)((Object)v8Values[1]) : null;
                    ArrayList results = new ArrayList(list.size());
                    try {
                        int index = 0;
                        for (Object object : list) {
                            results.add(v8ValueFunction.call(thisArg, object, index, thisObject));
                            ++index;
                        }
                        v8ValueArray.push(results.toArray());
                    }
                    finally {
                        JavetResourceUtils.safeClose(results);
                    }
                }
                v8Scope.setEscapable();
                V8ValueArray v8ValueArray2 = v8ValueArray;
                return v8ValueArray2;
            }
        }));
    }

    protected static V8Value polyfillListPop(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_POP, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            if (list.isEmpty()) {
                return handler.getV8Runtime().createV8ValueUndefined();
            }
            return handler.getV8Runtime().toV8Value(ListUtils.pop(list));
        }));
    }

    protected static V8Value polyfillListPush(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_PUSH, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> handler.getV8Runtime().createV8ValueInteger(ListUtils.push(list, V8ValueUtils.toArray(handler.getV8Runtime(), v8Values)))));
    }

    protected static V8Value polyfillListReverse(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_REVERSE, handler, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            if (!list.isEmpty()) {
                Collections.reverse(list);
            }
            return thisObject;
        }));
    }

    protected static V8Value polyfillListShift(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_SHIFT, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            if (list.isEmpty()) {
                return handler.getV8Runtime().createV8ValueUndefined();
            }
            return handler.getV8Runtime().toV8Value(ListUtils.shift(list));
        }));
    }

    protected static V8Value polyfillListSome(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_SOME, handler, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            boolean valid = false;
            if (ArrayUtils.isNotEmpty(v8Values) && v8Values[0] instanceof V8ValueFunction) {
                V8ValueFunction v8ValueFunction = (V8ValueFunction)v8Values[0];
                IV8ValueObject thisArg = v8Values.length > 1 && v8Values[1] instanceof IV8ValueObject ? (IV8ValueObject)((Object)v8Values[1]) : null;
                int index = 0;
                for (Object object : list) {
                    try (Object result = v8ValueFunction.call(thisArg, object, index, thisObject);){
                        if (result instanceof V8ValueBoolean && ((Boolean)((V8ValueBoolean)result).getValue()).booleanValue()) {
                            valid = true;
                            break;
                        }
                    }
                    ++index;
                }
            }
            return handler.getV8Runtime().createV8ValueBoolean(valid);
        }));
    }

    protected static V8Value polyfillListToJSON(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_SHARED_TO_JSON, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            Object[] objects = list.toArray();
            try (V8Scope v8Scope = handler.getV8Runtime().getV8Scope();){
                V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
                v8ValueArray.push(objects);
                v8Scope.setEscapable();
                V8ValueArray v8ValueArray2 = v8ValueArray;
                return v8ValueArray2;
            }
        }));
    }

    protected static V8Value polyfillListToReversed(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_TO_REVERSED, handler, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            try (V8Scope v8Scope = handler.getV8Runtime().getV8Scope();){
                V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
                if (!list.isEmpty()) {
                    ArrayList reversedList = new ArrayList(list);
                    Collections.reverse(reversedList);
                    v8ValueArray.push(reversedList.toArray());
                }
                v8Scope.setEscapable();
                V8ValueArray v8ValueArray2 = v8ValueArray;
                return v8ValueArray2;
            }
        }));
    }

    protected static V8Value polyfillListUnshift(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_UNSHIFT, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> handler.getV8Runtime().createV8ValueInteger(ListUtils.unshift(list, V8ValueUtils.toArray(handler.getV8Runtime(), v8Values)))));
    }

    protected static V8Value polyfillListWith(IJavetProxyHandler<?, ?> handler) throws JavetException {
        List list = (List)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_LIST_WITH, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            try (V8Scope v8Scope = handler.getV8Runtime().getV8Scope();){
                int toBeReplacedIndex;
                Object[] objects = list.toArray();
                V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
                if (v8Values != null && v8Values.length > 1 && v8Values[0] instanceof V8ValueInteger && (toBeReplacedIndex = ((Integer)((V8ValueInteger)v8Values[0]).getValue()).intValue()) >= 0 && toBeReplacedIndex < objects.length) {
                    objects[toBeReplacedIndex] = handler.getV8Runtime().toObject(v8Values[1]);
                }
                v8ValueArray.push(objects);
                v8Scope.setEscapable();
                V8ValueArray v8ValueArray2 = v8ValueArray;
                return v8ValueArray2;
            }
        }));
    }

    protected static V8Value polyfillMapToJSON(IJavetProxyHandler<?, ?> handler) throws JavetException {
        Map map = (Map)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_SHARED_TO_JSON, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            Object[] objects = new Object[map.size() << 1];
            int index = 0;
            for (Map.Entry entry : map.entrySet()) {
                objects[index] = entry.getKey();
                objects[index + 1] = entry.getKey();
                index += 2;
            }
            try (V8Scope v8Scope = handler.getV8Runtime().getV8Scope();){
                V8ValueObject v8ValueObject = v8Scope.createV8ValueObject();
                v8ValueObject.set(objects);
                v8Scope.setEscapable();
                V8ValueObject v8ValueObject2 = v8ValueObject;
                return v8ValueObject2;
            }
        }));
    }

    protected static V8Value polyfillSetDelete(IJavetProxyHandler<?, ?> handler) throws JavetException {
        Set set = (Set)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_SET_DELETE, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            boolean result = false;
            if (v8Values != null && v8Values.length > 0) {
                result = set.remove(handler.getV8Runtime().toObject(v8Values[0]));
            }
            return handler.getV8Runtime().createV8ValueBoolean(result);
        }));
    }

    protected static V8Value polyfillSetHas(IJavetProxyHandler<?, ?> handler) throws JavetException {
        Set set = (Set)handler.getTargetObject();
        return handler.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(POLYFILL_SET_HAS, handler, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            boolean result = false;
            if (v8Values != null && v8Values.length > 0) {
                result = set.contains(handler.getV8Runtime().toObject(v8Values[0]));
            }
            return handler.getV8Runtime().createV8ValueBoolean(result);
        }));
    }

    protected static V8Value polyfillSharedValues(IJavetProxyHandler<?, ?> handler) throws JavetException {
        return new JavetProxySymbolIterableConverter(handler.getV8Runtime(), handler.getTargetObject()).getV8ValueFunction();
    }

    protected boolean deleteFromCollection(V8Value property) throws JavetException {
        if (property instanceof V8ValueString) {
            try {
                int index;
                String propertyString = (String)((V8ValueString)property).getValue();
                if (StringUtils.isDigital(propertyString) && (index = Integer.parseInt(propertyString)) >= 0) {
                    List list;
                    if (this.classDescriptor.getTargetClass().isArray()) {
                        if (index < Array.getLength(this.targetObject) && !this.classDescriptor.getTargetClass().getComponentType().isPrimitive()) {
                            Array.set(this.targetObject, index, null);
                            return true;
                        }
                    } else if (this.classDescriptor.isTargetTypeList() && index < (list = (List)this.targetObject).size()) {
                        list.remove(index);
                        return true;
                    }
                }
                if (this.classDescriptor.isTargetTypeMap()) {
                    Map map = (Map)this.targetObject;
                    return map.remove(propertyString) != null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public V8ValueBoolean deleteProperty(V8Value target, V8Value property) throws JavetException, E {
        boolean result = this.deleteFromCollection(property);
        return super.deleteProperty(target, property);
    }

    @Override
    public V8Value get(V8Value target, V8Value property, V8Value receiver) throws JavetException, E {
        V8Value result = this.getFromCollection(property);
        result = result == null ? this.getFromField(property) : result;
        result = result == null ? this.getFromMethod(target, property) : result;
        result = result == null ? this.getFromSymbol(property) : result;
        result = result == null ? this.getFromGetter(property) : result;
        result = result == null ? this.getFromPolyfill(property) : result;
        return result == null ? this.v8Runtime.createV8ValueUndefined() : result;
    }

    @Override
    public JavetCallbackContext[] getCallbackContexts() {
        if (this.callbackContexts == null) {
            this.callbackContexts = new JavetCallbackContext[]{new JavetCallbackContext("get", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.get(v8Values[0], v8Values[1], v8Values[2])), new JavetCallbackContext("deleteProperty", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.deleteProperty(v8Values[0], v8Values[1])), new JavetCallbackContext(POLYFILL_SET_HAS, (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.has(v8Values[0], v8Values[1])), new JavetCallbackContext("ownKeys", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.ownKeys(v8Values[0])), new JavetCallbackContext("set", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.set(v8Values[0], v8Values[1], v8Values[2], v8Values[3]))};
        }
        return this.callbackContexts;
    }

    @Override
    public ThreadSafeMap<Class<?>, ClassDescriptor> getClassDescriptorCache() {
        return classDescriptorMap;
    }

    protected V8Value getFromCollection(V8Value property) throws JavetException {
        if (property instanceof V8ValueString) {
            String propertyString = (String)((V8ValueString)property).getValue();
            if (StringUtils.isDigital(propertyString)) {
                int index = Integer.parseInt(propertyString);
                if (index >= 0) {
                    List list;
                    if (this.classDescriptor.getTargetClass().isArray()) {
                        if (index < Array.getLength(this.targetObject)) {
                            return this.v8Runtime.toV8Value(Array.get(this.targetObject, index));
                        }
                    } else if (this.classDescriptor.isTargetTypeList() && index < (list = (List)this.targetObject).size()) {
                        return this.v8Runtime.toV8Value(list.get(index));
                    }
                }
            } else if (this.classDescriptor.getTargetClass().isArray() && POLYFILL_SHARED_LENGTH.equals(propertyString)) {
                return this.v8Runtime.toV8Value(Array.getLength(this.targetObject));
            }
        }
        return null;
    }

    protected V8Value getFromPolyfill(V8Value property) throws JavetException, E {
        if (property instanceof V8ValueString) {
            String propertyName = (String)((V8ValueString)property).getValue();
            IJavetProxyPolyfillFunction<?, ?> iJavetProxyPolyfillFunction = null;
            if (this.classDescriptor.isTargetTypeList()) {
                iJavetProxyPolyfillFunction = polyfillListFunctionMap.get(propertyName);
            } else if (this.classDescriptor.isTargetTypeMap()) {
                iJavetProxyPolyfillFunction = polyfillMapFunctionMap.get(propertyName);
            } else if (this.classDescriptor.isTargetTypeSet()) {
                iJavetProxyPolyfillFunction = polyfillSetFunctionMap.get(propertyName);
            }
            if (iJavetProxyPolyfillFunction != null) {
                return iJavetProxyPolyfillFunction.apply(this);
            }
        }
        return null;
    }

    protected V8Value getFromSymbol(V8Value property) throws JavetException {
        if (property instanceof V8ValueSymbol) {
            V8ValueSymbol propertySymbol = (V8ValueSymbol)property;
            String description = propertySymbol.getDescription();
            if ("Symbol.toPrimitive".equals(description)) {
                return new JavetProxySymbolToPrimitiveConverter<Object>(this.v8Runtime, this.targetObject).getV8ValueFunction();
            }
            if ("Symbol.iterator".equals(description) && (this.targetObject instanceof Iterable || this.targetObject instanceof Map || this.classDescriptor.getTargetClass().isArray())) {
                return new JavetProxySymbolIterableConverter<Object>(this.v8Runtime, this.targetObject).getV8ValueFunction();
            }
        }
        return null;
    }

    @Override
    public V8ValueBoolean has(V8Value target, V8Value property) throws JavetException {
        boolean isFound = this.hasFromCollection(property);
        isFound = isFound || this.hasFromRegular(property);
        isFound = isFound || this.hasFromGeneric(property);
        return this.v8Runtime.createV8ValueBoolean(isFound);
    }

    protected boolean hasFromCollection(V8Value property) throws JavetException {
        int index;
        String indexString;
        if (this.classDescriptor.isTargetTypeMap()) {
            return ((Map)this.targetObject).containsKey(this.v8Runtime.toObject(property));
        }
        if (this.classDescriptor.isTargetTypeList()) {
            return ((List)this.targetObject).contains(this.v8Runtime.toObject(property));
        }
        if (this.classDescriptor.isTargetTypeSet()) {
            return ((Set)this.targetObject).contains(this.v8Runtime.toObject(property));
        }
        if (property instanceof V8ValueString && StringUtils.isDigital(indexString = (String)((V8ValueString)property).getValue()) && (index = Integer.parseInt(indexString)) >= 0) {
            if (this.classDescriptor.getTargetClass().isArray()) {
                return index < Array.getLength(this.targetObject);
            }
            if (List.class.isAssignableFrom(this.classDescriptor.getTargetClass())) {
                return index < ((List)this.targetObject).size();
            }
        }
        return false;
    }

    @Override
    protected void initialize() {
        Class<?> targetClass = this.targetObject.getClass();
        this.classDescriptor = classDescriptorMap.get(targetClass);
        if (this.classDescriptor == null) {
            this.classDescriptor = new ClassDescriptor(V8ProxyMode.Object, targetClass);
            if (this.targetObject instanceof Class) {
                this.initializeFieldsAndMethods((Class)this.targetObject, true);
            }
            this.initializeCollection();
            this.initializeFieldsAndMethods(targetClass, false);
            classDescriptorMap.put(targetClass, this.classDescriptor);
        }
    }

    protected void initializeCollection() {
        if (this.classDescriptor.isTargetTypeMap()) {
            ((Map)this.targetObject).keySet().stream().map(Object::toString).filter(Objects::nonNull).forEach(this.classDescriptor.getUniqueKeySet()::add);
        } else if (this.classDescriptor.isTargetTypeSet()) {
            ((Set)this.targetObject).stream().map(Object::toString).filter(Objects::nonNull).forEach(this.classDescriptor.getUniqueKeySet()::add);
        }
    }

    protected void initializeFieldsAndMethods(Class<?> currentClass, boolean staticMode) {
        V8ConversionMode conversionMode = this.classDescriptor.getConversionMode();
        do {
            this.initializePublicFields(currentClass, conversionMode, staticMode);
            this.initializePublicMethods(currentClass, conversionMode, staticMode);
        } while (currentClass != Object.class && (currentClass = currentClass.getSuperclass()) != null);
    }

    @Override
    public V8ValueArray ownKeys(V8Value target) throws JavetException {
        Object[] keys = null;
        if (this.classDescriptor.isTargetTypeMap()) {
            keys = ((Map)this.targetObject).keySet().toArray();
        } else if (this.classDescriptor.isTargetTypeSet()) {
            keys = ((Set)this.targetObject).toArray();
        } else if (this.classDescriptor.getTargetClass().isArray() || Collection.class.isAssignableFrom(this.classDescriptor.getTargetClass())) {
            int length = this.classDescriptor.getTargetClass().isArray() ? Array.getLength(this.targetObject) : ((List)this.targetObject).size();
            keys = new Object[length];
            for (int i = 0; i < length; ++i) {
                keys[i] = i;
            }
        }
        if (keys != null && keys.length > 0) {
            try (V8Scope v8Scope = this.v8Runtime.getV8Scope();){
                V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
                for (Object key : keys) {
                    if (key instanceof String) {
                        v8ValueArray.push(this.v8Runtime.createV8ValueString((String)key));
                        continue;
                    }
                    if (key instanceof V8ValueString || key instanceof V8ValueSymbol) {
                        v8ValueArray.push(key);
                        continue;
                    }
                    if (key == null) continue;
                    v8ValueArray.push(this.v8Runtime.createV8ValueString(key.toString()));
                }
                v8Scope.setEscapable();
                V8ValueArray v8ValueArray2 = v8ValueArray;
                return v8ValueArray2;
            }
        }
        return (V8ValueArray)this.v8Runtime.toV8Value(this.classDescriptor.getUniqueKeySet().toArray());
    }

    @Override
    public V8ValueBoolean set(V8Value target, V8Value propertyKey, V8Value propertyValue, V8Value receiver) throws JavetException {
        boolean isSet = this.setToCollection(propertyKey, propertyValue);
        isSet = isSet || this.setToField(propertyKey, propertyValue);
        isSet = isSet || this.setToSetter(target, propertyKey, propertyValue);
        return this.v8Runtime.createV8ValueBoolean(isSet);
    }

    protected boolean setToCollection(V8Value propertyKey, V8Value propertyValue) throws JavetException {
        int index;
        String propertyKeyString;
        if (propertyKey instanceof V8ValueString && StringUtils.isDigital(propertyKeyString = (String)((V8ValueString)propertyKey).getValue()) && (index = Integer.parseInt(propertyKeyString)) >= 0) {
            List list;
            if (this.classDescriptor.getTargetClass().isArray()) {
                if (index < Array.getLength(this.targetObject)) {
                    Array.set(this.targetObject, index, this.v8Runtime.toObject(propertyValue));
                    return true;
                }
            } else if (this.classDescriptor.isTargetTypeList() && index < (list = (List)this.targetObject).size()) {
                list.set(index, this.v8Runtime.toObject(propertyValue));
                return true;
            }
        }
        return false;
    }

    static {
        polyfillListFunctionMap.put(POLYFILL_LIST_AT, JavetReflectionProxyObjectHandler::polyfillListAt);
        polyfillListFunctionMap.put(POLYFILL_LIST_EVERY, JavetReflectionProxyObjectHandler::polyfillListEvery);
        polyfillListFunctionMap.put(POLYFILL_LIST_INCLUDES, JavetReflectionProxyObjectHandler::polyfillListIncludes);
        polyfillListFunctionMap.put("keys", JavetReflectionProxyObjectHandler::polyfillListKeys);
        polyfillListFunctionMap.put(POLYFILL_SHARED_LENGTH, JavetReflectionProxyObjectHandler::polyfillListLength);
        polyfillListFunctionMap.put(POLYFILL_LIST_MAP, JavetReflectionProxyObjectHandler::polyfillListMap);
        polyfillListFunctionMap.put(POLYFILL_LIST_POP, JavetReflectionProxyObjectHandler::polyfillListPop);
        polyfillListFunctionMap.put(POLYFILL_LIST_PUSH, JavetReflectionProxyObjectHandler::polyfillListPush);
        polyfillListFunctionMap.put(POLYFILL_LIST_REVERSE, JavetReflectionProxyObjectHandler::polyfillListReverse);
        polyfillListFunctionMap.put(POLYFILL_LIST_SHIFT, JavetReflectionProxyObjectHandler::polyfillListShift);
        polyfillListFunctionMap.put(POLYFILL_LIST_SOME, JavetReflectionProxyObjectHandler::polyfillListSome);
        polyfillListFunctionMap.put(POLYFILL_SHARED_TO_JSON, JavetReflectionProxyObjectHandler::polyfillListToJSON);
        polyfillListFunctionMap.put(POLYFILL_LIST_TO_REVERSED, JavetReflectionProxyObjectHandler::polyfillListToReversed);
        polyfillListFunctionMap.put(POLYFILL_LIST_UNSHIFT, JavetReflectionProxyObjectHandler::polyfillListUnshift);
        polyfillListFunctionMap.put(POLYFILL_SHARED_VALUES, JavetReflectionProxyObjectHandler::polyfillSharedValues);
        polyfillListFunctionMap.put(POLYFILL_LIST_WITH, JavetReflectionProxyObjectHandler::polyfillListWith);
        polyfillMapFunctionMap = new HashMap();
        polyfillMapFunctionMap.put(POLYFILL_SHARED_TO_JSON, JavetReflectionProxyObjectHandler::polyfillMapToJSON);
        polyfillSetFunctionMap = new HashMap();
        polyfillSetFunctionMap.put(POLYFILL_SET_DELETE, JavetReflectionProxyObjectHandler::polyfillSetDelete);
        polyfillSetFunctionMap.put(POLYFILL_SET_HAS, JavetReflectionProxyObjectHandler::polyfillSetHas);
        polyfillSetFunctionMap.put("keys", JavetReflectionProxyObjectHandler::polyfillSharedValues);
        polyfillSetFunctionMap.put(POLYFILL_SHARED_VALUES, JavetReflectionProxyObjectHandler::polyfillSharedValues);
    }
}

